/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.initialization.AbstractProjectSpec;

public class ProjectDirectoryProjectSpec
extends AbstractProjectSpec {
    private final File dir;

    public ProjectDirectoryProjectSpec(File dir) {
        this.dir = dir;
    }

    @Override
    protected String formatNoMatchesMessage() {
        return String.format("No projects in this build have project directory '%s'.", this.dir);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> matches) {
        return String.format("Multiple projects in this build have project directory '%s': %s", this.dir, matches);
    }

    @Override
    protected <T extends ProjectIdentifier> void select(ProjectRegistry<? extends T> candidates, List<? super T> matches) {
        for (ProjectIdentifier candidate : candidates.getAllProjects()) {
            if (!candidate.getProjectDir().equals(this.dir)) continue;
            matches.add(candidate);
        }
    }

    @Override
    protected void checkPreconditions(ProjectRegistry<?> registry) {
        if (!this.dir.exists()) {
            throw new InvalidUserDataException(String.format("Project directory '%s' does not exist.", this.dir));
        }
        if (!this.dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Project directory '%s' is not a directory.", this.dir));
        }
    }
}

