/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatistics;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatisticsListener;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.buildevents.BuildResultLogger;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class TaskExecutionStatisticsReporter
implements TaskExecutionStatisticsListener {
    private final StyledTextOutputFactory textOutputFactory;

    public TaskExecutionStatisticsReporter(StyledTextOutputFactory textOutputFactory) {
        this.textOutputFactory = textOutputFactory;
    }

    @Override
    public void buildFinished(TaskExecutionStatistics statistics) {
        int total = statistics.getTotalTaskCount();
        if (total > 0) {
            String pluralizedTasks = total > 1 ? "tasks" : "task";
            StyledTextOutput textOutput = this.textOutputFactory.create(BuildResultLogger.class, LogLevel.LIFECYCLE);
            textOutput.format("%d actionable %s:", new Object[]{total, pluralizedTasks});
            boolean printedDetail = TaskExecutionStatisticsReporter.formatDetail(textOutput, statistics.getExecutedTasksCount(), "executed", false);
            printedDetail = TaskExecutionStatisticsReporter.formatDetail(textOutput, statistics.getFromCacheTaskCount(), "from cache", printedDetail);
            TaskExecutionStatisticsReporter.formatDetail(textOutput, statistics.getUpToDateTaskCount(), "up-to-date", printedDetail);
            textOutput.println();
        }
    }

    private static boolean formatDetail(StyledTextOutput textOutput, int count, String title, boolean alreadyPrintedDetail) {
        if (count == 0) {
            return alreadyPrintedDetail;
        }
        if (alreadyPrintedDetail) {
            textOutput.format(",", new Object[0]);
        }
        textOutput.format(" %d %s", new Object[]{count, title});
        return true;
    }
}

