/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.JarHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.RuntimeClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalFileSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.mirror.RelativePathSegmentsTracker;
import org.gradle.api.internal.changedetection.state.mirror.RelativePathStringTracker;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFingerprint;
import org.gradle.internal.hash.HashCode;

public class ClasspathFingerprintingStrategy
implements FingerprintingStrategy {
    private final NonJarFingerprintingStrategy nonJarFingerprintingStrategy;
    private final ResourceFilter classpathResourceFilter;
    private final ResourceSnapshotterCacheService cacheService;
    private final ResourceHasher classpathResourceHasher;
    private final JarHasher jarHasher;
    private final StringInterner stringInterner;
    private final HashCode jarHasherConfigurationHash;
    private final FingerprintingStrategy.Identifier identifier;

    private ClasspathFingerprintingStrategy(FingerprintingStrategy.Identifier identifier, NonJarFingerprintingStrategy nonJarFingerprintingStrategy, ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        this.identifier = identifier;
        this.nonJarFingerprintingStrategy = nonJarFingerprintingStrategy;
        this.classpathResourceFilter = classpathResourceFilter;
        this.classpathResourceHasher = classpathResourceHasher;
        this.cacheService = cacheService;
        this.stringInterner = stringInterner;
        this.jarHasher = new JarHasher(classpathResourceHasher, classpathResourceFilter);
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        this.jarHasher.appendConfigurationToHasher((BuildCacheHasher)hasher);
        this.jarHasherConfigurationHash = hasher.hash();
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter classpathResourceFilter, RuntimeClasspathResourceHasher runtimeClasspathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        return new ClasspathFingerprintingStrategy(FingerprintingStrategy.Identifier.CLASSPATH, NonJarFingerprintingStrategy.USE_FILE_HASH, runtimeClasspathResourceHasher, classpathResourceFilter, cacheService, stringInterner);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        return new ClasspathFingerprintingStrategy(FingerprintingStrategy.Identifier.COMPILE_CLASSPATH, NonJarFingerprintingStrategy.IGNORE, classpathResourceHasher, ResourceFilter.FILTER_NOTHING, cacheService, stringInterner);
    }

    @Override
    public Map<String, NormalizedFileSnapshot> collectSnapshots(Iterable<FileSystemSnapshot> roots) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<String> processedEntries = new HashSet<String>();
        for (FileSystemSnapshot root : roots) {
            ClasspathSnapshotVisitor snapshotVisitor = new ClasspathSnapshotVisitor(processedEntries, (ImmutableMap.Builder<String, NormalizedFileSnapshot>)builder);
            root.accept(new ClasspathContentSnapshottingVisitor(snapshotVisitor));
        }
        return builder.build();
    }

    @Nullable
    private HashCode fingerprintRootFile(PhysicalFileSnapshot fileSnapshot) {
        if (FileUtils.hasExtensionIgnoresCase((String)fileSnapshot.getName(), (String)".jar")) {
            return this.snapshotJarContents(fileSnapshot);
        }
        return this.nonJarFingerprintingStrategy.determineNonJarFingerprint(fileSnapshot.getHash());
    }

    @Nullable
    private HashCode snapshotJarContents(PhysicalFileSnapshot fileSnapshot) {
        return this.cacheService.hashFile(fileSnapshot, this.jarHasher, this.jarHasherConfigurationHash);
    }

    @Override
    public FingerprintCompareStrategy getCompareStrategy() {
        return FingerprintCompareStrategy.CLASSPATH;
    }

    @Override
    public FingerprintingStrategy.Identifier getIdentifier() {
        return this.identifier;
    }

    private class ClasspathSnapshotVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final HashSet<String> processedEntries;
        private final ImmutableMap.Builder<String, NormalizedFileSnapshot> builder;

        public ClasspathSnapshotVisitor(HashSet<String> processedEntries, ImmutableMap.Builder<String, NormalizedFileSnapshot> builder) {
            this.processedEntries = processedEntries;
            this.builder = builder;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        public boolean preVisitDirectory(PhysicalSnapshot directorySnapshot) {
            this.relativePathStringTracker.enter(directorySnapshot);
            return true;
        }

        public void visit(PhysicalSnapshot fileSnapshot, HashCode normalizedContentHash) {
            String absolutePath = fileSnapshot.getAbsolutePath();
            if (this.processedEntries.add(absolutePath)) {
                NormalizedFileSnapshot normalizedFileSnapshot = this.relativePathStringTracker.isRoot() ? IgnoredPathFingerprint.create(fileSnapshot.getType(), normalizedContentHash) : this.createNormalizedSnapshot(fileSnapshot, normalizedContentHash);
                this.builder.put((Object)absolutePath, (Object)normalizedFileSnapshot);
            }
        }

        private NormalizedFileSnapshot createNormalizedSnapshot(PhysicalSnapshot snapshot, HashCode content) {
            this.relativePathStringTracker.enter(snapshot);
            DefaultNormalizedFileSnapshot normalizedFileSnapshot = new DefaultNormalizedFileSnapshot(ClasspathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), FileType.RegularFile, content);
            this.relativePathStringTracker.leave();
            return normalizedFileSnapshot;
        }

        public void postVisitDirectory() {
            this.relativePathStringTracker.leave();
        }
    }

    private class ClasspathContentSnapshottingVisitor
    implements PhysicalSnapshotVisitor {
        private final ClasspathSnapshotVisitor delegate;
        private final RelativePathSegmentsTracker relativePathSegmentsTracker = new RelativePathSegmentsTracker();
        private final Factory<String[]> relativePathFactory = new Factory<String[]>(){

            public String[] create() {
                return (String[])Iterables.toArray(ClasspathContentSnapshottingVisitor.this.relativePathSegmentsTracker.getRelativePath(), String.class);
            }
        };

        public ClasspathContentSnapshottingVisitor(ClasspathSnapshotVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.enter(directorySnapshot);
            return this.delegate.preVisitDirectory(directorySnapshot);
        }

        @Override
        public void visit(PhysicalSnapshot fileSnapshot) {
            HashCode normalizedContent;
            if (fileSnapshot.getType() == FileType.RegularFile && (normalizedContent = this.fingerprintFile((PhysicalFileSnapshot)fileSnapshot)) != null) {
                this.delegate.visit(fileSnapshot, normalizedContent);
            }
        }

        @Nullable
        private HashCode fingerprintFile(PhysicalFileSnapshot fileSnapshot) {
            return this.relativePathSegmentsTracker.isRoot() ? ClasspathFingerprintingStrategy.this.fingerprintRootFile(fileSnapshot) : this.fingerprintTreeFile(fileSnapshot);
        }

        @Nullable
        private HashCode fingerprintTreeFile(PhysicalFileSnapshot fileSnapshot) {
            this.relativePathSegmentsTracker.enter(fileSnapshot);
            boolean shouldBeIgnored = ClasspathFingerprintingStrategy.this.classpathResourceFilter.shouldBeIgnored(this.relativePathFactory);
            this.relativePathSegmentsTracker.leave();
            if (shouldBeIgnored) {
                return null;
            }
            return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(fileSnapshot);
        }

        @Override
        public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.leave();
            this.delegate.postVisitDirectory();
        }
    }

    public static enum NonJarFingerprintingStrategy {
        IGNORE{

            @Override
            @Nullable
            public HashCode determineNonJarFingerprint(HashCode original) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonJarFingerprint(HashCode original) {
                return original;
            }
        };


        @Nullable
        public abstract HashCode determineNonJarFingerprint(HashCode var1);
    }
}

