/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.text.TreeFormatter;

public class DefaultProjectDependencyPublicationResolver
implements ProjectDependencyPublicationResolver {
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurer projectConfigurer;

    public DefaultProjectDependencyPublicationResolver(ProjectPublicationRegistry publicationRegistry, ProjectConfigurer projectConfigurer) {
        this.publicationRegistry = publicationRegistry;
        this.projectConfigurer = projectConfigurer;
    }

    @Override
    public <T> T resolve(Class<T> coordsType, ProjectDependency dependency) {
        ProjectInternal dependencyProject = (ProjectInternal)dependency.getDependencyProject();
        this.projectConfigurer.configureFully(dependencyProject);
        ArrayList<ProjectPublication> publications = new ArrayList<ProjectPublication>();
        for (ProjectPublication publication : this.publicationRegistry.getPublications(dependencyProject.getPath())) {
            if (publication.isLegacy() || publication.getCoordinates(coordsType) == null) continue;
            publications.add(publication);
        }
        if (publications.isEmpty()) {
            if (coordsType.isAssignableFrom(ModuleVersionIdentifier.class)) {
                return coordsType.cast(DefaultModuleVersionIdentifier.newId(dependency.getGroup(), dependencyProject.getName(), dependency.getVersion()));
            }
            throw new UnsupportedOperationException(String.format("Could not find any publications of type %s in %s.", coordsType.getSimpleName(), dependencyProject.getDisplayName()));
        }
        HashSet ignored = new HashSet();
        for (ProjectPublication publication : publications) {
            if (publication.getComponent() == null || !(publication.getComponent() instanceof ComponentWithVariants)) continue;
            ComponentWithVariants parent = (ComponentWithVariants)publication.getComponent();
            ignored.addAll(parent.getVariants());
        }
        LinkedHashSet<ProjectPublication> topLevel = new LinkedHashSet<ProjectPublication>();
        LinkedHashSet<ProjectPublication> topLevelWithComponent = new LinkedHashSet<ProjectPublication>();
        for (ProjectPublication publication : publications) {
            if (publication.isAlias() || publication.getComponent() != null && ignored.contains(publication.getComponent())) continue;
            topLevel.add(publication);
            if (publication.getComponent() == null) continue;
            topLevelWithComponent.add(publication);
        }
        if (topLevelWithComponent.size() == 1) {
            return ((ProjectPublication)topLevelWithComponent.iterator().next()).getCoordinates(coordsType);
        }
        Iterator iterator = topLevel.iterator();
        T candidate = ((ProjectPublication)iterator.next()).getCoordinates(coordsType);
        while (iterator.hasNext()) {
            T alternative = ((ProjectPublication)iterator.next()).getCoordinates(coordsType);
            if (candidate.equals(alternative)) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Publishing is not able to resolve a dependency on a project with multiple publications that have different coordinates.");
            formatter.node("Found the following publications in " + dependencyProject.getDisplayName());
            formatter.startChildren();
            for (ProjectPublication publication : topLevel) {
                formatter.node(publication.getDisplayName().getCapitalizedDisplayName() + " with coordinates " + publication.getCoordinates(coordsType));
            }
            formatter.endChildren();
            throw new UnsupportedOperationException(formatter.toString());
        }
        return candidate;
    }
}

