/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AsyncSettableFuture<V>
extends ForwardingListenableFuture<V> {
    private final NestedFuture<V> nested = new NestedFuture();
    private final ListenableFuture<V> dereferenced = Futures.dereference(this.nested);

    public static <V> AsyncSettableFuture<V> create() {
        return new AsyncSettableFuture<V>();
    }

    private AsyncSettableFuture() {
    }

    @Override
    protected ListenableFuture<V> delegate() {
        return this.dereferenced;
    }

    public boolean setFuture(ListenableFuture<? extends V> future) {
        return this.nested.setFuture(Preconditions.checkNotNull(future));
    }

    public boolean setValue(@Nullable V value) {
        return this.setFuture(Futures.immediateFuture(value));
    }

    public boolean setException(Throwable exception) {
        return this.setFuture(Futures.immediateFailedFuture(exception));
    }

    public boolean isSet() {
        return this.nested.isDone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NestedFuture<V>
    extends AbstractFuture<ListenableFuture<? extends V>> {
        private NestedFuture() {
        }

        boolean setFuture(ListenableFuture<? extends V> value) {
            boolean result = this.set(value);
            if (this.isCancelled()) {
                value.cancel(this.wasInterrupted());
            }
            return result;
        }
    }
}

