/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PropertiesConfiguration
extends AbstractFileConfiguration {
    static String include = "include";
    private boolean includesAllowed = true;
    private String header;

    public PropertiesConfiguration() {
        this.setIncludesAllowed(false);
    }

    public PropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public PropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public PropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String inc) {
        include = inc;
    }

    protected void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    public boolean getIncludesAllowed() {
        return this.includesAllowed;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void load(Reader in) throws ConfigurationException {
        PropertiesReader reader = new PropertiesReader(in);
        try {
            block2: while (true) {
                String line;
                if ((line = reader.readProperty()) == null) {
                    return;
                }
                int equalSign = line.indexOf(61);
                if (equalSign <= 0) continue;
                String key = line.substring(0, equalSign).trim();
                String value = line.substring(equalSign + 1).trim();
                if (StringUtils.isNotEmpty((String)PropertiesConfiguration.getInclude()) && key.equalsIgnoreCase(PropertiesConfiguration.getInclude())) {
                    if (!this.getIncludesAllowed()) continue;
                    String[] files = StringUtils.split((String)value, (char)AbstractConfiguration.getDelimiter());
                    int i = 0;
                    while (true) {
                        if (i >= files.length) continue block2;
                        this.load(ConfigurationUtils.locate(this.getBasePath(), files[i].trim()));
                        ++i;
                    }
                }
                this.addProperty(key, PropertiesConfiguration.unescapeJava(value, AbstractConfiguration.getDelimiter()));
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not load configuration from input stream.", ioe);
        }
    }

    public void save(Writer writer) throws ConfigurationException {
        try {
            PropertiesWriter out = new PropertiesWriter(writer, AbstractConfiguration.getDelimiter());
            if (this.header != null) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(this.header));
                while ((line = reader.readLine()) != null) {
                    out.writeComment(line);
                }
                out.write("\n");
            }
            out.writeComment("written by PropertiesConfiguration");
            out.writeComment(new Date().toString());
            out.write("\n");
            Iterator keys = this.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = this.getProperty(key);
                if (value instanceof List) {
                    out.writeProperty(key, (List)value);
                    continue;
                }
                out.writeProperty(key, value);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setIncludesAllowed(StringUtils.isNotEmpty((String)basePath));
    }

    protected static String unescapeJava(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer(sz);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                    continue;
                }
                if (ch == '\'') {
                    out.append('\'');
                    continue;
                }
                if (ch == '\"') {
                    out.append('\"');
                    continue;
                }
                if (ch == 'r') {
                    out.append('\r');
                    continue;
                }
                if (ch == 'f') {
                    out.append('\f');
                    continue;
                }
                if (ch == 't') {
                    out.append('\t');
                    continue;
                }
                if (ch == 'n') {
                    out.append('\n');
                    continue;
                }
                if (ch == 'b') {
                    out.append('\b');
                    continue;
                }
                if (ch == delimiter) {
                    out.append('\\');
                    out.append(delimiter);
                    continue;
                }
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                out.append(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private char delimiter;

        public PropertiesWriter(Writer writer, char delimiter) {
            super(writer);
            this.delimiter = delimiter;
        }

        public void writeProperty(String key, Object value) throws IOException {
            this.write(key);
            this.write(" = ");
            if (value != null) {
                String v = StringEscapeUtils.escapeJava((String)String.valueOf(value));
                v = StringUtils.replace((String)v, (String)String.valueOf(this.delimiter), (String)("\\" + this.delimiter));
                this.write(v);
            }
            this.write(10);
        }

        public void writeProperty(String key, List values) throws IOException {
            for (int i = 0; i < values.size(); ++i) {
                this.writeProperty(key, values.get(i));
            }
        }

        public void writeComment(String comment) throws IOException {
            this.write("# " + comment + "\n");
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            String line;
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (StringUtils.isEmpty((String)(line = line.trim())) || line.charAt(0) == '#') continue;
                if (!line.endsWith("\\")) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }
    }
}

