/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ArgumentInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirIdentityLessPlatformDeterminerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001d\u0010\u0019\u001a\u00020\u001a*\u00020\u0014H\u0000R\u00020\u001bj\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001d\u001a\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a%\u0010\u001f\u001a\u00020\u0001*\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002R\u00020\u001bj\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010!\u001a)\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0000R\u00020\u001bj\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010!\u001a)\u0010%\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0000R\u00020\u001bj\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010!\u001a)\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0000R\u00020\u001bj\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010!\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\n\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u001c\u0010\u000b\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0003\"\u001c\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0003\"\u001e\u0010\u0013\u001a\u00020\u000e*\u00020\u00148BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"isBuiltin", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Z", "isNullableEnum", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;)Z", "isIdentityLess", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isNotNullPrimitive", "isFinalClass", "isClass", "isEnum", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toTypeInfo", "toKotlinTypeIfPlatform", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toPlatformTypeIfKotlin", "mostOriginalTypeIfSmartCast", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getMostOriginalTypeIfSmartCast$annotations", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getMostOriginalTypeIfSmartCast", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toArgumentInfo", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "getCounterpartRelativelyToPlatform", "isSubtypeOf", "other", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;)Z", "areUnrelated", "a", "b", "areRelated", "shouldReportAsPerRules1", "l", "r", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeCompatibilityHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeCompatibilityHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirTypeCompatibilityHelpersKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n86#2:152\n46#2:154\n83#2:155\n86#2:157\n86#2:180\n63#2:191\n57#2,4:192\n37#3:153\n34#3:156\n37#3:158\n37#3:181\n1586#4:159\n1661#4,3:160\n1642#4,10:164\n1915#4:174\n1916#4:176\n1652#4:177\n1807#4,2:178\n1809#4:182\n1807#4,3:183\n1807#4,3:186\n1807#4,2:189\n1809#4:196\n1807#4,3:197\n1807#4,3:200\n195#5:163\n1#6:175\n1#6:203\n*S KotlinDebug\n*F\n+ 1 FirTypeCompatibilityHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirTypeCompatibilityHelpersKt\n*L\n40#1:152\n49#1:154\n52#1:155\n54#1:157\n67#1:180\n70#1:191\n70#1:192,4\n40#1:153\n52#1:156\n54#1:158\n67#1:181\n59#1:159\n59#1:160,3\n63#1:164,10\n63#1:174\n63#1:176\n63#1:177\n67#1:178,2\n67#1:182\n68#1:183,3\n69#1:186,3\n70#1:189,2\n70#1:196\n71#1:197,3\n72#1:200,3\n60#1:163\n63#1:175\n*E\n"})
public final class FirTypeCompatibilityHelpersKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isBuiltin(FirClassSymbol<?> $this$isBuiltin) {
        if (PrimitivesKt.isPrimitiveType($this$isBuiltin)) return true;
        if (Intrinsics.areEqual($this$isBuiltin.getClassId(), StandardClassIds.INSTANCE.getString())) return true;
        FirClassSymbol<?> $this$isEnumClass$iv = $this$isBuiltin;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    public static final boolean isNullableEnum(@NotNull TypeInfo $this$isNullableEnum) {
        Intrinsics.checkNotNullParameter($this$isNullableEnum, "<this>");
        return $this$isNullableEnum.isEnumClass() && ConeTypeUtilsKt.isMarkedOrFlexiblyNullable($this$isNullableEnum.getType());
    }

    public static final boolean isIdentityLess(@NotNull TypeInfo $this$isIdentityLess, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isIdentityLess, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirIdentityLessPlatformDeterminerKt.getIdentityLessPlatformDeterminer(session).isIdentityLess($this$isIdentityLess) || $this$isIdentityLess.isValueClass();
    }

    public static final boolean isNotNullPrimitive(@NotNull TypeInfo $this$isNotNullPrimitive) {
        Intrinsics.checkNotNullParameter($this$isNotNullPrimitive, "<this>");
        return $this$isNotNullPrimitive.isPrimitive() && !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable($this$isNotNullPrimitive.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isFinalClass(FirClassSymbol<?> $this$isFinalClass) {
        if (!FirTypeCompatibilityHelpersKt.isClass($this$isFinalClass)) return false;
        FirClassLikeSymbol $this$isFinal$iv = $this$isFinalClass;
        boolean $i$f$isFinal = false;
        if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return false;
        return true;
    }

    private static final boolean isClass(FirClassSymbol<?> $this$isClass) {
        FirClassSymbol<?> $this$isInterface$iv = $this$isClass;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        return !($this$isInterface$iv$iv == ClassKind.INTERFACE);
    }

    public static final boolean isEnum(@NotNull ConeKotlinType $this$isEnum, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isEnum, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol($this$isEnum, session);
        if (firRegularClassSymbol != null) {
            FirClassSymbol $this$isEnumClass$iv = firRegularClassSymbol;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isClass(@NotNull ConeKotlinType $this$isClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isClass, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return ToSymbolUtilsKt.toRegularClassSymbol($this$isClass, session) != null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final TypeInfo toTypeInfo(@NotNull ConeKotlinType $this$toTypeInfo, @NotNull FirSession session) {
        block28: {
            block27: {
                block26: {
                    block29: {
                        block25: {
                            block24: {
                                block23: {
                                    Intrinsics.checkNotNullParameter($this$toTypeInfo, "<this>");
                                    Intrinsics.checkNotNullParameter(session, "session");
                                    $this$map$iv = TypeUtilsKt.collectUpperBounds($this$toTypeInfo, TypeComponentsKt.getTypeContext(session));
                                    $i$f$map = false;
                                    var5_5 = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        var10_17 = (ConeClassLikeType)item$iv$iv;
                                        var21_15 = destination$iv$iv;
                                        $i$a$-map-FirTypeCompatibilityHelpersKt$toTypeInfo$bounds$1 = false;
                                        var21_15.add(ConeTypeUtilsKt.replaceArgumentsWithStarProjections((ConeClassLikeType)it));
                                    }
                                    bounds = (List)destination$iv$iv;
                                    $this$ifNotEmpty$iv = bounds;
                                    $i$f$ifNotEmpty = false;
                                    if ($this$ifNotEmpty$iv.isEmpty() == false) {
                                        $this$toTypeInfo_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
                                        $i$a$-ifNotEmpty-FirTypeCompatibilityHelpersKt$toTypeInfo$type$1 = false;
                                        v0 = ConeTypeIntersector.INSTANCE.intersectTypes(TypeComponentsKt.getTypeContext(session), $this$toTypeInfo_u24lambda_u241);
                                    } else {
                                        v0 = v1 = null;
                                    }
                                    if (v0 == null || (v1 = TypeExpansionUtilsKt.fullyExpandedType$default(v1, session, null, 2, null)) == null) {
                                        v1 = session.getBuiltinTypes().getNullableAnyType().getConeType();
                                    }
                                    type = v1;
                                    notNullType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(type, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
                                    $this$mapNotNull$iv = bounds;
                                    $i$f$mapNotNull = false;
                                    $i$a$-ifNotEmpty-FirTypeCompatibilityHelpersKt$toTypeInfo$type$1 = $this$mapNotNull$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$mapNotNullTo = false;
                                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                    $i$f$forEach = false;
                                    var13_37 = $this$forEach$iv$iv$iv.iterator();
                                    while (var13_37.hasNext()) {
                                        element$iv$iv = element$iv$iv$iv = var13_37.next();
                                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                        it = (ConeClassLikeType)element$iv$iv;
                                        $i$a$-mapNotNull-FirTypeCompatibilityHelpersKt$toTypeInfo$boundsSymbols$1 = false;
                                        if (ToSymbolUtilsKt.toClassSymbol(it, session) == null) continue;
                                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    boundsSymbols = (List)destination$iv$iv;
                                    $this$mapNotNull$iv = boundsSymbols;
                                    var24_49 = $this$toTypeInfo;
                                    var23_50 = notNullType;
                                    var22_51 = type;
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        v2 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            it = (FirClassSymbol)element$iv;
                                            $i$a$-any-FirTypeCompatibilityHelpersKt$toTypeInfo$1 = false;
                                            $this$isEnumClass$iv = it;
                                            $i$f$isEnumClass = false;
                                            $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                                            $i$f$isEnumClass = false;
                                            v3 = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
                                            if (!v3) continue;
                                            v2 = true;
                                            break block23;
                                        }
                                        v2 = false;
                                    }
                                }
                                var25_52 = v2;
                                $this$any$iv = bounds;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v4 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (ConeClassLikeType)element$iv;
                                        $i$a$-any-FirTypeCompatibilityHelpersKt$toTypeInfo$2 = false;
                                        if (!ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(it)) continue;
                                        v4 = true;
                                        break block24;
                                    }
                                    v4 = false;
                                }
                            }
                            var26_53 = v4;
                            $this$any$iv = boundsSymbols;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v5 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (FirClassSymbol)element$iv;
                                    $i$a$-any-FirTypeCompatibilityHelpersKt$toTypeInfo$3 = false;
                                    if (!FirTypeCompatibilityHelpersKt.isBuiltin(it)) continue;
                                    v5 = true;
                                    break block25;
                                }
                                v5 = false;
                            }
                        }
                        var27_54 = v5;
                        $this$any$iv = boundsSymbols;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block29;
                        v6 = false;
                        break block26;
                    }
                    for (T element$iv : $this$any$iv) {
                        it = (FirClassSymbol)element$iv;
                        $i$a$-any-FirTypeCompatibilityHelpersKt$toTypeInfo$4 = false;
                        $this$isInlineOrValue$iv = it;
                        $i$f$isInlineOrValue = false;
                        $this$isInline$iv$iv = $this$isInlineOrValue$iv;
                        $i$f$isInline = false;
                        if ($this$isInline$iv$iv.getRawStatus().isInline()) ** GOTO lbl-1000
                        $this$isValue$iv$iv = $this$isInlineOrValue$iv;
                        $i$f$isValue = false;
                        if ($this$isValue$iv$iv.getRawStatus().isValue()) lbl-1000:
                        // 2 sources

                        {
                            v7 = true;
                        } else {
                            v7 = false;
                        }
                        if (!v7) continue;
                        v6 = true;
                        break block26;
                    }
                    v6 = false;
                }
                var28_55 = v6;
                $this$any$iv = boundsSymbols;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v8 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (FirClassSymbol)element$iv;
                        $i$a$-any-FirTypeCompatibilityHelpersKt$toTypeInfo$5 = false;
                        if (!FirTypeCompatibilityHelpersKt.isFinalClass(it)) continue;
                        v8 = true;
                        break block27;
                    }
                    v8 = false;
                }
            }
            var29_56 = v8;
            $this$any$iv = boundsSymbols;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v9 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (FirClassSymbol)element$iv;
                    $i$a$-any-FirTypeCompatibilityHelpersKt$toTypeInfo$6 = false;
                    if (!FirTypeCompatibilityHelpersKt.isClass(it)) continue;
                    v9 = true;
                    break block28;
                }
                v9 = false;
            }
        }
        var30_57 = v9;
        var31_58 = org.jetbrains.kotlin.fir.types.TypeUtilsKt.canHaveSubtypesAccordingToK1(org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default($this$toTypeInfo, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null), session);
        var32_59 = var30_57;
        var33_60 = var29_56;
        var34_61 = var28_55;
        var35_62 = var27_54;
        var36_63 = var26_53;
        var37_64 = var25_52;
        var38_65 = var24_49;
        var39_66 = var23_50;
        var40_67 = var22_51;
        return new TypeInfo(var40_67, var39_66, var38_65, var37_64, var36_63, var35_62, var34_61, var33_60, var32_59, var31_58);
    }

    @Nullable
    public static final ConeClassLikeType toKotlinTypeIfPlatform(@NotNull ConeKotlinType $this$toKotlinTypeIfPlatform, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$toKotlinTypeIfPlatform, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ClassId classId = FirPlatformClassMapperKt.getPlatformClassMapper(session).getCorrespondingKotlinClass(ConeTypeUtilsKt.getClassId($this$toKotlinTypeIfPlatform));
        return classId != null ? TypeConstructionUtilsKt.constructClassLikeType(classId, $this$toKotlinTypeIfPlatform.getTypeArguments(), ConeTypeUtilsKt.isMarkedNullable($this$toKotlinTypeIfPlatform), $this$toKotlinTypeIfPlatform.getAttributes()) : null;
    }

    @Nullable
    public static final ConeClassLikeType toPlatformTypeIfKotlin(@NotNull ConeKotlinType $this$toPlatformTypeIfKotlin, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$toPlatformTypeIfKotlin, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ClassId classId = FirPlatformClassMapperKt.getPlatformClassMapper(session).getCorrespondingPlatformClass(ConeTypeUtilsKt.getClassId($this$toPlatformTypeIfKotlin));
        return classId != null ? TypeConstructionUtilsKt.constructClassLikeType(classId, $this$toPlatformTypeIfKotlin.getTypeArguments(), ConeTypeUtilsKt.isMarkedNullable($this$toPlatformTypeIfKotlin), $this$toPlatformTypeIfKotlin.getAttributes()) : null;
    }

    private static final ConeKotlinType getMostOriginalTypeIfSmartCast(FirExpression $this$mostOriginalTypeIfSmartCast) {
        return $this$mostOriginalTypeIfSmartCast instanceof FirSmartCastExpression ? FirTypeCompatibilityHelpersKt.getMostOriginalTypeIfSmartCast(((FirSmartCastExpression)$this$mostOriginalTypeIfSmartCast).getOriginalExpression()) : FirTypeUtilsKt.getResolvedType($this$mostOriginalTypeIfSmartCast);
    }

    @NotNull
    public static final ArgumentInfo toArgumentInfo(@NotNull CheckerContext context2, @NotNull FirExpression $this$toArgumentInfo) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter($this$toArgumentInfo, "<this>");
        return new ArgumentInfo($this$toArgumentInfo, FirHelpersKt.finalApproximationOrSelf(context2, FirTypeUtilsKt.getResolvedType($this$toArgumentInfo)), FirHelpersKt.finalApproximationOrSelf(context2, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeCompatibilityHelpersKt.getMostOriginalTypeIfSmartCast($this$toArgumentInfo))), context2.getSession());
    }

    private static final ConeKotlinType getCounterpartRelativelyToPlatform(ConeKotlinType $this$getCounterpartRelativelyToPlatform, FirSession session) {
        ConeClassLikeType coneClassLikeType = FirTypeCompatibilityHelpersKt.toKotlinTypeIfPlatform($this$getCounterpartRelativelyToPlatform, session);
        return coneClassLikeType != null ? (ConeKotlinType)coneClassLikeType : (ConeKotlinType)FirTypeCompatibilityHelpersKt.toPlatformTypeIfKotlin($this$getCounterpartRelativelyToPlatform, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSubtypeOf(CheckerContext context2, TypeInfo $this$isSubtypeOf, TypeInfo other) {
        boolean isDirectSubtype = org.jetbrains.kotlin.fir.types.TypeUtilsKt.isSubtypeOf$default($this$isSubtypeOf.getNotNullType(), other.getNotNullType(), context2.getSession(), false, 4, null);
        ConeKotlinType counterpart = FirTypeCompatibilityHelpersKt.getCounterpartRelativelyToPlatform(other.getNotNullType(), context2.getSession());
        if (isDirectSubtype) return true;
        ConeKotlinType coneKotlinType = counterpart;
        if (coneKotlinType == null) return false;
        ConeKotlinType it = coneKotlinType;
        boolean bl = false;
        if (!org.jetbrains.kotlin.fir.types.TypeUtilsKt.isSubtypeOf$default($this$isSubtypeOf.getNotNullType(), it, context2.getSession(), false, 4, null)) return false;
        return true;
    }

    public static final boolean areUnrelated(@NotNull CheckerContext context2, @NotNull TypeInfo a2, @NotNull TypeInfo b2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return !FirTypeCompatibilityHelpersKt.isSubtypeOf(context2, a2, b2) && !FirTypeCompatibilityHelpersKt.isSubtypeOf(context2, b2, a2);
    }

    public static final boolean areRelated(@NotNull CheckerContext context2, @NotNull TypeInfo a2, @NotNull TypeInfo b2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return !FirTypeCompatibilityHelpersKt.areUnrelated(context2, a2, b2);
    }

    public static final boolean shouldReportAsPerRules1(@NotNull CheckerContext context2, @NotNull TypeInfo l2, @NotNull TypeInfo r2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(l2, "l");
        Intrinsics.checkNotNullParameter(r2, "r");
        boolean oneIsFinal = l2.isFinal() || r2.isFinal();
        boolean bothAreConcrete = l2.getType() instanceof ConeClassLikeType && r2.getType() instanceof ConeClassLikeType;
        boolean bothAreClasses = l2.isClass() && r2.isClass();
        return oneIsFinal ? FirTypeCompatibilityHelpersKt.areUnrelated(context2, l2, r2) : (bothAreConcrete && bothAreClasses ? FirTypeCompatibilityHelpersKt.areUnrelated(context2, l2, r2) : false);
    }
}

