/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryBase;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0014J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "rootProjectDir", "Ljava/io/File;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "getBuildHistoryFilesForJar", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "jar", "abiSnapshot", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nModulesApiHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,257:1\n1586#2:258\n1661#2,3:259\n777#2:262\n873#2,2:263\n1512#2:265\n1538#2,3:266\n1541#2,3:276\n383#3,7:269\n*S KotlinDebug\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm\n*L\n133#1:258\n133#1:259,3\n138#1:262\n138#1:263,2\n138#1:265\n138#1:266,3\n138#1:276,3\n138#1:269,7\n*E\n"})
public final class ModulesApiHistoryJvm
extends ModulesApiHistoryBase {
    public ModulesApiHistoryJvm(@NotNull File rootProjectDir, @NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter(rootProjectDir, "rootProjectDir");
        Intrinsics.checkNotNullParameter(modulesInfo, "modulesInfo");
        super(rootProjectDir, modulesInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$filterTo$iv$iv;
        Iterable classFiles;
        Iterable destination$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(jar, "jar");
        IncrementalModuleEntry moduleInfoFromJar = this.getModulesInfo().getJarToModule().get(jar);
        if (moduleInfoFromJar != null) {
            return new Either.Success<Set<File>>(SetsKt.setOf(moduleInfoFromJar.getBuildHistoryFile()));
        }
        File file = this.getModulesInfo().getJarToClassListFile().get(jar);
        if (file == null) {
            return new Either.Error("Unknown jar: " + jar);
        }
        File classListFile = file;
        if (!classListFile.isFile()) {
            return new Either.Error("Class list file does not exist " + classListFile);
        }
        try {
            void $this$mapTo$iv$iv;
            CharSequence charSequence = FilesKt.readText$default(classListFile, null, 1, null);
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(File.pathSeparator, "pathSeparator");
            $this$map$iv = StringsKt.split$default(charSequence, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
        }
        catch (Throwable t2) {
            return new Either.Error("Could not read class list for " + jar + " from " + classListFile + ": " + t2);
        }
        Iterable $this$filter$iv = classFiles = $this$map$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(it.exists() && it.getParentFile() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            File it = (File)element$iv$iv;
            boolean bl = false;
            File key$iv$iv = it.getParentFile();
            Object object2 = destination$iv$iv2;
            File key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object classFileDirs = destination$iv$iv2;
        HashSet result2 = new HashSet();
        for (File dir2 : classFileDirs.keySet()) {
            Intrinsics.checkNotNull(dir2);
            Either<Set<File>> historyEither = this.getBuildHistoryForDir(dir2);
            if (historyEither instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (historyEither instanceof Either.Error) {
                return historyEither;
            }
            throw new NoWhenBranchMatchedException();
        }
        return new Either.Success(result2);
    }

    @Override
    @NotNull
    public Either<Set<File>> abiSnapshot(@NotNull File jar) {
        Serializable abiSnapshot2;
        Intrinsics.checkNotNullParameter(jar, "jar");
        Serializable serializable = this.getModulesInfo().getJarToModule().get(jar);
        if (serializable == null || (serializable = serializable.getAbiSnapshot()) == null) {
            serializable = this.getModulesInfo().getJarToAbiSnapshot().get(jar);
        }
        return (abiSnapshot2 = serializable) != null ? (Either)new Either.Success<Set<IncrementalModuleEntry>>(SetsKt.setOf(abiSnapshot2)) : (Either)new Either.Error("Failed to find abi snapshot for file " + jar.getAbsolutePath());
    }
}

