/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMPicArea;
import megamek.client.ui.AWT.widget.PMSimpleLabel;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.common.Aero;
import megamek.common.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapitalFighterMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Component comp;
    private Image armorImage;
    private PMPicArea armorArea;
    private Image avCritImage;
    private PMPicArea avCritArea;
    private Image engineCritImage;
    private PMPicArea engineCritArea;
    private Image fcsCritImage;
    private PMPicArea fcsCritArea;
    private Image sensorCritImage;
    private PMPicArea sensorCritArea;
    private Image pilotCritImage;
    private PMPicArea pilotCritArea;
    private PMSimpleLabel armorLabel;
    private PMValueLabel armorVLabel;
    private PMSimpleLabel avCritLabel;
    private PMSimpleLabel engineCritLabel;
    private PMSimpleLabel fcsCritLabel;
    private PMSimpleLabel sensorCritLabel;
    private PMSimpleLabel pilotCritLabel;
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private int stepY = 14;
    private int squareSize = 7;
    private int armorRows = 8;
    private int armorCols = 6;
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));

    public CapitalFighterMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        Aero aero = (Aero)entity;
        int n = aero.getCapArmor();
        int n2 = aero.getCap0Armor();
        this.drawArmorImage(this.armorImage, n, n2);
        this.armorVLabel.setValue(Integer.toString(n));
        this.drawCrits(this.avCritImage, aero.getAvionicsHits());
        this.drawCrits(this.engineCritImage, aero.getEngineHits());
        this.drawCrits(this.fcsCritImage, aero.getFCSHits());
        this.drawCrits(this.sensorCritImage, aero.getSensorHits());
        this.drawCrits(this.pilotCritImage, aero.getCrew().getHits());
    }

    private void setContent() {
        this.content.addArea(this.armorLabel);
        this.content.addArea(this.armorArea);
        this.content.addArea(this.armorVLabel);
        this.content.addArea(this.avCritLabel);
        this.content.addArea(this.engineCritLabel);
        this.content.addArea(this.fcsCritLabel);
        this.content.addArea(this.sensorCritLabel);
        this.content.addArea(this.pilotCritLabel);
        this.content.addArea(this.avCritArea);
        this.content.addArea(this.engineCritArea);
        this.content.addArea(this.fcsCritArea);
        this.content.addArea(this.sensorCritArea);
        this.content.addArea(this.pilotCritArea);
    }

    private void setAreas() {
        this.armorImage = this.comp.createImage(this.armorCols * (this.squareSize + 1), this.armorRows * (this.squareSize + 1));
        this.armorArea = new PMPicArea(this.armorImage);
        this.avCritImage = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
        this.avCritArea = new PMPicArea(this.avCritImage);
        this.engineCritImage = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
        this.engineCritArea = new PMPicArea(this.engineCritImage);
        this.fcsCritImage = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
        this.fcsCritArea = new PMPicArea(this.fcsCritImage);
        this.sensorCritImage = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
        this.sensorCritArea = new PMPicArea(this.sensorCritImage);
        this.pilotCritImage = this.comp.createImage(6 * (this.squareSize + 1), this.squareSize + 1);
        this.pilotCritArea = new PMPicArea(this.pilotCritImage);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.armorLabel = new PMSimpleLabel("Armor:", fontMetrics, Color.white);
        this.armorVLabel = new PMValueLabel(fontMetrics, Color.red.brighter());
        this.avCritLabel = new PMSimpleLabel("Avionics:", fontMetrics, Color.white);
        this.engineCritLabel = new PMSimpleLabel("Engine:", fontMetrics, Color.white);
        this.fcsCritLabel = new PMSimpleLabel("FCS:", fontMetrics, Color.white);
        this.sensorCritLabel = new PMSimpleLabel("Sensors:", fontMetrics, Color.white);
        this.pilotCritLabel = new PMSimpleLabel("Pilot hits:", fontMetrics, Color.white);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
        this.armorLabel.translate(0, 0);
        this.armorArea.translate(0, this.squareSize);
        this.armorVLabel.translate(this.armorCols * (this.squareSize + 1) / 2, this.squareSize + this.armorRows * (this.squareSize + 1) / 2);
        this.avCritLabel.translate(5 + this.armorCols * (this.squareSize + 1), this.stepY);
        this.engineCritLabel.translate(5 + this.armorCols * (this.squareSize + 1), 2 * this.stepY);
        this.fcsCritLabel.translate(5 + this.armorCols * (this.squareSize + 1), 3 * this.stepY);
        this.sensorCritLabel.translate(5 + this.armorCols * (this.squareSize + 1), 4 * this.stepY);
        this.pilotCritLabel.translate(5 + this.armorCols * (this.squareSize + 1), 5 * this.stepY);
        this.avCritArea.translate(10 + this.pilotCritLabel.width + this.armorCols * (this.squareSize + 1), this.stepY - (this.squareSize + 1));
        this.engineCritArea.translate(10 + this.pilotCritLabel.width + this.armorCols * (this.squareSize + 1), 2 * this.stepY - (this.squareSize + 1));
        this.fcsCritArea.translate(10 + this.pilotCritLabel.width + this.armorCols * (this.squareSize + 1), 3 * this.stepY - (this.squareSize + 1));
        this.sensorCritArea.translate(10 + this.pilotCritLabel.width + this.armorCols * (this.squareSize + 1), 4 * this.stepY - (this.squareSize + 1));
        this.pilotCritArea.translate(10 + this.pilotCritLabel.width + this.armorCols * (this.squareSize + 1), 5 * this.stepY - (this.squareSize + 1));
    }

    private void drawCrits(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n2, n3);
        for (int i = 0; i < n; ++i) {
            graphics.setColor(Color.red.darker());
            graphics.fillRect(i * (this.squareSize + 1), 0, this.squareSize, this.squareSize);
        }
    }

    private void drawArmorImage(Image image, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, n6, n7);
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = n5 / this.armorRows;
            n3 = n5 - n4 * this.armorRows;
            graphics.setColor(Color.black);
            graphics.fillRect(n4 * (this.squareSize + 1), n3 * (this.squareSize + 1), this.squareSize + 1, this.squareSize + 1);
        }
        for (n5 = 0; n5 < n; ++n5) {
            n4 = n5 / this.armorRows;
            n3 = n5 - n4 * this.armorRows;
            graphics.setColor(Color.green.darker());
            graphics.fillRect(n4 * (this.squareSize + 1), n3 * (this.squareSize + 1), this.squareSize, this.squareSize);
        }
    }
}

