/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.HashMap;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlternateUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final String _symbol;
    private final Unit<?> _parent;
    private static final long serialVersionUID = 1L;

    AlternateUnit(String symbol, Unit<?> parent) {
        if (!parent.isSI()) {
            throw new UnsupportedOperationException(this + " is not a standard unit");
        }
        this._symbol = symbol;
        this._parent = parent;
        HashMap<String, Unit<?>> hashMap = Unit.SYMBOL_TO_UNIT;
        synchronized (hashMap) {
            Unit<?> unit = Unit.SYMBOL_TO_UNIT.get(symbol);
            if (unit == null) {
                Unit.SYMBOL_TO_UNIT.put(symbol, this);
                return;
            }
            if (unit instanceof AlternateUnit) {
                AlternateUnit existingUnit = (AlternateUnit)unit;
                if (symbol.equals(existingUnit._symbol) && this._parent.equals(existingUnit._parent)) {
                    return;
                }
            }
            throw new IllegalArgumentException("Symbol " + symbol + " is associated to a different unit");
        }
    }

    public final String getSymbol() {
        return this._symbol;
    }

    public final Unit<?> getParent() {
        return this._parent;
    }

    @Override
    public final Unit<Q> toSI() {
        return this;
    }

    @Override
    public final UnitConverter getConverterTo(Unit<Q> unit) {
        return unit.equals(this) ? UnitConverter.IDENTITY : super.getConverterTo(unit);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof AlternateUnit)) {
            return false;
        }
        AlternateUnit thatUnit = (AlternateUnit)that;
        return this._symbol.equals(thatUnit._symbol);
    }

    @Override
    public int hashCode() {
        return this._symbol.hashCode();
    }
}

