/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth.app;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.rundeck.core.auth.app.RundeckAccess;
import org.rundeck.core.auth.app.TypedNamedAuthRequest;
import org.rundeck.core.auth.web.RdAuthorize;
import org.rundeck.core.auth.web.RdAuthorizeAdhoc;
import org.rundeck.core.auth.web.RdAuthorizeApplicationType;
import org.rundeck.core.auth.web.RdAuthorizeExecution;
import org.rundeck.core.auth.web.RdAuthorizeJob;
import org.rundeck.core.auth.web.RdAuthorizeProject;
import org.rundeck.core.auth.web.RdAuthorizeProjectAcl;
import org.rundeck.core.auth.web.RdAuthorizeProjectType;
import org.rundeck.core.auth.web.RdAuthorizeSystem;

public class NamedAuthRequestUtil {
    private NamedAuthRequestUtil() {
    }

    public static TypedNamedAuthRequest authorizeRequest(String type, String group, String access, String description) {
        return new TypedRequest(type, group, access, description);
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorize authorize) {
        return NamedAuthRequestUtil.authorizeRequest(authorize.type(), authorize.group(), authorize.access(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeApplicationType authorize) {
        return NamedAuthRequestUtil.authorizeRequest(RundeckAccess.ApplicationType.typeForKind(authorize.type()), authorize.group(), authorize.access(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeProjectType authorize) {
        return NamedAuthRequestUtil.authorizeRequest(RundeckAccess.ProjectType.typeForKind(authorize.type()), authorize.group(), authorize.access(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeSystem authorize) {
        return NamedAuthRequestUtil.authorizeRequest("app.system", authorize.group(), authorize.value(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeProject authorize) {
        return NamedAuthRequestUtil.authorizeRequest("app.project", authorize.group(), authorize.value(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeProjectAcl authorize) {
        return NamedAuthRequestUtil.authorizeRequest("app.projectAcl", authorize.group(), authorize.value(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeAdhoc authorize) {
        return NamedAuthRequestUtil.authorizeRequest("project.adhoc", authorize.group(), authorize.value(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeExecution authorize) {
        return NamedAuthRequestUtil.authorizeRequest("project.execution", authorize.group(), authorize.value(), authorize.description());
    }

    public static TypedNamedAuthRequest authorizeRequest(RdAuthorizeJob authorize) {
        return NamedAuthRequestUtil.authorizeRequest("project.job", authorize.group(), authorize.value(), authorize.description());
    }

    public static List<TypedNamedAuthRequest> requestsFromAnnotations(Method method) {
        ArrayList<TypedNamedAuthRequest> list = new ArrayList<TypedNamedAuthRequest>();
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorize.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeSystem.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeProject.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeAdhoc.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeExecution.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeJob.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeApplicationType.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeProjectAcl.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        list.addAll(Arrays.stream(method.getAnnotationsByType(RdAuthorizeProjectType.class)).map(NamedAuthRequestUtil::authorizeRequest).collect(Collectors.toList()));
        return list;
    }

    public static class TypedRequest
    implements TypedNamedAuthRequest {
        @NonNull
        private final String type;
        @NonNull
        private final String authGroup;
        @NonNull
        private final String namedAuth;
        private final String description;

        @Override
        @NonNull
        public String getType() {
            return this.type;
        }

        @Override
        @NonNull
        public String getAuthGroup() {
            return this.authGroup;
        }

        @Override
        @NonNull
        public String getNamedAuth() {
            return this.namedAuth;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public TypedRequest(@NonNull String type, @NonNull String authGroup, @NonNull String namedAuth, String description) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (authGroup == null) {
                throw new NullPointerException("authGroup is marked non-null but is null");
            }
            if (namedAuth == null) {
                throw new NullPointerException("namedAuth is marked non-null but is null");
            }
            this.type = type;
            this.authGroup = authGroup;
            this.namedAuth = namedAuth;
            this.description = description;
        }
    }
}

