/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.chd;

import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import jrm.io.chd.CHDHeaderIntf;

class CHDHeader
implements CHDHeaderIntf {
    protected String tag;
    protected int len;
    protected int version;
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public CHDHeader(MappedByteBuffer bb) throws UnsupportedEncodingException {
        byte[] tag = new byte[8];
        bb.get(tag);
        this.tag = new String(tag, "ASCII");
        this.len = bb.getInt();
        this.version = bb.getInt();
    }

    protected CHDHeader() {
    }

    @Override
    public boolean isValidTag() {
        return this.tag.equals("MComprHD");
    }

    @Override
    public int getLen() {
        return this.len;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    protected static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Override
    public String getSHA1() {
        return null;
    }

    @Override
    public String getMD5() {
        return null;
    }
}

