/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.builder;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.List;
import org.spockframework.builder.ClosureBlueprint;
import org.spockframework.builder.IBlueprint;
import org.spockframework.builder.IGestalt;
import org.spockframework.builder.ISlotFactory;
import org.spockframework.builder.PojoGestalt;
import org.spockframework.builder.Sculpturer;
import org.spockframework.runtime.IConfigurationRegistry;

public class SpockConfigurationGestalt
implements IGestalt {
    private final IConfigurationRegistry configurationRegistry;
    private final IBlueprint blueprint;
    private final List<ISlotFactory> slotFactories;

    public SpockConfigurationGestalt(IConfigurationRegistry configurationRegistry, IBlueprint blueprint, List<ISlotFactory> slotFactories) {
        this.configurationRegistry = configurationRegistry;
        this.blueprint = blueprint;
        this.slotFactories = slotFactories;
    }

    @Override
    public IBlueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public Object getProperty(String name) {
        Object config = this.configurationRegistry.getConfigurationByName(name);
        if (config == null) {
            throw new MissingPropertyException("configuration not found");
        }
        return config;
    }

    @Override
    public void setProperty(String name, Object value) {
        throw new MissingPropertyException("configurations cannot be set directly");
    }

    @Override
    public Object invokeMethod(String name, Object[] args) {
        if (args.length != 1 || !(args[0] instanceof Closure)) {
            throw new MissingMethodException(name, this.getClass(), args);
        }
        Object config = this.configurationRegistry.getConfigurationByName(name);
        if (config == null) {
            throw new MissingMethodException(name, this.getClass(), args);
        }
        ClosureBlueprint blueprint = new ClosureBlueprint((Closure)args[0], config);
        PojoGestalt gestalt = new PojoGestalt(config, config.getClass(), blueprint, this.slotFactories);
        new Sculpturer().$form(gestalt);
        return null;
    }
}

