/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverter2ByteFixed
extends CharacterConverter12Byte {
    public CharacterConverter2ByteFixed() {
        this.m_groupId = 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c;
            if (cArray[n3] >= '\ud800' && cArray[n3] < '\udc00') {
                if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c = this.toOracleCharacterWithReplacement(cArray[n3], cArray[n3 + 1]);
                ++n3;
            } else {
                c = this.toOracleCharacter(cArray[n3], '\u0000');
            }
            byArray[n2++] = (byte)(c >> 8);
            byArray[n2++] = (byte)c;
            ++n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 65535;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            block6: {
                block5: {
                    block3: {
                        block4: {
                            if (cArray[n4] < '\ud800' || cArray[n4] >= '\udc00') break block3;
                            if (n4 + 1 >= n || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') break block4;
                            n2 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                            ++n4;
                            break block5;
                        }
                        byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                        break block6;
                    }
                    n2 = this.toOracleCharacterWithReplacement(cArray[n4], '\u0000');
                }
                byArray[n3++] = (byte)(n2 >> 8);
                byArray[n3++] = (byte)n2;
            }
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        String string = new String();
        int n4 = n;
        while (n4 < n3) {
            int n5 = byArray[n4] & 0xFF;
            if (n4 < n3 - 1) {
                n5 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                ++n4;
            } else {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            int n6 = this.toUnicode(n5);
            if (((long)n6 & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n6 >>> 16);
                string = String.valueOf(string) + (char)(n6 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n6;
            }
            ++n4;
        }
        return string;
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        String string = new String();
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            n5 = byArray[n4] & 0xFF;
            if (n4 < n3 - 1) {
                n5 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                ++n4;
            }
            if (((long)(n6 = this.toUnicodeWithReplacement(n5)) & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n6 >>> 16);
                string = String.valueOf(string) + (char)(n6 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n6;
            }
            ++n4;
        }
        return string;
    }
}

