/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.plaf.basic;

import com.jgoodies.common.jsdl.internal.ScaledIconAccess;
import com.jgoodies.common.jsdl.util.ColorUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class BasicComponentSetup {
    protected static final Color LIGHT_GRAY = new ColorUIResource(223, 223, 223);
    protected static final Color GRAY = new ColorUIResource(200, 200, 200);
    protected static final Color LINK_BLUE = new ColorUIResource(0, 102, 204);
    protected static final Color VISITED_LINK_BLUE = new ColorUIResource(128, 0, 128);
    protected static final Color COMMAND_LINK_BLUE = new ColorUIResource(21, 28, 85);
    protected static final Color COMMAND_LINK_ACTIVE_BLUE = new ColorUIResource(7, 74, 229);
    protected static final Color TITLE_BLUE = new ColorUIResource(0, 43, 130);

    public void install(UIDefaults table) {
        this.initClassDefaults(table);
        this.initComponentDefaults(table);
    }

    protected void initClassDefaults(UIDefaults table) {
        String prefix = "com.jgoodies.components.plaf.basic.Basic";
        Object[] uiDefaults = new Object[]{"JSDL.CommandLinkUI", "com.jgoodies.components.plaf.basic.BasicCommandLinkUI", "JSDL.HyperlinkUI", "com.jgoodies.components.plaf.basic.BasicHyperlinkUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        Color headerForeground;
        Color visitedLinkColor;
        Color linkColor;
        Color commandLinkForeground;
        Icon commandLinkIcon = BasicComponentSetup.getIcon(BasicComponentSetup.class, "icons/commandlink-glyph.png", null, new Insets(-4, 0, 0, 0));
        Color defaultForeground = table.getColor("controlText");
        FontUIResource commandLinkTextFont = this.getCommandLinkTextFont(table);
        FontUIResource commandLinkDescriptionFont = this.getCommandLinkDescriptionFont(table);
        FontUIResource headerFont = this.getHeaderFont(table);
        Color controlText = table.getColor("controlText");
        float brightness = ColorUtils.brightness(controlText);
        if ((double)brightness <= 0.21) {
            commandLinkForeground = COMMAND_LINK_BLUE;
            linkColor = LINK_BLUE;
            visitedLinkColor = VISITED_LINK_BLUE;
            headerForeground = TITLE_BLUE;
        } else {
            commandLinkForeground = defaultForeground;
            linkColor = GRAY;
            visitedLinkColor = LIGHT_GRAY;
            headerForeground = Color.DARK_GRAY;
        }
        Object[] uiDefaults = new Object[]{"CommandLink.icon", commandLinkIcon, "CommandLink.defaultIcon", commandLinkIcon, "CommandLink.textFont", commandLinkTextFont, "CommandLink.descriptionFont", commandLinkDescriptionFont, "CommandLink.foreground", commandLinkForeground, "CommandLink.activeForeground", COMMAND_LINK_ACTIVE_BLUE, "Hyperlink.unvisited.foreground", linkColor, "Hyperlink.visited.foreground", visitedLinkColor, "Label.header.font", headerFont, "Label.header.foreground", headerForeground};
        table.putDefaults(uiDefaults);
    }

    protected Font getControlFont(UIDefaults table) {
        return table.getFont("Button.font");
    }

    protected FontUIResource getHeaderFont(UIDefaults table) {
        Font controlFont = this.getControlFont(table);
        float controlFontSize = controlFont.getSize2D();
        int style = 0;
        Font largerFont = controlFont.deriveFont(style, controlFontSize * 1.33344f);
        return new FontUIResource(largerFont);
    }

    protected FontUIResource getCommandLinkTextFont(UIDefaults table) {
        return this.getHeaderFont(table);
    }

    protected FontUIResource getCommandLinkDescriptionFont(UIDefaults table) {
        return new FontUIResource(this.getControlFont(table));
    }

    protected final Icon getIcon(String filename, String description) {
        return this.getIcon(filename, description, null);
    }

    protected final Icon getIcon(String filename, String description, Insets insets) {
        return ScaledIconAccess.getIcon(this.getClass(), filename, description, insets);
    }

    private static Icon getIcon(Class<?> clazz, String filename, String description, Insets insets) {
        return ScaledIconAccess.getIcon(clazz, filename, description, insets);
    }
}

