/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.internal;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.focus.JGLayoutFocusTraversalPolicy;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.layout.internal.AbstractButtonPanelBuilder;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.FormSpecs;
import com.jgoodies.layout.layout.RowSpec;
import com.jgoodies.layout.layout.Sizes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class CommandBarBuilder
extends AbstractButtonPanelBuilder<CommandBarBuilder> {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{RowSpec.decode("center:pref")};
    private static final ConstantSize UNSAFE_BUTTON_GAP = Sizes.dlu(17);

    public CommandBarBuilder() {
        super(new FormLayout(COL_SPECS, ROW_SPECS), new JPanel(null));
        this.getPanel().setFocusTraversalPolicy(new JGLayoutFocusTraversalPolicy());
        this.getPanel().setFocusTraversalPolicyProvider(true);
    }

    public CommandBarBuilder buttons(JButton[] commitButtons, JButton[] additionalCommandButtons, JButton cancelButton) {
        if (SystemUtils.IS_OS_MAC) {
            this.addButtonsMac(commitButtons, additionalCommandButtons, cancelButton);
        } else {
            this.addButtonsOther(commitButtons, additionalCommandButtons, cancelButton);
        }
        return this;
    }

    private void addButtonsMac(JButton[] commitButtons, JButton[] additionalCommandButtons, JButton cancelButton) {
        int cancelIndex;
        if (additionalCommandButtons != null) {
            this.addButton(additionalCommandButtons);
            this.addUnrelatedGap();
        }
        this.addGrowingGap();
        if (commitButtons == null || commitButtons.length <= 2) {
            this.addButton(commitButtons);
            ArrayList<JButton> allButtons = new ArrayList<JButton>();
            if (additionalCommandButtons != null) {
                allButtons.addAll(Arrays.asList(additionalCommandButtons));
            }
            if (commitButtons != null) {
                allButtons.addAll(Arrays.asList(commitButtons));
            }
            return;
        }
        ArrayList<JButton> buttons = new ArrayList<JButton>(Arrays.asList(commitButtons));
        JButton actionButton = (JButton)buttons.get(0);
        buttons.remove(0);
        int n = cancelIndex = cancelButton == null ? -1 : buttons.indexOf(cancelButton);
        if (cancelIndex != -1) {
            buttons.remove(cancelIndex);
        }
        if (buttons.size() > 0) {
            this.addButton(buttons);
            if (CommandBarBuilder.isUnsafe((JButton)buttons.get(0))) {
                this.addGap(UNSAFE_BUTTON_GAP);
            } else {
                this.addRelatedGap();
            }
        }
        if (cancelIndex != -1) {
            this.addButton((JComponent)cancelButton);
            this.addRelatedGap();
        }
        this.addButton((JComponent)actionButton);
    }

    private void addButtonsOther(JButton[] commitButtons, JButton[] additionalCommandButtons, JButton cancelButton) {
        this.addGrowingGap();
        if (additionalCommandButtons != null) {
            this.addButton(additionalCommandButtons);
            this.addUnrelatedGap();
        }
        this.addButton(commitButtons);
    }

    private void addGrowingGap() {
        this.appendGrowingGapColumn();
        this.nextColumn();
    }

    protected CommandBarBuilder addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
        return this;
    }

    protected CommandBarBuilder addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
        return this;
    }

    private void addGap(ConstantSize width) {
        this.getLayout().appendColumn(ColumnSpec.createGap(width));
        this.nextColumn();
    }

    protected CommandBarBuilder addButton(JComponent button) {
        this.getLayout().appendColumn(FormSpecs.BUTTON_COLSPEC);
        this.add(button);
        this.nextColumn();
        return this;
    }

    protected CommandBarBuilder addButton(JComponent ... buttons) {
        if (buttons == null || buttons.length == 0) {
            return this;
        }
        int length = buttons.length;
        boolean leftToRight = !SystemUtils.IS_OS_MAC;
        for (int i = 0; i < length; ++i) {
            int index = leftToRight ? i : length - 1 - i;
            this.addButton(buttons[index]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
        return this;
    }

    private void addButton(List<JButton> buttons) {
        this.addButton(buttons.toArray(new JButton[0]));
    }

    private static boolean isUnsafe(JButton button) {
        String text = button.getText();
        return CommandValue.DONT_SAVE.getText().equals(text) || CommandValue.DISCARD.getText().equals(text);
    }
}

