/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.navigation;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentButtonFactory;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.resources.Fluent;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.internal.BackStack;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public final class BackButton {
    protected final IFluentResources fluentResources = FluentResources.getInstance();
    protected final FluentButtonFactory buttonFactory;
    private final BackStack backStack;
    private final PropertyChangeListener pageDisplayStringListener;
    private JButton button;

    public BackButton(BackStack backStack) {
        this(backStack, null);
    }

    public BackButton(BackStack backStack, Theme theme) {
        this.buttonFactory = new FluentButtonFactory(theme);
        this.backStack = Preconditions.checkNotNull(backStack, "The %s must not be null.", "page model");
        this.pageDisplayStringListener = this::onCurrentPageDisplayStringChanged;
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        this.button = this.buttonFactory.createButton(this.fluentResources.getBackIcon());
        this.button.setName("back_button");
        this.button.setFocusable(JSDLCommonSetup.isOptimizedForScreenReader());
        this.button.setPreferredSize(ScreenScaling.physicalDimension(48, 48));
        this.button.setForeground(this.getTheme().foreground());
    }

    private void initEventHandling() {
        this.button.addActionListener(this::onBackPerformed);
        ComponentUtils.registerKeyboardAction(this.button, new BackAction(), KeyStroke.getKeyStroke("alt LEFT"), 2);
        this.backStack.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "canGoBack": {
                    this.onCanGoBackChanged(evt);
                    break;
                }
                case "currentPage": {
                    this.onCurrentPageChanged(evt);
                    break;
                }
            }
        });
        this.updateEnablement();
        this.updateToolTip();
        Page currentPage = this.backStack.getCurrentPage();
        if (currentPage instanceof Bean) {
            ((Bean)((Object)currentPage)).addPropertyChangeListener(this.pageDisplayStringListener);
        }
    }

    public Theme getTheme() {
        return this.buttonFactory.getTheme();
    }

    public AbstractButton getComponent() {
        return this.button;
    }

    public boolean isVisible() {
        return this.button.isVisible();
    }

    public void setVisible(boolean visible) {
        this.button.setVisible(visible);
    }

    private void onBackPerformed(ActionEvent evt) {
        this.backStack.goBack(evt);
    }

    private void onCurrentPageChanged(PropertyChangeEvent evt) {
        Page newPage;
        Page oldPage = (Page)evt.getOldValue();
        if (oldPage instanceof Bean) {
            ((Bean)((Object)oldPage)).removePropertyChangeListener(this.pageDisplayStringListener);
        }
        if ((newPage = (Page)evt.getNewValue()) instanceof Bean) {
            ((Bean)((Object)newPage)).addPropertyChangeListener(this.pageDisplayStringListener);
        }
        this.updateToolTip();
    }

    private void onCurrentPageDisplayStringChanged(PropertyChangeEvent evt) {
        this.updateToolTip();
    }

    private void onCanGoBackChanged(PropertyChangeEvent evt) {
        this.updateEnablement();
    }

    private void updateToolTip() {
        this.button.setToolTipText(this.getToolTip(this.backStack));
    }

    private void updateEnablement() {
        this.button.setEnabled(this.backStack.canGoBack());
    }

    private ResourceMap getResources() {
        return new Fluent().getResourceMap(this.button.getLocale());
    }

    private String getToolTip(BackStack backStack) {
        if (!backStack.canGoBack()) {
            return this.getResources().getString("NavigationView.Back", new Object[0]);
        }
        String previousPageName = backStack.getPreviousPage().getDisplayString();
        return Strings.isBlank(previousPageName) ? this.getResources().getString("NavigationView.Back", new Object[0]) : this.getResources().getString("NavigationView.BackTo", previousPageName);
    }

    private final class BackAction
    extends AbstractAction {
        private BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            BackButton.this.onBackPerformed(evt);
        }
    }
}

