/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.search;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.quicksearch.ActionActivatable;
import com.jgoodies.quicksearch.Activatable;
import com.jgoodies.quicksearch.QuickSearchManager;
import com.jgoodies.quicksearch.QuickSearchProcessEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;

final class QuickSearchCategoryView {
    private final QuickSearchManager manager;
    private final ResourceMap resources;
    private final List<ResultRow> rows;
    private int selectionIndex;
    private final JPanel container;
    private final List<RowComponent> rowComponents;
    private JComponent categoryArea;
    private JComponent separator;

    QuickSearchCategoryView(QuickSearchManager manager, ResourceMap resources) {
        this.manager = Preconditions.checkNotNull(manager, "The %s must not be null.", "QuickSearchManager");
        this.resources = Preconditions.checkNotNull(resources, "The %s must not be null.", "ResourceMap");
        this.rows = new ArrayList<ResultRow>();
        this.selectionIndex = -1;
        this.rowComponents = new ArrayList<RowComponent>(this.rows.size());
        this.initComponents();
        this.container = new JPanel(new BorderLayout());
    }

    private void initComponents() {
        this.categoryArea = new JPanel(null);
        this.categoryArea.setBackground(this.resources.getColor("QuickSearch.categoryArea.background"));
        this.separator = QuickSearchCategoryView.createVerticalSeparator();
    }

    JComponent getPanel() {
        return this.container;
    }

    void update(List<Activatable> activatables) {
        int oldSelectionIndex = this.getSelectionIndex();
        this.rows.clear();
        this.rowComponents.clear();
        this.rows.addAll(QuickSearchCategoryView.flatten(QuickSearchCategoryView.categorizeAndSort(activatables)));
        if (this.manager.getOpenPreferencesAction() != null && this.hasSearchText()) {
            this.rows.add(new ResultRow(this.manager.getOpenPreferencesAction()));
        }
        this.container.removeAll();
        this.container.add((Component)this.buildContent(), "Center");
        if (this.rowComponents.isEmpty()) {
            this.setSelectionIndex(-1);
        } else {
            this.setSelectionIndex(Math.max(0, Math.min(this.lastIndex(), oldSelectionIndex)));
        }
    }

    void activateSelection(EventObject evt) {
        int index = this.getSelectionIndex();
        if (!(this.noResultFound() && index != 0 || index < 0)) {
            this.rows.get(index).activate(evt);
        }
    }

    void clearSelection() {
        this.setSelectionIndex(-1);
    }

    void selectFirst() {
        if (!this.rowComponents.isEmpty()) {
            this.setSelectionIndex(0);
        }
    }

    void selectLast() {
        this.setSelectionIndex(this.rowComponents.size() - 1);
    }

    void selectPrevious() {
        if (this.getSelectionIndex() > 0) {
            this.setSelectionIndex(this.getSelectionIndex() - 1);
        }
    }

    void selectNext() {
        if (this.getSelectionIndex() < this.lastIndex()) {
            this.setSelectionIndex(this.getSelectionIndex() + 1);
        }
    }

    void select(MouseEvent evt) {
        Point translatedPoint = new Point(evt.getPoint());
        Point origin = this.getPanel().getLocation();
        translatedPoint.translate(origin.x, origin.y);
        for (RowComponent rowComponent : this.rowComponents) {
            if (!rowComponent.contains(evt.getPoint())) continue;
            this.setSelectionIndex(this.rowComponents.indexOf(rowComponent));
        }
    }

    private int lastIndex() {
        return this.rowComponents.size() - 1;
    }

    private int getSelectionIndex() {
        return this.selectionIndex;
    }

    private void setSelectionIndex(int newIndex) {
        int oldIndex = this.getSelectionIndex();
        if (oldIndex != -1 && oldIndex < this.rowComponents.size()) {
            this.rowComponents.get(oldIndex).setSelected(false);
        }
        this.selectionIndex = newIndex;
        if (newIndex != -1) {
            this.rowComponents.get(newIndex).setSelected(true);
        }
        this.container.repaint();
    }

    private JComponent buildContent() {
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("3dlu, right:65dlu, 3dlu, p, 2dlu, 3epx, 100dlu, 3dlu", new Object[0])).rows("", new Object[0])).background(this.resources.getColor("QuickSearch.resultArea.background"))).panel(new JPanel(null));
        String gapSpec = "4dlu";
        String lineSpec = "p";
        builder.getPanel().setFocusable(false);
        int row = 0;
        if (this.noResultFound()) {
            builder.appendRows(gapSpec, new Object[0]);
            ++row;
            builder.appendRows(lineSpec, new Object[0]);
            JLabel label = new JLabel(this.resources.getString("QuickSearch.noResultFound", new Object[0]));
            label.setFont(label.getFont().deriveFont(2));
            builder.add(label).xy(7, ++row);
        }
        for (ResultRow resultRow : this.rows) {
            if (resultRow.gap) {
                builder.appendRows(gapSpec, new Object[0]);
            }
            builder.appendRows(lineSpec, new Object[0]);
        }
        FormLayout layout = (FormLayout)builder.getPanel().getLayout();
        if (layout.getRowCount() == 0) {
            return builder.build();
        }
        builder.appendRows(gapSpec, new Object[0]);
        int rowCount = layout.getRowCount();
        builder.add(this.separator).xywh(4, 1, 1, rowCount);
        for (ResultRow resultRow : this.rows) {
            int n = resultRow.gap ? 2 : 1;
            RowComponent rowComponent = new RowComponent(resultRow);
            this.rowComponents.add(rowComponent);
            rowComponent.addTo(builder, row += n);
        }
        builder.add(this.categoryArea).xywh(1, 1, 3, rowCount);
        return builder.build();
    }

    private boolean hasSearchText() {
        return Strings.isNotBlank(this.manager.getSearchText());
    }

    private boolean noResultFound() {
        return this.manager.getState() == QuickSearchProcessEvent.State.PROCESS_SUCCEEDED && this.hasSearchText() && this.manager.getActivatables().isEmpty();
    }

    private static JComponent createVerticalSeparator() {
        JPanel panel = new JPanel(null);
        panel.setBackground(new ColorUIResource(233, 233, 233));
        return panel;
    }

    private static List<Category> categorizeAndSort(List<Activatable> activatables) {
        HashMap<String, Category> map = new HashMap<String, Category>();
        for (Activatable activatable : activatables) {
            String categoryName = activatable.getCategory();
            Category category = (Category)map.get(categoryName);
            if (category == null) {
                category = new Category(categoryName);
                map.put(categoryName, category);
            }
            category.add(activatable);
        }
        ArrayList<Category> categories = new ArrayList<Category>(map.values());
        Collections.sort(categories);
        return categories;
    }

    private static List<ResultRow> flatten(List<Category> categories) {
        ArrayList<ResultRow> result = new ArrayList<ResultRow>();
        for (Category category : categories) {
            boolean first = true;
            for (Activatable activatable : category.getSortedList()) {
                result.add(new ResultRow(first, activatable));
                first = false;
            }
        }
        return result;
    }

    private static int compareRank(Activatable o1, Activatable o2) {
        int r2;
        if (o1 == o2) {
            return 0;
        }
        int r1 = o1.getRank();
        if (r1 == (r2 = o2.getRank())) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
        return r1 > r2 ? -1 : 1;
    }

    private static final class Category
    implements Comparable<Category> {
        private final String name;
        private final List<Activatable> activatables;
        private int maxRank;

        Category(String name) {
            this.name = name;
            this.activatables = new ArrayList<Activatable>();
            this.maxRank = 0;
        }

        void add(Activatable activatable) {
            this.maxRank = Math.max(this.maxRank, activatable.getRank());
            this.activatables.add(activatable);
        }

        String getName() {
            return this.name;
        }

        List<Activatable> getSortedList() {
            Collections.sort(this.activatables, (x$0, x$1) -> QuickSearchCategoryView.compareRank(x$0, x$1));
            return Collections.unmodifiableList(this.activatables);
        }

        @Override
        public int compareTo(Category c) {
            if (this == c) {
                return 0;
            }
            int r1 = this.maxRank;
            int r2 = c.maxRank;
            if (r1 == r2) {
                return this.getName().compareTo(c.getName());
            }
            if (r1 < r2) {
                return 1;
            }
            return -1;
        }
    }

    static final class ResultRow {
        private final boolean gap;
        private final String category;
        private final Activatable activatable;

        private ResultRow(boolean gap, String category, Activatable activatable) {
            this.gap = gap;
            this.category = category;
            this.activatable = activatable;
        }

        ResultRow(boolean first, Activatable activatable) {
            this(first, first ? activatable.getCategory() : null, activatable);
        }

        ResultRow(Action action) {
            this(true, null, new ActionActivatable("unused", action, -1));
        }

        Icon getIcon() {
            return this.activatable.getIcon();
        }

        String getDescription() {
            return this.activatable.getDisplayString();
        }

        void activate(EventObject evt) {
            this.activatable.activate(evt);
        }
    }

    static final class RowComponent {
        JComponent categoryLabel;
        JComponent iconLabel;
        JLabel descriptionLabel;
        JPanel background;

        RowComponent(ResultRow row) {
            this.categoryLabel = row.category == null ? null : RowComponent.createCategoryLabel(row.category);
            this.iconLabel = row.getIcon() == null ? null : new JLabel(row.getIcon());
            this.descriptionLabel = new JLabel(row.getDescription());
            this.descriptionLabel.setBorder(Paddings.createPadding("1dlu, 0, 1dlu, 0", new Object[0]));
            this.background = new JPanel(null);
            this.background.setBackground(UIManager.getColor("List.selectionBackground"));
            this.setSelected(false);
        }

        void setSelected(boolean selected) {
            Color foreground = UIManager.getColor(selected ? "List.selectionForeground" : "List.foreground");
            if (this.categoryLabel != null) {
                this.categoryLabel.setForeground(foreground);
            }
            this.descriptionLabel.setForeground(foreground);
            this.background.setOpaque(selected);
        }

        void addTo(FormBuilder builder, int row) {
            if (this.categoryLabel != null) {
                builder.add(this.categoryLabel).xy(2, row);
            }
            if (this.iconLabel != null) {
                // empty if block
            }
            builder.add(this.descriptionLabel).xy(7, row);
            builder.add(this.background).xyw(1, row, 8, "fill, fill");
        }

        boolean contains(Point p) {
            return this.background.getBounds().contains(p);
        }

        private static JComponent createCategoryLabel(String category) {
            JLabel label = new JLabel(category);
            Font smallerFont = label.getFont().deriveFont(label.getFont().getSize2D() - 1.0f);
            label.setFont(smallerFont);
            label.setBorder(new EmptyBorder(1, 0, 0, 0));
            return label;
        }
    }
}

