/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.common.jsdl.i18n.Resources;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.jdiskreport.gui.application.JDDetailsResources;
import com.jgoodies.jdiskreport.gui.application.JDResources;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.shared.format.JDFormats;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.util.FocusTraversalType;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;

public final class JDResultDetailsView {
    private static JDDetailsResources resources = Resources.get(JDDetailsResources.class);
    private final JDResultModel resultModel;
    private JTextField fileCountField;
    private JTextField directoryCountField;
    private JTextField totalSizeField;
    private JTextField largestFileField;
    private JTextField absoluteSizeField;
    private JTextField relativeSizeField;
    private JTextField leastRecentlyUsedField;
    private JTextField mostRecentlyUsedField;

    JDResultDetailsView(JDResultModel resultModel) {
        this.resultModel = resultModel;
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.fileCountField = factory.createReadOnlyTextField();
        this.directoryCountField = factory.createReadOnlyTextField();
        this.totalSizeField = factory.createReadOnlyTextField();
        this.largestFileField = factory.createReadOnlyTextField();
        this.absoluteSizeField = factory.createReadOnlyTextField();
        this.relativeSizeField = factory.createReadOnlyTextField();
        this.leastRecentlyUsedField = factory.createReadOnlyTextField();
        this.mostRecentlyUsedField = factory.createReadOnlyTextField();
        JDResultDetailsView.alignRight(this.fileCountField, this.directoryCountField, this.totalSizeField, this.largestFileField, this.absoluteSizeField, this.relativeSizeField);
    }

    private void initEventHandling() {
        this.resultModel.getNavigationModel().addPropertyChangeListener("selection", this::onSelectionChanged);
        this.updateTexts();
    }

    JComponent buildPanel() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("r:p, 2dlu, [28dlu,p], 20dlu, r:p, 2dlu, [30dlu,p], 20dlu, r:p, 2dlu, '> 99.9  %', 20dlu, r:p, 2dlu, [52dlu,p]", new Object[0])).rows("2dlu, p, 2dlu, p", new Object[0])).background(JDResources.background())).padding("5dlu, 7dlu, 7dlu, 7dlu", new Object[0])).focusTraversalType(FocusTraversalType.CONTAINER_ORDER)).readOnlyLabels()).add(JDResultDetailsView.resources.files, new Object[0]).xy(1, 2)).add(this.fileCountField).xy(3, 2)).add(JDResultDetailsView.resources.directories, new Object[0]).xy(1, 4)).add(this.directoryCountField).xy(3, 4)).add(JDResultDetailsView.resources.totalSize, new Object[0]).xy(5, 2)).add(this.totalSizeField).xy(7, 2)).add(JDResultDetailsView.resources.largestFile, new Object[0]).xy(5, 4)).add(this.largestFileField).xy(7, 4)).add(JDResultDetailsView.resources.absoluteSize, new Object[0]).xy(9, 2)).add(this.absoluteSizeField).xy(11, 2)).add(JDResultDetailsView.resources.relativeSize, new Object[0]).xy(9, 4)).add(this.relativeSizeField).xy(11, 4)).add(JDResultDetailsView.resources.leastRecentlyUsed, new Object[0]).xy(13, 2)).add(this.leastRecentlyUsedField).xy(15, 2)).add(JDResultDetailsView.resources.mostRecentlyUsed, new Object[0]).xy(13, 4)).add(this.mostRecentlyUsedField).xy(15, 4)).build();
    }

    private void onSelectionChanged(PropertyChangeEvent evt) {
        this.updateTexts();
    }

    private void updateTexts() {
        DirectoryNode selection = this.resultModel.getNavigationModel().getSelection();
        if (selection == null) {
            return;
        }
        this.fileCountField.setText(JDFormats.formatCount(selection.getFileCount()));
        this.directoryCountField.setText(JDFormats.formatCount(selection.getDirectoryCount()));
        this.totalSizeField.setText(JDFormats.formatSize(selection.getSize()));
        this.absoluteSizeField.setText(JDFormats.formatPercent(selection.getAbsoluteSize()));
        this.relativeSizeField.setText(JDFormats.formatPercent(selection.getRelativeSize()));
        boolean noFiles = selection.getFileCount() == 0L;
        String largestText = noFiles ? "" : JDFormats.formatSize(selection.getLargestFile().getSize());
        String leastRecentlyUsedText = noFiles ? "" : JDFormats.formatDateTime(selection.getLeastRecentlyUsedFile().getLastUsedMillis());
        String mostRecentlyUsedText = noFiles ? "" : JDFormats.formatDateTime(selection.getMostRecentlyUsedFile().getLastUsedMillis());
        this.largestFileField.setText(largestText);
        this.leastRecentlyUsedField.setText(leastRecentlyUsedText);
        this.mostRecentlyUsedField.setText(mostRecentlyUsedText);
    }

    private static void alignRight(JTextField ... fields) {
        for (JTextField field : fields) {
            field.setHorizontalAlignment(4);
        }
    }
}

