/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.diagnostics;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.Manifest;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryLayout;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\bH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH$J\"\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\bH$\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker;", "", "<init>", "()V", "check", "", "libraries", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getJarManifest", "Ljava/util/jar/Manifest;", "getRawCompilerVersion", "", "shouldCheckLibrary", "", "library", "getMessageToReport", "compilerVersion", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Version;", "libraryVersion", "Version", "Companion", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nLibrarySpecialCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrarySpecialCompatibilityChecker.kt\norg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public abstract class LibrarySpecialCompatibilityChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static Companion.CustomCompilerVersionForTest customCompilerVersionForTest;
    @NotNull
    public static final String KLIB_JAR_MANIFEST_FILE = "META-INF/MANIFEST.MF";
    @NotNull
    public static final String KLIB_JAR_LIBRARY_VERSION = "Implementation-Version";

    public final void check(@NotNull Collection<? extends KotlinLibrary> libraries, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(libraries, "libraries");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Version version2 = Version.Companion.parseVersion(this.getRawCompilerVersion());
        if (version2 == null) {
            return;
        }
        Version compilerVersion2 = version2;
        for (KotlinLibrary kotlinLibrary : libraries) {
            Version libraryVersion;
            String messageToReport;
            Manifest jarManifest;
            if (!this.shouldCheckLibrary(kotlinLibrary) || this.getJarManifest(kotlinLibrary) == null || Version.Companion.parseVersion(jarManifest.getMainAttributes().getValue(KLIB_JAR_LIBRARY_VERSION)) == null || (messageToReport = this.getMessageToReport(compilerVersion2, libraryVersion, kotlinLibrary)) == null) continue;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, messageToReport, null, 4, null);
        }
    }

    private final Manifest getJarManifest(KotlinLibrary $this$getJarManifest) {
        Intrinsics.checkNotNull($this$getJarManifest, "null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        return ((KotlinLibraryImpl)$this$getJarManifest).getBase().getAccess().inPlace(LibrarySpecialCompatibilityChecker::getJarManifest$lambda$0);
    }

    private final String getRawCompilerVersion() {
        Companion.CustomCompilerVersionForTest customCompilerVersionForTest = LibrarySpecialCompatibilityChecker.customCompilerVersionForTest;
        if (customCompilerVersionForTest != null) {
            Companion.CustomCompilerVersionForTest it = customCompilerVersionForTest;
            boolean bl = false;
            return it.getVersion();
        }
        return KotlinCompilerVersion.getVersion();
    }

    protected abstract boolean shouldCheckLibrary(@NotNull KotlinLibrary var1);

    @Nullable
    protected abstract String getMessageToReport(@NotNull Version var1, @NotNull Version var2, @NotNull KotlinLibrary var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Manifest getJarManifest$lambda$0(KotlinLibraryLayout layout) {
        Object object;
        Intrinsics.checkNotNullParameter(layout, "layout");
        File jarManifestFile = layout.getLibFile().child(KLIB_JAR_MANIFEST_FILE);
        if (!jarManifestFile.isFile()) {
            return null;
        }
        try {
            Manifest manifest;
            object = new ByteArrayInputStream(jarManifestFile.readBytes());
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                boolean bl = false;
                manifest = new Manifest(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            object = manifest;
        }
        catch (IOException iOException) {
            object = null;
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Companion;", "", "<init>", "()V", "customCompilerVersionForTest", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Companion$CustomCompilerVersionForTest;", "setUpCustomCompilerVersionForTest", "", "compilerVersion", "", "resetUpCustomCompilerVersionForTest", "KLIB_JAR_MANIFEST_FILE", "KLIB_JAR_LIBRARY_VERSION", "CustomCompilerVersionForTest", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Only for test purposes, use with care!")
        public final void setUpCustomCompilerVersionForTest(@Nullable String compilerVersion2) {
            LibrarySpecialCompatibilityChecker.customCompilerVersionForTest = new CustomCompilerVersionForTest(compilerVersion2);
        }

        @Deprecated(message="Only for test purposes, use with care!")
        public final void resetUpCustomCompilerVersionForTest() {
            LibrarySpecialCompatibilityChecker.customCompilerVersionForTest = null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Companion$CustomCompilerVersionForTest;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "ir.serialization.common"})
        private static final class CustomCompilerVersionForTest {
            @Nullable
            private final String version;

            public CustomCompilerVersionForTest(@Nullable String version2) {
                this.version = version2;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Version;", "", "comparableVersion", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "rawVersion", "", "<init>", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;Lorg/jetbrains/kotlin/config/LanguageVersion;Ljava/lang/String;)V", "compareTo", "", "other", "equals", "", "", "hashCode", "hasSameLanguageVersion", "toString", "toComparableVersionString", "toLanguageVersionString", "Companion", "ir.serialization.common"})
    protected static final class Version
    implements Comparable<Version> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MavenComparableVersion comparableVersion;
        @NotNull
        private final LanguageVersion languageVersion;
        @NotNull
        private final String rawVersion;

        public Version(@NotNull MavenComparableVersion comparableVersion, @NotNull LanguageVersion languageVersion, @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter(comparableVersion, "comparableVersion");
            Intrinsics.checkNotNullParameter(languageVersion, "languageVersion");
            Intrinsics.checkNotNullParameter(rawVersion, "rawVersion");
            this.comparableVersion = comparableVersion;
            this.languageVersion = languageVersion;
            this.rawVersion = rawVersion;
        }

        @Override
        public int compareTo(@NotNull Version other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.comparableVersion.compareTo(other.comparableVersion);
        }

        public boolean equals(@Nullable Object other) {
            Version version2 = other instanceof Version ? (Version)other : null;
            return Intrinsics.areEqual(version2 != null ? version2.comparableVersion : null, this.comparableVersion);
        }

        public int hashCode() {
            return this.comparableVersion.hashCode();
        }

        public final boolean hasSameLanguageVersion(@NotNull Version other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.languageVersion == other.languageVersion;
        }

        @NotNull
        public String toString() {
            return this.rawVersion;
        }

        @NotNull
        public final String toComparableVersionString() {
            String string = this.comparableVersion.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        @NotNull
        public final String toLanguageVersionString() {
            return this.languageVersion.toString();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Version$Companion;", "", "<init>", "()V", "parseVersion", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Version;", "rawVersion", "", "ir.serialization.common"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Version parseVersion(@Nullable String rawVersion) {
                MavenComparableVersion mavenComparableVersion;
                if (rawVersion == null) {
                    return null;
                }
                try {
                    mavenComparableVersion = new MavenComparableVersion(StringsKt.substringBefore$default(rawVersion, '-', null, 2, null));
                }
                catch (Exception e2) {
                    return null;
                }
                MavenComparableVersion comparableVersion = mavenComparableVersion;
                LanguageVersion languageVersion = LanguageVersion.Companion.fromFullVersionString(rawVersion);
                if (languageVersion == null) {
                    return null;
                }
                LanguageVersion languageVersion2 = languageVersion;
                return new Version(comparableVersion, languageVersion2, rawVersion);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

