/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComponentGraphResolveState<T extends ComponentGraphResolveMetadata>
implements ComponentGraphResolveState,
ComponentArtifactResolveState {
    private final long instanceId;
    private final T graphMetadata;
    private final AttributeDesugaring attributeDesugaring;
    private final ImmutableCapability implicitCapability;
    private final ConcurrentHashMap<Long, ResolvedVariantResult> publicVariants = new ConcurrentHashMap();

    public AbstractComponentGraphResolveState(long instanceId, T graphMetadata, AttributeDesugaring attributeDesugaring) {
        this.instanceId = instanceId;
        this.graphMetadata = graphMetadata;
        this.attributeDesugaring = attributeDesugaring;
        this.implicitCapability = DefaultImmutableCapability.defaultCapabilityForComponent(graphMetadata.getModuleVersionId());
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.graphMetadata.getId();
    }

    public T getMetadata() {
        return this.graphMetadata;
    }

    @Override
    public boolean isAdHoc() {
        return false;
    }

    protected AttributeDesugaring getAttributeDesugaring() {
        return this.attributeDesugaring;
    }

    @Override
    public ComponentArtifactResolveState prepareForArtifactResolution() {
        return this;
    }

    @Override
    public void resolveArtifactsWithType(ArtifactResolver artifactResolver, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        artifactResolver.resolveArtifactsWithType(this.getArtifactMetadata(), artifactType, result);
    }

    @Override
    public ImmutableCapability getDefaultCapability() {
        return this.implicitCapability;
    }

    protected ImmutableCapabilities capabilitiesFor(ImmutableCapabilities capabilities) {
        if (capabilities.asSet().isEmpty()) {
            return ImmutableCapabilities.of((Capability)DefaultImmutableCapability.defaultCapabilityForComponent(this.getMetadata().getModuleVersionId()));
        }
        return capabilities;
    }

    @Override
    public ResolvedVariantResult getPublicViewFor(VariantGraphResolveState variant, @Nullable ResolvedVariantResult externalVariant) {
        if (externalVariant != null) {
            return this.createVariantResult(variant, externalVariant);
        }
        return this.publicVariants.computeIfAbsent(variant.getInstanceId(), k -> this.createVariantResult(variant, null));
    }

    private DefaultResolvedVariantResult createVariantResult(VariantGraphResolveState variant, @Nullable ResolvedVariantResult externalVariant) {
        VariantGraphResolveMetadata metadata = variant.getMetadata();
        return new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)metadata.getName()), (AttributeContainer)this.attributeDesugaring.desugar(metadata.getAttributes()), this.capabilitiesFor(metadata.getCapabilities()), externalVariant);
    }
}

