/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deprecated;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.choiceset.AbilityFromClassChoiceSet;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.choiceset.CompoundOrChoiceSet;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.utils.ParsingSeparator;
import pcgen.persistence.lst.DeprecatedToken;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class RemoveFeatToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<CNAbilitySelection>,
DeprecatedToken {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<CNAbilitySelection> CAT_ABILITY_SELECTION_CLASS = CNAbilitySelection.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "REMOVE";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "FEAT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        Formula count;
        AbilityCategory category = AbilityCategory.FEAT;
        Nature nature = Nature.NORMAL;
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String activeValue = sep.next();
        if (!sep.hasNext()) {
            count = FormulaFactory.ONE;
        } else {
            count = FormulaFactory.getFormulaFor((String)activeValue);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            activeValue = sep.next();
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getFullName() + " had too many pipe separated items: " + value, context);
        }
        if (this.isEmpty(activeValue) || this.hasIllegalSeparator(',', activeValue)) {
            return ParseResult.INTERNAL_ERROR;
        }
        ArrayList<CDOMGroupRef> refs = new ArrayList<CDOMGroupRef>();
        ArrayList<Object> pcs = new ArrayList<Object>();
        ParsingSeparator tok = new ParsingSeparator(activeValue, ',');
        boolean foundAny = false;
        boolean foundOther = false;
        ReferenceManufacturer rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, (Category)AbilityCategory.FEAT);
        while (tok.hasNext()) {
            CDOMGroupRef ab = null;
            String token = tok.next();
            if ("CHOICE".equals(token) || "ANY".equals(token)) {
                foundAny = true;
                ab = rm.getAllReference();
            } else if (token.startsWith("CLASS.") || token.startsWith("CLASS=")) {
                String className = token.substring(6);
                if (className.length() == 0) {
                    return new ParseResult.Fail(this.getTokenName() + " must have Class name after " + token, context);
                }
                CDOMSingleRef pcc = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, className);
                AbilityFromClassChoiceSet acs = new AbilityFromClassChoiceSet(pcc);
                pcs.add(acs);
            } else {
                foundOther = true;
                ab = TokenUtilities.getTypeOrPrimitive((ReferenceManufacturer)rm, (String)token);
                if (ab == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName() + ": " + value + " had an invalid reference: " + token, context);
                }
            }
            if (ab == null) continue;
            refs.add(ab);
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        if (!refs.isEmpty()) {
            AbilityRefChoiceSet rcs = new AbilityRefChoiceSet((CDOMSingleRef)CDOMDirectSingleRef.getRef((Loadable)category), refs, nature);
            pcs.add(rcs);
        }
        if (pcs.isEmpty()) {
            return new ParseResult.Fail("Internal Error: " + this.getFullName() + " did not have any references: " + value, context);
        }
        Object ascs = pcs.size() == 1 ? (PrimitiveChoiceSet)pcs.get(0) : new CompoundOrChoiceSet(pcs, ",");
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), ascs, true);
        cs.setTitle("Select for removal");
        ConcretePersistentTransitionChoice tc = new ConcretePersistentTransitionChoice((SelectableSet)cs, count);
        context.getObjectContext().addToList(obj, ListKey.REMOVE, (Object)tc);
        tc.allowStack(true);
        tc.setChoiceActor((ChoiceActor)this);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes grantChanges = context.getObjectContext().getListChanges(obj, ListKey.REMOVE);
        Collection addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice container : addedItems) {
            SelectableSet cs = container.getChoices();
            if (!this.getTokenName().equals(cs.getName()) || !CAT_ABILITY_SELECTION_CLASS.equals(cs.getChoiceClass())) continue;
            Formula f = container.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(cs.getLSTformat());
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject owner, CNAbilitySelection choice, PlayerCharacter pc) {
        CNAbility cna = choice.getCNAbility();
        Ability anAbility = cna.getAbility();
        boolean result = false;
        if (((Boolean)anAbility.getSafe(ObjectKey.MULTIPLE_ALLOWED)).booleanValue()) {
            ChoiceManagerList cm = ChooserUtilities.getChoiceManager((ChooseDriver)cna, (PlayerCharacter)pc);
            RemoveFeatToken.remove(cm, pc, (ChooseDriver)cna, choice.getSelection());
            result = pc.hasAssociations((ChooseDriver)cna);
        }
        if (!result) {
            pc.removeAbility(choice, (Object)UserSelection.getInstance(), (Object)UserSelection.getInstance());
            CDOMObjectUtilities.removeAdds((CDOMObject)anAbility, (PlayerCharacter)pc);
            CDOMObjectUtilities.restoreRemovals((CDOMObject)anAbility, (PlayerCharacter)pc);
        }
        pc.adjustMoveRates();
        double cost = ((BigDecimal)cna.getAbility().getSafe(ObjectKey.SELECTION_COST)).doubleValue();
        pc.adjustAbilities((Category)AbilityCategory.FEAT, new BigDecimal(-cost));
    }

    private static <T> void remove(ChoiceManagerList<T> aMan, PlayerCharacter pc, ChooseDriver obj, String choice) {
        Object sel = aMan.decodeChoice(choice);
        aMan.removeChoice(pc, obj, sel);
    }

    public boolean allow(CNAbilitySelection choice, PlayerCharacter pc, boolean allowStack) {
        for (CNAbility cna : pc.getPoolAbilities((Category)AbilityCategory.FEAT, Nature.NORMAL)) {
            Boolean multYes;
            if (!cna.getAbilityKey().equals(choice.getAbilityKey()) || (multYes = (Boolean)cna.getAbility().getSafe(ObjectKey.MULTIPLE_ALLOWED)).booleanValue() && (!multYes.booleanValue() || !this.hasAssoc(pc.getAssociationList((ChooseDriver)cna), choice))) continue;
            return true;
        }
        return false;
    }

    private boolean hasAssoc(List<String> associationList, CNAbilitySelection choice) {
        if (associationList == null) {
            Logging.errorPrint((String)("Didn't have any associations for Ability: " + choice.getAbilityKey()));
            return false;
        }
        for (String a : associationList) {
            if (!choice.containsAssociation(a)) continue;
            return true;
        }
        return false;
    }

    public CNAbilitySelection decodeChoice(LoadContext context, String s) {
        return CNAbilitySelection.getAbilitySelectionFromPersistentFormat((String)s);
    }

    public String encodeChoice(CNAbilitySelection choice) {
        return choice.getPersistentFormat();
    }

    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, CNAbilitySelection choice) {
    }

    public void removeChoice(PlayerCharacter pc, CDOMObject owner, CNAbilitySelection choice) {
        Ability anAbility;
        if (!pc.isImporting()) {
            pc.getSpellList();
        }
        if ((anAbility = pc.getMatchingAbility((Category)AbilityCategory.FEAT, choice.getCNAbility().getAbility(), Nature.NORMAL)) != null) {
            pc.removeAbility(choice, (Object)owner, (Object)this);
            CDOMObjectUtilities.removeAdds((CDOMObject)anAbility, (PlayerCharacter)pc);
            CDOMObjectUtilities.restoreRemovals((CDOMObject)anAbility, (PlayerCharacter)pc);
            pc.adjustMoveRates();
        }
    }

    public String getMessage(CDOMObject obj, String value) {
        return "Feat-based tokens have been deprecated - use ABILITY based functions";
    }
}

