/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.ColorUIResource2;
import com.incors.plaf.FastGradientPaint;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class KunststoffUtilities {
    public static Color getTranslucentColor(Color color, int n) {
        if (color == null) {
            return null;
        }
        if (n == 255) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color getTranslucentColorUIResource(Color color, int n) {
        if (color == null) {
            return null;
        }
        if (n == 255) {
            return color;
        }
        return new ColorUIResource2(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static void drawGradient(Graphics graphics, Color color, Color color2, Rectangle rectangle, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FastGradientPaint fastGradientPaint = new FastGradientPaint(color, color2, bl);
        graphics2D.setPaint(fastGradientPaint);
        graphics2D.fill(rectangle);
    }

    public static void drawGradient(Graphics graphics, Color color, Color color2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint(0.0f, (float)rectangle.getY(), color, 0.0f, (float)(rectangle.getHeight() + rectangle.getY()), color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint((float)rectangle.getX(), 0.0f, color, (float)(rectangle.getWidth() + rectangle.getX()), 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle);
        }
    }

    public static boolean isToolkitTrueColor(Component component) {
        int n = component.getToolkit().getColorModel().getPixelSize();
        return n >= 24;
    }
}

