/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pcgen.core.PlayerCharacter;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.system.LanguageBundle;

public class ImagePreview
extends JPanel
implements PropertyChangeListener {
    private static final int SIZE = 200;
    private static String in_notAnImage = LanguageBundle.getString("in_ImagePreview_notAnImage");
    private static String in_noCharacterPortrait = LanguageBundle.getString("in_ImagePreview_noCharacterPortrait");
    private final JFileChooser jfc;
    private PlayerCharacter aPC;
    private Image image;

    public ImagePreview(JFileChooser jfc) {
        this.jfc = jfc;
        jfc.addPropertyChangeListener(this);
        jfc.setAccessory(this);
        this.setPreferredSize(new Dimension(200, 200));
    }

    public static JFileChooser decorateWithImagePreview(JFileChooser jfc) {
        new ImagePreview(jfc);
        return jfc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.updateImage(this.jfc.getSelectedFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateImage(File file) throws IOException {
        if (null == file || !file.exists()) {
            this.image = null;
            return;
        }
        if (PCGFile.isPCGenCharacterFile(file)) {
            this.aPC = new PlayerCharacter(false, Collections.EMPTY_LIST);
            new PCGIOHandler().readForPreview(this.aPC, file.getAbsolutePath());
            String portraitPath = this.aPC.getDisplay().getPortraitPath();
            this.image = ImagePreview.isNullOrEmpty(portraitPath) ? null : ImageIO.read(new File(portraitPath));
        } else {
            this.aPC = null;
            this.image = ImageIO.read(file);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(UIManager.getColor("Panel.background"));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int textX = ImagePreview.getFontHeightHint(g);
        int textY = 200 - ImagePreview.getFontHeightHint(g);
        if (null != this.image) {
            int width = this.image.getWidth(null);
            int height = this.image.getHeight(null);
            int side = Math.max(width, height);
            double scale = 200.0 / (double)side;
            g.drawImage(this.image, 0, 0, (int)(scale * (double)width), (int)(scale * (double)height), null);
            String dim = width + " x " + height;
            g.setColor(Color.black);
            g.drawString(dim, textX, textY);
            g.setColor(Color.white);
            g.drawString(dim, textX - 1, textX - 1);
        } else {
            g.setColor(UIManager.getColor("Panel.foreground"));
            g.drawString(this.aPC == null ? in_notAnImage : in_noCharacterPortrait, textX, textY);
        }
    }

    private static boolean isNullOrEmpty(String s) {
        return null == s || "".equals(s);
    }

    private static int getFontHeightHint(Graphics g) {
        return g.getFontMetrics().getHeight();
    }
}

