/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.gui.ExtendedHTMLEditorKit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;

public class RelativeImageView
extends View
implements ImageObserver {
    private static Icon sPendingImageIcon;
    private static Icon sMissingImageIcon;
    private static final String PENDING_IMAGE_SRC = "icons/image-delayed.gif";
    private static final String MISSING_IMAGE_SRC = "icons/image-failed.gif";
    private static final String IMAGE_CACHE_PROPERTY = "imageCache";
    private static final int DEFAULT_WIDTH = 38;
    private static final int DEFAULT_HEIGHT = 38;
    private static final int DEFAULT_BORDER = 2;
    private static final int LOADING_FLAG = 1;
    private static final int LINK_FLAG = 2;
    private static final int WIDTH_FLAG = 4;
    private static final int HEIGHT_FLAG = 8;
    private static final int RELOAD_FLAG = 16;
    private static final int RELOAD_IMAGE_FLAG = 32;
    private static final int SYNC_LOAD_FLAG = 64;
    private AttributeSet attr;
    private Color borderColor;
    private Container container;
    private Image image;
    private ImageObserver imageObserver;
    private Rectangle fBounds = new Rectangle();
    private View altView;
    private float vAlign;
    private int height;
    private int state = 48;
    private int width;
    private short borderSize;
    private short bottomInset;
    private short leftInset;
    private short rightInset;
    private short topInset;

    public RelativeImageView(Element elem) {
        super(elem);
        this.imageObserver = new ImageHandler();
    }

    @Override
    public float getAlignment(int axis) {
        switch (axis) {
            case 1: {
                return this.vAlign;
            }
        }
        return super.getAlignment(axis);
    }

    public String getAltText() {
        return (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
    }

    @Override
    public AttributeSet getAttributes() {
        this.sync();
        return this.attr;
    }

    public Image getImage() {
        this.sync();
        return this.image;
    }

    public URL getImageURL() {
        String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (src == null) {
            return null;
        }
        URL reference = ((HTMLDocument)this.getDocument()).getBase();
        try {
            URL u = new URL(reference, src);
            return u;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Icon getLoadingImageIcon() {
        this.loadDefaultIconsIfNecessary();
        return sPendingImageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadsSynchronously(boolean newValue) {
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            this.state = newValue ? (this.state |= 0x40) : (this.state | 0x40) ^ 0x40;
        }
    }

    public boolean getLoadsSynchronously() {
        return (this.state & 0x40) != 0;
    }

    public Icon getNoImageIcon() {
        this.loadDefaultIconsIfNecessary();
        return sMissingImageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(View parent) {
        View oldParent = this.getParent();
        super.setParent(parent);
        Container container = this.container = parent != null ? this.getContainer() : null;
        if (oldParent != parent) {
            RelativeImageView relativeImageView = this;
            synchronized (relativeImageView) {
                this.state |= 0x10;
            }
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.sync();
        if (axis == 0 && (this.state & 4) == 4) {
            this.getPreferredSpanFromAltView(axis);
            return this.width + this.leftInset + this.rightInset;
        }
        if (axis == 1 && (this.state & 8) == 8) {
            this.getPreferredSpanFromAltView(axis);
            return this.height + this.topInset + this.bottomInset;
        }
        Image anImage = this.getImage();
        if (anImage != null) {
            switch (axis) {
                case 0: {
                    return this.width + this.leftInset + this.rightInset;
                }
                case 1: {
                    return this.height + this.topInset + this.bottomInset;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
        View view = this.getAltView();
        float retValue = 0.0f;
        if (view != null) {
            retValue = view.getPreferredSpan(axis);
        }
        switch (axis) {
            case 0: {
                return retValue + (float)(this.width + this.leftInset + this.rightInset);
            }
            case 1: {
                return retValue + (float)(this.height + this.topInset + this.bottomInset);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public void setSize(float width, float height) {
        View view;
        this.sync();
        if (this.getImage() == null && (view = this.getAltView()) != null) {
            view.setSize(Math.max(0.0f, width - (float)(38 + this.leftInset + this.rightInset)), Math.max(0.0f, height - (float)(this.topInset + this.bottomInset)));
        }
    }

    @Override
    public String getToolTipText(float x, float y, Shape allocation) {
        return this.getAltText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            this.state |= 0x30;
        }
        this.preferenceChanged(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int aWidth, int aHeight) {
        if (this.image == null || this.image != img) {
            return false;
        }
        if ((flags & 0xC0) != 0) {
            this.image = null;
            this.repaint(0L);
            return false;
        }
        short changed = 0;
        if ((flags & 2) != 0 && !this.getElement().getAttributes().isDefined(HTML.Attribute.HEIGHT)) {
            changed = (short)(changed | 1);
        }
        if ((flags & 1) != 0 && !this.getElement().getAttributes().isDefined(HTML.Attribute.WIDTH)) {
            changed = (short)(changed | 2);
        }
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            if ((changed & 1) == 1) {
                this.width = aWidth;
            }
            if ((changed & 2) == 2) {
                this.height = aHeight;
            }
            if ((this.state & 1) == 1) {
                return true;
            }
        }
        if (changed != 0) {
            Document doc = this.getDocument();
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readLock();
                }
                this.preferenceChanged(this, true, true);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
            return true;
        }
        if ((flags & 0x30) != 0) {
            this.repaint(0L);
        }
        return (flags & 0x20) == 0;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        this.sync();
        Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Image anImage = this.getImage();
        Rectangle clip = g.getClipBounds();
        this.fBounds.setBounds(rect);
        this.paintHighlights(g, a);
        this.paintBorder(g, rect);
        if (clip != null) {
            g.clipRect(rect.x + this.leftInset, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset, rect.height - this.topInset - this.bottomInset);
        }
        if (anImage != null) {
            if (!this.hasPixels(anImage)) {
                Icon icon = this.getLoadingImageIcon();
                if (icon != null) {
                    icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
                }
            } else {
                g.drawImage(anImage, rect.x + this.leftInset, rect.y + this.topInset, this.width, this.height, this.imageObserver);
            }
        } else {
            View view;
            Icon icon = this.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
            }
            if ((view = this.getAltView()) != null && ((this.state & 4) == 0 || this.width > 38)) {
                Rectangle altRect = new Rectangle(rect.x + this.leftInset + 38, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset - 38, rect.height - this.topInset - this.bottomInset);
                view.paint(g, altRect);
            }
        }
        if (clip != null) {
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertiesFromAttributes() {
        AttributeSet anchorAttr;
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.borderSize = (short)this.getIntAttr(HTML.Attribute.BORDER, this.isLink() ? 2 : 0);
        if (this.borderSize == 0 && this.image == null) {
            this.borderSize = 1;
        }
        this.leftInset = this.rightInset = (short)(this.getIntAttr(HTML.Attribute.HSPACE, 0) + this.borderSize);
        this.topInset = this.bottomInset = (short)(this.getIntAttr(HTML.Attribute.VSPACE, 0) + this.borderSize);
        this.borderColor = ((StyledDocument)this.getDocument()).getForeground(this.getAttributes());
        AttributeSet anAttr = this.getElement().getAttributes();
        Object alignment = anAttr.getAttribute(HTML.Attribute.ALIGN);
        this.vAlign = 1.0f;
        if (alignment != null) {
            if ("top".equals(alignment = alignment.toString())) {
                this.vAlign = 0.0f;
            } else if ("middle".equals(alignment)) {
                this.vAlign = 0.5f;
            }
        }
        if ((anchorAttr = (AttributeSet)anAttr.getAttribute(HTML.Tag.A)) != null && anchorAttr.isDefined(HTML.Attribute.HREF)) {
            RelativeImageView relativeImageView = this;
            synchronized (relativeImageView) {
                this.state |= 2;
            }
        }
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            this.state = (this.state | 2) ^ 2;
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View getAltView() {
        View view;
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            view = this.altView;
        }
        if (view != null && view.getParent() == null) {
            view.setParent(this.getParent());
        }
        return view;
    }

    private int getIntAttr(HTML.Attribute name, int deflt) {
        AttributeSet anAttr = this.getElement().getAttributes();
        if (anAttr.isDefined(name)) {
            int i;
            String val = (String)anAttr.getAttribute(name);
            if (val == null) {
                i = deflt;
            } else {
                try {
                    i = Math.max(0, Integer.parseInt(val));
                }
                catch (NumberFormatException x) {
                    i = deflt;
                }
            }
            return i;
        }
        return deflt;
    }

    private boolean isLink() {
        return (this.state & 2) == 2;
    }

    private float getPreferredSpanFromAltView(int axis) {
        View view;
        if (this.getImage() == null && (view = this.getAltView()) != null) {
            return view.getPreferredSpan(axis);
        }
        return 0.0f;
    }

    private boolean isURL() {
        String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        return src.toLowerCase().startsWith("file") || src.toLowerCase().startsWith("http");
    }

    private boolean hasPixels(Image anImage) {
        return anImage != null && anImage.getHeight(this.imageObserver) > 0 && anImage.getWidth(this.imageObserver) > 0;
    }

    private void loadDefaultIconsIfNecessary() {
        try {
            if (sPendingImageIcon == null) {
                sPendingImageIcon = this.makeIcon(PENDING_IMAGE_SRC);
            }
            if (sMissingImageIcon == null) {
                sMissingImageIcon = this.makeIcon(MISSING_IMAGE_SRC);
            }
        }
        catch (IOException x) {
            System.err.println("RelativeImageView: Couldn't load image icons");
        }
    }

    private void loadImage() {
        if (this.isURL()) {
            Image newImage = null;
            URL src = this.getImageURL();
            if (src != null) {
                Dictionary cache = (Dictionary)this.getDocument().getProperty(IMAGE_CACHE_PROPERTY);
                if (cache != null) {
                    newImage = (Image)cache.get(src);
                } else {
                    newImage = Toolkit.getDefaultToolkit().getImage(src);
                    if (newImage != null && this.getLoadsSynchronously()) {
                        ImageIcon ii = new ImageIcon();
                        ii.setImage(newImage);
                    }
                }
            }
            this.image = newImage;
        } else {
            String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
            src = this.processSrcPath(src);
            this.image = Toolkit.getDefaultToolkit().createImage(src);
            try {
                this.waitForImage();
            }
            catch (InterruptedException e) {
                this.image = null;
            }
        }
    }

    private Icon makeIcon(String gifFile) throws IOException {
        int n;
        InputStream resource = ExtendedHTMLEditorKit.getResourceAsStream(gifFile);
        if (resource == null) {
            System.err.println(RelativeImageView.class.getName() + "/" + gifFile + " not found.");
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.flush();
        buffer = out.toByteArray();
        if (buffer.length == 0) {
            System.err.println("warning: " + gifFile + " is zero-length");
            return null;
        }
        return new ImageIcon(buffer);
    }

    private void paintBorder(Graphics g, Rectangle rect) {
        Color color = this.borderColor;
        if (this.borderSize > 0 && color != null) {
            int xOffset = this.leftInset - this.borderSize;
            int yOffset = this.topInset - this.borderSize;
            g.setColor(color);
            for (int counter = 0; counter < this.borderSize; ++counter) {
                g.drawRect(rect.x + xOffset + counter, rect.y + yOffset + counter, rect.width - counter - counter - xOffset - xOffset - 1, rect.height - counter - counter - yOffset - yOffset - 1);
            }
        }
    }

    private void paintHighlights(Graphics g, Shape shape) {
        JTextComponent tc;
        Highlighter h;
        if (this.container instanceof JTextComponent && (h = (tc = (JTextComponent)this.container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)h).paintLayeredHighlights(g, this.getStartOffset(), this.getEndOffset(), shape, tc, this);
        }
    }

    private String processSrcPath(String src) {
        String imagePath;
        String pv;
        String val = src;
        File imageFile = new File(src);
        if (imageFile.isAbsolute()) {
            return src;
        }
        boolean found = false;
        Document doc = this.getDocument();
        if (doc != null && (pv = (String)doc.getProperty("docroot")) != null) {
            File f = new File(pv);
            val = new File(f.getParent(), imageFile.getPath()).toString();
            found = true;
        }
        if (!found && (imagePath = System.getProperty("system.image.path.key")) != null) {
            val = new File(imagePath, imageFile.getPath()).toString();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImage() {
        RelativeImageView relativeImageView = this;
        synchronized (relativeImageView) {
            this.state = (this.state | 1 | 0x20 | 4 | 8) ^ 0x2C;
            this.image = null;
            this.height = 0;
            this.width = 0;
        }
        try {
            this.loadImage();
            this.updateImageSize();
        }
        finally {
            relativeImageView = this;
            synchronized (relativeImageView) {
                this.state = (this.state | 1) ^ 1;
            }
        }
    }

    private void repaint(long delay) {
        if (this.container != null && this.fBounds != null) {
            this.container.repaint(delay, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    private void safePreferenceChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.preferenceChanged(null, true, true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RelativeImageView.this.preferenceChanged(null, true, true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        int s = this.state;
        if ((s & 0x20) != 0) {
            this.refreshImage();
        }
        if (((s = this.state) & 0x10) != 0) {
            RelativeImageView relativeImageView = this;
            synchronized (relativeImageView) {
                this.state = (this.state | 0x10) ^ 0x10;
            }
            this.setPropertiesFromAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAltTextView() {
        String text = this.getAltText();
        if (text != null) {
            ImageLabelView newView = new ImageLabelView(this.getElement(), text);
            RelativeImageView relativeImageView = this;
            synchronized (relativeImageView) {
                this.altView = newView;
            }
        }
    }

    private void updateBorderForNoImage() {
        if (this.borderSize == 0) {
            this.borderSize = 1;
            this.leftInset = (short)(this.leftInset + this.borderSize);
            this.rightInset = (short)(this.rightInset + this.borderSize);
            this.bottomInset = (short)(this.bottomInset + this.borderSize);
            this.topInset = (short)(this.topInset + this.borderSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImageSize() {
        int newState = 0;
        Image newImage = this.getImage();
        if (newImage != null) {
            int newHeight;
            this.getElement();
            int newWidth = this.getIntAttr(HTML.Attribute.WIDTH, -1);
            if (newWidth > 0) {
                newState |= 4;
            }
            if ((newHeight = this.getIntAttr(HTML.Attribute.HEIGHT, -1)) > 0) {
                newState |= 8;
            }
            if (newWidth <= 0 && (newWidth = newImage.getWidth(this.imageObserver)) <= 0) {
                newWidth = 38;
            }
            if (newHeight <= 0 && (newHeight = newImage.getHeight(this.imageObserver)) <= 0) {
                newHeight = 38;
            }
            if ((newState & 0xC) != 0) {
                Toolkit.getDefaultToolkit().prepareImage(newImage, newWidth, newHeight, this.imageObserver);
            } else {
                Toolkit.getDefaultToolkit().prepareImage(newImage, -1, -1, this.imageObserver);
            }
            boolean createText = false;
            RelativeImageView relativeImageView = this;
            synchronized (relativeImageView) {
                if (this.image != null) {
                    if ((newState & 4) == 4 || this.width == 0) {
                        this.width = newWidth;
                    }
                    if ((newState & 8) == 8 || this.height == 0) {
                        this.height = newHeight;
                    }
                } else {
                    createText = true;
                    if ((newState & 4) == 4) {
                        this.width = newWidth;
                    }
                    if ((newState & 8) == 8) {
                        this.height = newHeight;
                    }
                }
                this.state |= newState;
                this.state = (this.state | 1) ^ 1;
            }
            if (createText) {
                this.updateAltTextView();
            }
        } else {
            this.height = 38;
            this.width = 38;
            this.updateBorderForNoImage();
            this.updateAltTextView();
        }
    }

    private void waitForImage() throws InterruptedException {
        Thread.sleep(10L);
        int w = this.image.getWidth(this);
        int h = this.image.getHeight(this);
        while (true) {
            int flags;
            if (((flags = Toolkit.getDefaultToolkit().checkImage(this.image, w, h, this)) & 0x40) != 0 || (flags & 0x80) != 0) {
                throw new InterruptedException();
            }
            if ((flags & 0x30) != 0) {
                return;
            }
            Thread.sleep(10L);
        }
    }

    private static class ImageLabelView
    extends InlineView {
        private Color fg;
        private Segment segment;

        ImageLabelView(Element e, String text) {
            super(e);
            this.reset(text);
        }

        @Override
        public int getEndOffset() {
            return this.segment.array.length;
        }

        @Override
        public Color getForeground() {
            View parent;
            if (this.fg == null && (parent = this.getParent()) != null) {
                Document doc = this.getDocument();
                AttributeSet anAttr = parent.getAttributes();
                if (anAttr != null && doc instanceof StyledDocument) {
                    this.fg = ((StyledDocument)doc).getForeground(anAttr);
                }
            }
            return this.fg;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public Segment getText(int p0, int p1) {
            if (p0 < 0 || p1 > this.segment.array.length) {
                throw new RuntimeException("ImageLabelView: Stale view");
            }
            this.segment.offset = p0;
            this.segment.count = p1 - p0;
            return this.segment;
        }

        @Override
        public View breakView(int axis, int p0, float pos, float len) {
            return this;
        }

        @Override
        public void paint(Graphics g, Shape a) {
            GlyphView.GlyphPainter painter = this.getGlyphPainter();
            if (painter != null) {
                g.setColor(this.getForeground());
                painter.paint(this, g, a, this.getStartOffset(), this.getEndOffset());
            }
        }

        public void reset(String text) {
            this.segment = new Segment(text.toCharArray(), 0, text.length());
        }
    }

    private class ImageHandler
    implements ImageObserver {
        private ImageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
            if (RelativeImageView.this.image == null || RelativeImageView.this.image != img) {
                return false;
            }
            if ((flags & 0xC0) != 0) {
                RelativeImageView.this.repaint(0L);
                RelativeImageView relativeImageView = RelativeImageView.this;
                synchronized (relativeImageView) {
                    if (RelativeImageView.this.image == img) {
                        RelativeImageView.this.image = null;
                        if ((RelativeImageView.this.state & 4) != 4) {
                            RelativeImageView.this.width = 38;
                        }
                        if ((RelativeImageView.this.state & 8) != 8) {
                            RelativeImageView.this.height = 38;
                        }
                        RelativeImageView.this.updateBorderForNoImage();
                    }
                    if ((RelativeImageView.this.state & 1) == 1) {
                        return false;
                    }
                }
                RelativeImageView.this.updateAltTextView();
                RelativeImageView.this.safePreferenceChanged();
                return false;
            }
            short changed = 0;
            if ((flags & 2) != 0 && !RelativeImageView.this.getElement().getAttributes().isDefined(HTML.Attribute.HEIGHT)) {
                changed = (short)(changed | 1);
            }
            if ((flags & 1) != 0 && !RelativeImageView.this.getElement().getAttributes().isDefined(HTML.Attribute.WIDTH)) {
                changed = (short)(changed | 2);
            }
            RelativeImageView relativeImageView = RelativeImageView.this;
            synchronized (relativeImageView) {
                if (RelativeImageView.this.image != img) {
                    return false;
                }
                if ((changed & 1) == 1 && (RelativeImageView.this.state & 4) == 0) {
                    RelativeImageView.this.width = newWidth;
                }
                if ((changed & 2) == 2 && (RelativeImageView.this.state & 8) == 0) {
                    RelativeImageView.this.height = newHeight;
                }
                if ((RelativeImageView.this.state & 1) == 1) {
                    return true;
                }
            }
            if (changed != 0) {
                Document doc = RelativeImageView.this.getDocument();
                try {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readLock();
                    }
                    RelativeImageView.this.safePreferenceChanged();
                }
                finally {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readUnlock();
                    }
                }
                return true;
            }
            if ((flags & 0x30) != 0) {
                RelativeImageView.this.repaint(0L);
            }
            return (flags & 0x20) == 0;
        }
    }
}

