/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;

public class SimpleChoiceSet<T>
implements PrimitiveChoiceSet<T> {
    private final Comparator<? super T> comparator;
    private final Set<T> set;
    private final String separator;

    public SimpleChoiceSet(Collection<? extends T> col) {
        this(col, null, null);
    }

    public SimpleChoiceSet(Collection<? extends T> col, String separator) {
        this(col, null, separator);
    }

    public SimpleChoiceSet(Collection<? extends T> col, Comparator<? super T> comp) {
        this(col, comp, null);
    }

    public SimpleChoiceSet(Collection<? extends T> col, Comparator<? super T> comp, String sep) {
        if (col == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (col.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new LinkedHashSet<T>(col);
        if (this.set.size() != col.size()) {
            throw new IllegalArgumentException("Choice Collection cannot possess a duplicate item");
        }
        this.comparator = comp;
        this.separator = sep == null ? "," : sep;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        Set<T> sortingSet;
        try {
            sortingSet = new TreeSet<T>(this.comparator);
            sortingSet.addAll(this.set);
        }
        catch (ClassCastException cce) {
            sortingSet = this.set;
        }
        return StringUtil.join(sortingSet, (String)this.separator);
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.set == null ? null : this.set.iterator().next().getClass();
    }

    @Override
    public Set<T> getSet(PlayerCharacter pc) {
        return new HashSet<T>(this.set);
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleChoiceSet) {
            SimpleChoiceSet other = (SimpleChoiceSet)obj;
            return this.set.equals(other.set);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }
}

