/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Reducible;
import pcgen.cdom.content.Selection;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.SettingsHandler;
import pcgen.rules.context.LoadContext;

public class AbilitySelection
extends Selection<Ability, String>
implements Comparable<AbilitySelection>,
Reducible {
    public AbilitySelection(Ability obj, String sel) {
        super(obj, sel);
    }

    public static AbilitySelection getAbilitySelectionFromPersistentFormat(LoadContext context, String persistentFormat) {
        if (persistentFormat.indexOf("|") < 0) {
            return AbilitySelection.decodeFeatSelectionChoice(context, persistentFormat);
        }
        StringTokenizer st = new StringTokenizer(persistentFormat, "|");
        String catString = st.nextToken();
        if (!catString.startsWith("CATEGORY=")) {
            throw new IllegalArgumentException("String in getAbilitySelectionFromPersistentFormat must start with CATEGORY=, found: " + persistentFormat);
        }
        String cat = catString.substring(9);
        AbilityCategory ac = SettingsHandler.getGame().getAbilityCategory(cat);
        if (ac == null) {
            throw new IllegalArgumentException("Category in getAbilitySelectionFromPersistentFormat must exist found: " + cat);
        }
        String ab = st.nextToken();
        Ability a = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, ac, ab);
        if (a == null) {
            throw new IllegalArgumentException("Second argument in String in getAbilitySelectionFromPersistentFormat must be an Ability, but it was not found: " + persistentFormat);
        }
        String sel = null;
        if (st.hasMoreTokens()) {
            sel = st.nextToken();
        } else if (persistentFormat.endsWith("|")) {
            sel = "";
        }
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException("String in getAbilitySelectionFromPersistentFormat must have 2 or 3 arguments, but found more: " + persistentFormat);
        }
        return new AbilitySelection(a, sel);
    }

    private static AbilitySelection decodeFeatSelectionChoice(LoadContext context, String persistentFormat) {
        Ability ability = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, persistentFormat);
        if (ability == null) {
            ArrayList<String> choices = new ArrayList<String>();
            String baseKey = AbilityUtilities.getUndecoratedName(persistentFormat, choices);
            ability = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, baseKey);
            if (ability == null) {
                throw new IllegalArgumentException("String in decodeChoice must be a Feat Key (or Feat Key with Selection if appropriate), was: " + persistentFormat);
            }
            return new AbilitySelection(ability, (String)choices.get(0));
        }
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            return new AbilitySelection(ability, "");
        }
        return new AbilitySelection(ability, null);
    }

    public String getPersistentFormat() {
        Ability ability = (Ability)this.getObject();
        StringBuilder sb = new StringBuilder();
        sb.append("CATEGORY=");
        sb.append(ability.getCDOMCategory().getKeyName());
        sb.append('|');
        sb.append(ability.getKeyName());
        String selection = (String)this.getSelection();
        if (selection != null) {
            sb.append('|');
            sb.append(selection);
        }
        return sb.toString();
    }

    public String getAbilityKey() {
        return ((Ability)this.getObject()).getKeyName();
    }

    public boolean containsAssociation(String a) {
        String assoc = (String)this.getSelection();
        return a == assoc || a != null && a.equalsIgnoreCase(assoc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getAbilityKey());
        String selection = (String)this.getSelection();
        if (selection != null && selection.length() > 0) {
            sb.append(" (");
            sb.append(selection);
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(AbilitySelection o) {
        String oselection;
        int acompare = ((Ability)this.getObject()).compareTo(o.getObject());
        if (acompare != 0) {
            return acompare;
        }
        String selection = (String)this.getSelection();
        if (selection == (oselection = (String)o.getSelection())) {
            return 0;
        }
        if (selection == null) {
            return -1;
        }
        return selection.compareTo(oselection);
    }

    @Override
    public CDOMObject getCDOMObject() {
        return this.getObject();
    }
}

