/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.fact;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.ContentDefinition;
import pcgen.cdom.content.fact.FactDefinitionEnforcer;
import pcgen.cdom.content.fact.FactGroupDefinition;
import pcgen.cdom.content.fact.FactInfo;
import pcgen.cdom.content.fact.FactParser;
import pcgen.cdom.enumeration.FactKey;
import pcgen.output.actor.FactKeyActor;
import pcgen.output.wrapper.CDOMObjectWrapper;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class FactDefinition<T extends CDOMObject, F>
extends ContentDefinition<T, F>
implements FactInfo<T, F> {
    private String factName;

    @Override
    protected void activateKey() {
        this.getFactKey();
    }

    @Override
    protected void activateOutput() {
        FactKeyActor<F> fca = new FactKeyActor<F>(this.getFactKey());
        CDOMObjectWrapper cow = CDOMObjectWrapper.getInstance();
        if (!cow.load(this.getUsableLocation(), this.factName.toLowerCase(), fca)) {
            Logging.errorPrint(this.getUsableLocation().getSimpleName() + " output " + this.factName.toLowerCase() + " already exists, ignoring Visibility to EXPORT for FACT: " + this.factName);
        }
    }

    @Override
    protected void activateTokens(LoadContext context) {
        Boolean selectable;
        context.loadLocalToken(new FactParser(this));
        Boolean required = this.getRequired();
        if (required != null && required.booleanValue()) {
            context.loadLocalToken(new FactDefinitionEnforcer(this));
        }
        if ((selectable = this.getSelectable()) != null && selectable.booleanValue()) {
            context.loadLocalToken(new FactGroupDefinition(this));
        }
    }

    public void setFactName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Fact Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Fact Name cannot be empty");
        }
        this.factName = name;
    }

    @Override
    public String getFactName() {
        return this.factName;
    }

    @Override
    public FactKey<F> getFactKey() {
        return FactKey.getConstant(this.getFactName(), this.getFormatManager());
    }
}

