/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Collection;
import java.util.Collections;
import pcgen.base.enumeration.TypeSafeConstant;
import pcgen.base.util.CaseInsensitiveMap;

public final class Type
implements TypeSafeConstant,
Comparable<Type> {
    private static CaseInsensitiveMap<Type> typeMap = new CaseInsensitiveMap();
    public static final Type NATURAL = Type.getConstant("Natural");
    public static final Type CUSTOM = Type.getConstant("Custom");
    public static final Type NONE = Type.getConstant("None");
    public static final Type HUMANOID = Type.getConstant("Humanoid");
    public static final Type WEAPON = Type.getConstant("Weapon");
    public static final Type MELEE = Type.getConstant("Melee");
    public static final Type SIMPLE = Type.getConstant("Simple");
    public static final Type UNARMED = Type.getConstant("Unarmed");
    public static final Type SUBDUAL = Type.getConstant("Subdual");
    public static final Type STANDARD = Type.getConstant("Standard");
    public static final Type MONK = Type.getConstant("Monk");
    public static final Type BLUDGEONING = Type.getConstant("Bludgeoning");
    public static final Type AUTO_GEN = Type.getConstant("AUTO_GEN");
    public static final Type BOTH = Type.getConstant("Both");
    public static final Type THROWN = Type.getConstant("Thrown");
    public static final Type RANGED = Type.getConstant("Ranged");
    public static final Type DOUBLE = Type.getConstant("Double");
    public static final Type HEAD1 = Type.getConstant("Head1");
    public static final Type HEAD2 = Type.getConstant("Head2");
    public static final Type TEMPORARY = Type.getConstant("TEMPORARY");
    public static final Type DIVINE = Type.getConstant("Divine");
    public static final Type POTION = Type.getConstant("Potion");
    public static final Type RING = Type.getConstant("Ring");
    public static final Type SCROLL = Type.getConstant("Scroll");
    public static final Type WAND = Type.getConstant("Wand");
    public static final Type MONSTER = Type.getConstant("Monster");
    public static final Type SHIELD = Type.getConstant("Shield");
    public static final Type ARMOR = Type.getConstant("Armor");
    private static int ordinalCount = 0;
    private final String fieldName;
    private final transient int ordinal;

    private Type(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name for Type cannot be null");
        }
        this.ordinal = ordinalCount++;
        this.fieldName = name;
    }

    public String toString() {
        return this.fieldName;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public String getComparisonString() {
        return this.fieldName.toUpperCase();
    }

    public static Type getConstant(String name) {
        Type type = (Type)typeMap.get((Object)name);
        if (type == null) {
            type = new Type(name);
            typeMap.put((Object)name, (Object)type);
        }
        return type;
    }

    public static Type valueOf(String name) {
        Type type = (Type)typeMap.get((Object)name);
        if (type == null) {
            throw new IllegalArgumentException(name + " is not a previously defined Type");
        }
        return type;
    }

    public static Collection<Type> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    public static void clearConstants() {
        typeMap.clear();
    }

    @Override
    public int compareTo(Type type) {
        return this.fieldName.compareTo(type.fieldName);
    }
}

