/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.base.AbstractQualifiedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.core.WeaponProf;

public class AutoWeaponProfFacet
extends AbstractQualifiedListFacet<WeaponProfProvider>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectConsolidationFacet consolidationFacet;
    private PrerequisiteFacet prereqFacet = FacetLibrary.getFacet(PrerequisiteFacet.class);

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<WeaponProfProvider> weaponProfs = cdo.getListFor(ListKey.WEAPONPROF);
        if (weaponProfs != null) {
            this.addAll(dfce.getCharID(), weaponProfs, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public Collection<WeaponProf> getWeaponProfs(CharID id) {
        ArrayList<WeaponProf> profs = new ArrayList<WeaponProf>();
        for (WeaponProfProvider wpp : this.getQualifiedSet(id)) {
            profs.addAll(wpp.getContainedProficiencies(id));
        }
        return profs;
    }

    public boolean containsProf(CharID id, WeaponProf wp) {
        for (WeaponProfProvider wpp : this.getSet(id)) {
            if (!wpp.getContainedProficiencies(id).contains(wp) || !this.prereqFacet.qualifies(id, wpp, wpp)) continue;
            return true;
        }
        return false;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

