/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.ConditionalAbilityFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.util.Logging;

public class ConditionallyGrantedAbilityFacet
extends AbstractListFacet<CharID, CNAbilitySelection> {
    private ConditionalAbilityFacet conditionalAbilityFacet;
    private static int depth = 0;

    public void update(CharID id) {
        ++depth;
        Collection current = this.getSet(id);
        Collection<CNAbilitySelection> qualified = this.conditionalAbilityFacet.getQualifiedSet(id);
        ArrayList toRemove = new ArrayList(current);
        toRemove.removeAll(qualified);
        ArrayList<CNAbilitySelection> toAdd = new ArrayList<CNAbilitySelection>(qualified);
        toAdd.removeAll(current);
        if (!(toAdd.isEmpty() && toRemove.isEmpty() || !Logging.isDebugMode())) {
            Logging.debugPrint("CGAF at depth " + depth + " removing " + toRemove + " adding " + toAdd);
        }
        for (CNAbilitySelection cas : toRemove) {
            if (this.conditionalAbilityFacet.isQualified(id, cas) || !this.contains(id, cas)) continue;
            if (Logging.isDebugMode()) {
                Logging.debugPrint("CGAF at depth " + depth + " removing " + cas);
            }
            this.remove(id, cas);
        }
        for (CNAbilitySelection cas : toAdd) {
            if (!this.conditionalAbilityFacet.isQualified(id, cas) || this.contains(id, cas)) continue;
            if (Logging.isDebugMode()) {
                Logging.debugPrint("CGAF at depth " + depth + " adding " + cas);
            }
            this.add(id, cas);
        }
        if (!(toAdd.isEmpty() && toRemove.isEmpty() || !Logging.isDebugMode())) {
            Logging.debugPrint("CGAF at depth " + depth + " completed.");
        }
        --depth;
    }

    @Override
    protected Set<CNAbilitySelection> getComponentSet() {
        return new WrappedMapSet(IdentityHashMap.class);
    }

    public void setConditionalAbilityFacet(ConditionalAbilityFacet conditionalAbilityFacet) {
        this.conditionalAbilityFacet = conditionalAbilityFacet;
    }
}

