/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.input;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.TemplateSelectionFacet;
import pcgen.cdom.facet.UnconditionalTemplateFacet;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;

public class TemplateInputFacet {
    private TemplateSelectionFacet templateSelectionFacet;
    private UnconditionalTemplateFacet unconditionalTemplateFacet;
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);

    public boolean add(CharID id, PCTemplate obj) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (pc.isAllowInteraction() && ChooseActivation.hasNewChooseToken(obj)) {
            ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(obj, pc);
            return this.processChoice(id, pc, obj, aMan);
        }
        this.directAdd(id, obj, null);
        return true;
    }

    private <T> boolean processChoice(CharID id, PlayerCharacter pc, PCTemplate obj, ChoiceManagerList<T> aMan) {
        List<T> newSelections;
        ArrayList selectedList = new ArrayList();
        ArrayList availableList = new ArrayList();
        aMan.getChoices(pc, availableList, selectedList);
        if (availableList.isEmpty()) {
            return false;
        }
        if (!selectedList.isEmpty()) {
            // empty if block
        }
        if ((newSelections = aMan.doChooser(pc, availableList, selectedList, new ArrayList<String>())).size() != 1) {
            return false;
        }
        for (T sel : newSelections) {
            this.directAdd(id, obj, sel);
        }
        return true;
    }

    public void importSelection(CharID id, PCTemplate obj, String choice) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (ChooseActivation.hasNewChooseToken(obj)) {
            ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(obj, pc);
            this.processImport(id, obj, aMan, choice);
        } else {
            this.directAdd(id, obj, null);
        }
    }

    private <T> void processImport(CharID id, PCTemplate obj, ChoiceManagerList<T> aMan, String choice) {
        this.directAdd(id, obj, aMan.decodeChoice(choice));
    }

    public <T> void directAdd(CharID id, PCTemplate obj, T sel) {
        this.unconditionalTemplateFacet.add(id, obj);
        if (sel != null) {
            this.templateSelectionFacet.set(id, obj, sel);
        }
    }

    public void remove(CharID id, PCTemplate obj) {
        this.unconditionalTemplateFacet.remove(id, obj);
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (pc.isAllowInteraction()) {
            this.templateSelectionFacet.remove(id, obj);
        }
    }

    public void setTemplateSelectionFacet(TemplateSelectionFacet templateSelectionFacet) {
        this.templateSelectionFacet = templateSelectionFacet;
    }

    public void setUnconditionalTemplateFacet(UnconditionalTemplateFacet unconditionalTemplateFacet) {
        this.unconditionalTemplateFacet = unconditionalTemplateFacet;
    }
}

