/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.base.Reducible;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;

public class CNAbilitySelection
extends ConcretePrereqObject
implements QualifyingObject,
Reducible {
    private final CNAbility cna;
    private final String selection;

    public CNAbilitySelection(CNAbility cna) {
        this(cna, null);
    }

    public CNAbilitySelection(CNAbility cna, String choice) {
        Ability abil = cna.getAbility();
        if (choice != null && !abil.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            throw new IllegalArgumentException("AbilitySelection " + choice + " with MULT:NO Ability " + abil + " must not have choices");
        }
        if (choice == null && abil.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            throw new IllegalArgumentException("AbilitySelection with MULT:YES Ability " + abil + ": must have choices");
        }
        this.cna = cna;
        this.selection = choice;
    }

    public CNAbility getCNAbility() {
        return this.cna;
    }

    public String getSelection() {
        return this.selection;
    }

    public String getAbilityKey() {
        return this.cna.getAbilityKey();
    }

    public boolean containsAssociation(String assoc) {
        return assoc == null ? this.selection == null : assoc.equals(this.selection);
    }

    public String getPersistentFormat() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("CATEGORY=");
        sb.append(this.cna.getAbilityCategory().getKeyName());
        sb.append('|');
        sb.append("NATURE=");
        sb.append((Object)this.cna.getNature());
        sb.append('|');
        sb.append(this.cna.getAbilityKey());
        if (this.selection != null) {
            sb.append('|');
            sb.append(this.selection);
        }
        return sb.toString();
    }

    public static CNAbilitySelection getAbilitySelectionFromPersistentFormat(String persistentFormat) {
        StringTokenizer st = new StringTokenizer(persistentFormat, "|");
        String catString = st.nextToken();
        if (!catString.startsWith("CATEGORY=")) {
            throw new IllegalArgumentException("String in getAbilitySelectionFromPersistentFormat must start with CATEGORY=, found: " + persistentFormat);
        }
        String cat = catString.substring(9);
        AbilityCategory ac = SettingsHandler.getGame().getAbilityCategory(cat);
        if (ac == null) {
            throw new IllegalArgumentException("Category in getAbilitySelectionFromPersistentFormat must exist found: " + cat);
        }
        String natureString = st.nextToken();
        if (!natureString.startsWith("NATURE=")) {
            throw new IllegalArgumentException("Second argument in String in getAbilitySelectionFromPersistentFormat must start with NATURE=, found: " + persistentFormat);
        }
        String natString = natureString.substring(7);
        Nature nat = Nature.valueOf(natString);
        String ab = st.nextToken();
        Ability a = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, ac, ab);
        if (a == null) {
            throw new IllegalArgumentException("Third argument in String in getAbilitySelectionFromPersistentFormat must be an Ability, but it was not found: " + persistentFormat);
        }
        String sel = null;
        if (st.hasMoreTokens()) {
            sel = st.nextToken();
        } else if (persistentFormat.endsWith("|")) {
            sel = "";
        }
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException("String in getAbilitySelectionFromPersistentFormat must have 3 or 4 arguments, but found more: " + persistentFormat);
        }
        CNAbility cna = CNAbilityFactory.getCNAbility(ac, nat, a);
        return new CNAbilitySelection(cna, sel);
    }

    public String getFullAbilityKey() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.cna.getAbilityKey());
        if (this.selection != null && this.selection.length() > 0) {
            sb.append('(');
            sb.append(this.selection);
            sb.append(')');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.cna.getAbility().getDisplayName());
        if (this.selection != null && this.selection.length() > 0) {
            sb.append('(');
            sb.append(this.selection);
            sb.append(')');
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.cna.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CNAbilitySelection) {
            CNAbilitySelection other = (CNAbilitySelection)o;
            if (this.selection == null ? other.selection != null : !this.selection.equals(other.selection)) {
                return false;
            }
            return this.cna.equals(other.cna);
        }
        return false;
    }

    @Override
    public CDOMObject getCDOMObject() {
        return this.cna.getCDOMObject();
    }
}

