/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.FixedStringList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.EqModFormatCat;
import pcgen.cdom.enumeration.EquipmentLocation;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.helper.Capacity;
import pcgen.cdom.inst.EqSizePenalty;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.processor.ChangeArmorType;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.ArmorProf;
import pcgen.core.AssociationSupport;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.SystemCollections;
import pcgen.core.VariableContainer;
import pcgen.core.VariableProcessorEq;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusActivation;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.EqModCost;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.analysis.EquipmentChoiceDriver;
import pcgen.core.analysis.SizeUtilities;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.character.EquipSlot;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.EquipmentFacade;
import pcgen.io.FileAccess;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.util.BigDecimalHelper;
import pcgen.util.JEPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.Visibility;

public final class Equipment
extends PObject
implements Serializable,
Comparable<Object>,
VariableContainer,
EquipmentFacade {
    private static final long serialVersionUID = 1L;
    private static final String EQMOD_WEIGHT = "_WEIGHTADD";
    private static final String EQMOD_DAMAGE = "_DAMAGE";
    private static final SortedSet<String> S_EQUIPMENT_TYPES = new TreeSet<String>();
    private AssociationSupport assocSupt = new AssociationSupport();
    private BigDecimal costMod = BigDecimal.ZERO;
    private Equipment d_parent;
    private List<Equipment> d_containedEquipment = new ArrayList<Equipment>();
    private Float carried = Float.valueOf(0.0f);
    private EquipmentLocation location = EquipmentLocation.NOT_CARRIED;
    private boolean equipped;
    private int numberEquipped;
    private Map<String, Float> d_childTypes = new HashMap<String, Float>();
    private String containerCapacityString = null;
    private String containerContentsString = "";
    private String appliedBonusName = "";
    private String indexedUnderType = "";
    private String wholeItemName = "";
    private String modifiedName = "";
    private String moveString = "";
    private String noteString = "";
    private boolean automatic;
    private boolean bonusPrimary = true;
    private boolean calculatingCost;
    private boolean weightAlreadyUsed;
    private double qty;
    private int outputIndex;
    private int outputSubindex;
    private List<String> typeListCachePrimary;
    private List<String> typeListCacheSecondary;
    private boolean usePrimaryCache;
    private boolean useSecondaryCache;
    private boolean dirty;
    private String cachedNameWithoutCharges;
    private String cachedNameWithCharges;
    private Map<String, String> bonusMap;
    private boolean virtualItem;
    List<EquipmentHead> heads;

    public Equipment() {
        SizeAdjustment sizeAdj = SizeUtilities.getDefaultSizeAdjustment();
        if (sizeAdj != null) {
            this.put(ObjectKey.SIZE, CDOMDirectSingleRef.getRef(sizeAdj));
        }
        this.heads = new ArrayList<EquipmentHead>();
    }

    public void setAppliedName(String aString) {
        this.appliedBonusName = aString;
    }

    public String getAppliedName() {
        if (this.appliedBonusName.length() > 0) {
            StringBuilder aString = new StringBuilder(100);
            aString.append(" [").append(this.appliedBonusName).append("]");
            return aString.toString();
        }
        return "";
    }

    public boolean isAmmunition() {
        return this.isType("AMMUNITION");
    }

    public boolean isArmor() {
        return this.isType("ARMOR");
    }

    public boolean isDouble() {
        return this.isType("DOUBLE");
    }

    public boolean isEitherType(String aType) {
        return this.isType(aType, true) || this.isType(aType, false);
    }

    public boolean isExtra() {
        return this.isType("EXTRA");
    }

    public boolean isHeavy() {
        return this.isType("HEAVY");
    }

    public boolean isMedium() {
        return this.isType("MEDIUM");
    }

    public boolean isLight() {
        return this.isType("LIGHT");
    }

    public boolean isMagic() {
        return this.isType("MAGIC");
    }

    public boolean isMelee() {
        return this.isType("MELEE");
    }

    public boolean isMonk() {
        return this.isType("MONK");
    }

    public boolean isNatural() {
        return this.isType("NATURAL");
    }

    public boolean isPrimaryNaturalWeapon() {
        return this.isNatural() && this.modifiedName().endsWith("Primary");
    }

    public boolean isRanged() {
        return this.isType("RANGED");
    }

    public boolean isShield() {
        return this.isType("SHIELD");
    }

    public boolean isSuit() {
        return this.isType("SUIT");
    }

    public boolean isThrown() {
        return this.isType("THROWN");
    }

    @Override
    public String getType() {
        return this.getType(true);
    }

    @Override
    public boolean isType(String aType) {
        return this.isType(aType, true);
    }

    public boolean isType(String aType, boolean bPrimary) {
        if (!bPrimary && !this.isDouble()) {
            return false;
        }
        List<String> tList = this.typeList(bPrimary);
        String myType = aType.startsWith("TYPE=") || aType.startsWith("TYPE.") ? aType.substring(5).toUpperCase() : aType.toUpperCase();
        StringTokenizer tok = new StringTokenizer(myType, ".");
        if (tok.hasMoreTokens()) {
            while (tok.hasMoreTokens()) {
                String type = tok.nextToken();
                boolean found = false;
                if (tList != null) {
                    for (String s : tList) {
                        if (!type.equalsIgnoreCase(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return tList.contains(aType);
    }

    public boolean isUnarmed() {
        return this.isType("UNARMED");
    }

    public boolean isWeapon() {
        return this.isType("WEAPON");
    }

    boolean isMasterwork() {
        return this.isType("MASTERWORK");
    }

    public boolean isSellAsCash() {
        return this.isType("Coin") || this.isType("Gem") || this.isType("Trade");
    }

    public boolean typeStringContains(String aString) {
        return this.isType(aString);
    }

    public boolean isProjectile() {
        return this.isRanged() && !this.isThrown();
    }

    @Override
    public List<BonusObj> getActiveBonuses(PlayerCharacter aPC) {
        ArrayList<BonusObj> aList = new ArrayList<BonusObj>();
        for (BonusObj bonus : this.getRawBonusList(aPC)) {
            if (!aPC.isApplied(bonus)) continue;
            aList.add(bonus);
        }
        List<EquipmentModifier> eqModList = this.getEqModifierList(true);
        for (EquipmentModifier eqMod : eqModList) {
            aList.addAll(eqMod.getActiveBonuses(this, aPC));
        }
        eqModList = this.getEqModifierList(false);
        for (EquipmentModifier eqMod : eqModList) {
            aList.addAll(eqMod.getActiveBonuses(this, aPC));
        }
        return aList;
    }

    public List<BonusObj> getBonusListOfType(PlayerCharacter pc, String aType, String aName, boolean bPrimary) {
        ArrayList<BonusObj> aList = new ArrayList<BonusObj>();
        aList.addAll(BonusUtilities.getBonusFromList(this.getBonusList(pc), aType, aName));
        for (EquipmentModifier eqMod : this.getEqModifierList(bPrimary)) {
            aList.addAll(BonusUtilities.getBonusFromList(eqMod.getBonusList(this), aType, aName));
        }
        return aList;
    }

    public String getFumbleRange() {
        String fr;
        for (EquipmentModifier eqMod : this.getEqModifierList(true)) {
            fr = eqMod.get(StringKey.FUMBLE_RANGE);
            if (fr == null) continue;
            return fr;
        }
        for (EquipmentModifier eqMod : this.getEqModifierList(false)) {
            fr = eqMod.get(StringKey.FUMBLE_RANGE);
            if (fr == null) continue;
            return fr;
        }
        String fr2 = this.get(StringKey.FUMBLE_RANGE);
        return fr2 == null ? "" : fr2;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean arg) {
        this.automatic = arg;
    }

    public String getBaseItemName() {
        CDOMSingleRef<Equipment> baseItem = this.get(ObjectKey.BASE_ITEM);
        if (baseItem == null) {
            return this.getKeyName();
        }
        return baseItem.resolvesTo().getDisplayName();
    }

    public String getBaseItemKeyName() {
        CDOMSingleRef<Equipment> baseItem = this.get(ObjectKey.BASE_ITEM);
        if (baseItem == null) {
            return this.getKeyName();
        }
        return baseItem.resolvesTo().getKeyName();
    }

    public BigDecimal getCost(PlayerCharacter aPC) {
        BigDecimal c = BigDecimal.ZERO;
        if (this.isVirtual()) {
            return c;
        }
        c = c.add(this.getPreSizingCostForHead(aPC, true));
        c = c.add(this.getPreSizingCostForHead(aPC, false));
        BigDecimal currentcost = this.get(ObjectKey.CURRENT_COST);
        if (currentcost == null) {
            currentcost = this.getSafe(ObjectKey.COST);
        }
        BigDecimal itemCost = currentcost.add(c);
        ArrayList<BigDecimal> modifierCosts = new ArrayList<BigDecimal>();
        this.calculatingCost = true;
        this.weightAlreadyUsed = false;
        EquipmentHeadCostSummary costSum = this.getPostSizingCostForHead(aPC, modifierCosts, true);
        BigDecimal nonDoubleCost = costSum.nonDoubleCost;
        BigDecimal c1 = costSum.postSizeCost;
        int iPlus = costSum.headPlus;
        if (modifierCosts.size() > 1) {
            Collections.sort(modifierCosts);
        }
        EquipmentHeadCostSummary altCostSum = this.getPostSizingCostForHead(aPC, new ArrayList<BigDecimal>(), false);
        nonDoubleCost = nonDoubleCost.add(altCostSum.nonDoubleCost);
        c1 = c1.add(altCostSum.postSizeCost);
        int altPlus = altCostSum.headPlus;
        this.calculatingCost = false;
        c1 = c1.add(this.getCostFromPluses(iPlus, altPlus));
        if (!(this.isAmmunition() || this.isArmor() || this.isShield() || this.isWeapon())) {
            if (!this.isMagicLimitedType()) {
                if (!this.ignoresCostDouble()) {
                    c1 = c1.subtract(nonDoubleCost).multiply(new BigDecimal("2"));
                    c1 = c1.add(nonDoubleCost);
                }
            } else {
                for (int i = modifierCosts.size() - 2; i >= 0; --i) {
                    c1 = c1.add((BigDecimal)modifierCosts.get(i));
                }
            }
        }
        if (c1.compareTo(BigDecimal.ZERO) >= 0 && c1.add(itemCost).add(this.costMod).compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return c1.add(itemCost).add(this.costMod);
    }

    private BigDecimal getPreSizingCostForHead(PlayerCharacter aPC, boolean primaryHead) {
        BigDecimal c = BigDecimal.ZERO;
        EquipmentHead head = this.getEquipmentHeadReference(primaryHead ? 1 : 2);
        if (head != null) {
            this.bonusPrimary = primaryHead;
            for (EquipmentModifier eqMod : head.getSafeListFor(ListKey.EQMOD)) {
                int iCount = this.getSelectCorrectedAssociationCount(eqMod);
                if (iCount < 1) {
                    iCount = 1;
                }
                Formula baseCost = eqMod.getSafe(FormulaKey.BASECOST);
                Number bc = baseCost.resolve(this, primaryHead, aPC, "");
                BigDecimal eqModCost = new BigDecimal(bc.toString());
                c = c.add(eqModCost.multiply(new BigDecimal(Integer.toString(this.getSafe(IntegerKey.BASE_QUANTITY) * iCount))));
                c = c.add(EqModCost.addItemCosts(eqMod, aPC, "ITEMCOST", this.getSafe(IntegerKey.BASE_QUANTITY) * iCount, this));
            }
        }
        return c;
    }

    private EquipmentHeadCostSummary getPostSizingCostForHead(PlayerCharacter aPC, List<BigDecimal> modifierCosts, boolean primaryHead) {
        EquipmentHeadCostSummary costSum = new EquipmentHeadCostSummary();
        EquipmentHead head = this.getEquipmentHeadReference(primaryHead ? 1 : 2);
        if (head != null) {
            for (EquipmentModifier eqMod : head.getSafeListFor(ListKey.EQMOD)) {
                BigDecimal eqModCost;
                int iCount = this.getSelectCorrectedAssociationCount(eqMod);
                if (iCount < 1) {
                    iCount = 1;
                }
                Formula cost = eqMod.getSafe(FormulaKey.COST);
                String costFormula = cost.toString();
                if (this.hasAssociations(eqMod) && !costFormula.equals(EqModCost.getCost(eqMod, this.getFirstAssociation(eqMod)))) {
                    eqModCost = BigDecimal.ZERO;
                    for (String assoc : this.getAssociationList(eqMod)) {
                        String v = this.calcEqModCost(aPC, EqModCost.getCost(eqMod, assoc), primaryHead);
                        BigDecimal thisModCost = new BigDecimal(v);
                        eqModCost = eqModCost.add(thisModCost);
                        if (!EqModCost.getCostDouble(eqMod)) {
                            costSum.nonDoubleCost = costSum.nonDoubleCost.add(thisModCost);
                            continue;
                        }
                        modifierCosts.add(thisModCost);
                    }
                    iCount = 1;
                } else {
                    String v = this.calcEqModCost(aPC, cost.toString(), primaryHead);
                    eqModCost = new BigDecimal(v);
                    if (!EqModCost.getCostDouble(eqMod)) {
                        costSum.nonDoubleCost = costSum.nonDoubleCost.add(eqModCost);
                    } else {
                        modifierCosts.add(eqModCost);
                    }
                }
                if (eqMod.isType("BaseMaterial")) {
                    eqModCost = eqModCost.multiply(new BigDecimal(this.getSafe(IntegerKey.BASE_QUANTITY)));
                }
                costSum.postSizeCost = costSum.postSizeCost.add(eqModCost);
                costSum.headPlus += eqMod.getSafe(IntegerKey.PLUS) * iCount;
            }
        }
        return costSum;
    }

    private String calcEqModCost(PlayerCharacter aPC, String costFormula, boolean primaryHead) {
        Pattern pat = Pattern.compile("BASECOST");
        Matcher mat = pat.matcher(costFormula);
        StringBuilder sB = new StringBuilder("(BASECOST/");
        sB.append(this.getSafe(IntegerKey.BASE_QUANTITY));
        sB.append(")");
        String s = mat.replaceAll(sB.toString());
        String v = this.getVariableValue(s, "", primaryHead, aPC).toString();
        return v;
    }

    public void setCostMod(String aString) {
        try {
            this.costMod = new BigDecimal(aString);
        }
        catch (NumberFormatException e) {
            this.costMod = BigDecimal.ZERO;
        }
    }

    public void setCostMod(BigDecimal aCost) {
        this.costMod = aCost;
    }

    public BigDecimal getCostMod() {
        return this.costMod;
    }

    public EquipmentModifier getEqModifierKeyed(Object eqModKey, boolean bPrimary) {
        List<EquipmentModifier> eqModList = this.getEqModifierList(bPrimary);
        for (EquipmentModifier eqMod : eqModList) {
            if (!eqMod.getKeyName().equals(eqModKey)) continue;
            return eqMod;
        }
        return null;
    }

    public List<EquipmentModifier> getEqModifierList(boolean bPrimary) {
        return this.getEquipmentHead(bPrimary ? 1 : 2).getSafeListFor(ListKey.EQMOD);
    }

    public void addToEqModifierList(EquipmentModifier eqMod, boolean bPrimary) {
        this.usePrimaryCache = false;
        this.getEquipmentHead(bPrimary ? 1 : 2).addToListFor(ListKey.EQMOD, eqMod);
        this.setDirty(true);
    }

    public int getHands(PlayerCharacter aPC) {
        return this.getSlots(aPC);
    }

    public String getInterestingDisplayString(PlayerCharacter aPC) {
        StringBuilder s = new StringBuilder(100);
        String t = this.getSpecialProperties(aPC);
        if (t == null) {
            t = "";
        }
        for (BonusObj aBonus : this.getActiveBonuses(aPC)) {
            String eqBonus = aBonus.toString();
            if (eqBonus.length() <= 0 || eqBonus.startsWith("EQM")) continue;
            if (s.length() != 0) {
                s.append(", ");
            }
            s.append(eqBonus);
        }
        if (t.length() != 0) {
            if (s.length() != 0) {
                s.append('|');
            }
            s.append(t);
        }
        return s.toString();
    }

    public void setIsEquipped(boolean aFlag, PlayerCharacter aPC) {
        this.equipped = aFlag;
        if (this.equipped) {
            this.activateBonuses(aPC);
        } else {
            BonusActivation.deactivateBonuses(this, aPC);
        }
    }

    public String getItemNameFromModifiers() {
        return this.getItemNameFromModifiers(this.getBaseItemName());
    }

    public String getItemNameFromModifiers(String baseName) {
        int idx1;
        int idx;
        CDOMSingleRef<Equipment> baseItem = this.get(ObjectKey.BASE_ITEM);
        if (baseItem == null) {
            return this.getName();
        }
        EquipmentHead head = this.getEquipmentHeadReference(1);
        List<Object> modList = head == null ? Collections.emptyList() : head.getSafeListFor(ListKey.EQMOD);
        EquipmentHead althead = this.getEquipmentHeadReference(2);
        List<Object> altModList = althead == null ? Collections.emptyList() : althead.getSafeListFor(ListKey.EQMOD);
        ArrayList<EquipmentModifier> commonList = new ArrayList<EquipmentModifier>();
        List<List<EquipmentModifier>> modListByFC = this.initSplitModList();
        List<List<EquipmentModifier>> altModListByFC = this.initSplitModList();
        List<List<EquipmentModifier>> commonListByFC = this.initSplitModList();
        Equipment baseEquipment = baseItem.resolvesTo();
        if (baseEquipment != null) {
            modList.removeAll(baseEquipment.getEqModifierList(true));
            altModList.removeAll(baseEquipment.getEqModifierList(false));
        }
        Iterator<Object> it = modList.iterator();
        while (it.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)it.next();
            if (!eqMod.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.HIDDEN)) continue;
            it.remove();
        }
        Equipment.extractListFromCommon(commonList, modList);
        this.removeCommonFromList(altModList, commonList, "eqMod expected but not found: ");
        this.suppressMasterwork(commonList);
        this.splitModListByFormatCat(commonList, commonListByFC);
        this.splitModListByFormatCat(modList, modListByFC);
        this.splitModListByFormatCat(altModList, altModListByFC);
        StringBuilder itemName = new StringBuilder(100);
        int fcf = EqModFormatCat.FRONT.ordinal();
        itemName.append(this.buildEqModDesc(commonListByFC.get(fcf), modListByFC.get(fcf), altModListByFC.get(fcf)));
        if (itemName.length() > 0) {
            itemName.append(' ');
        }
        if ((idx = (baseName = baseName.trim()).indexOf(40)) >= 0) {
            itemName.append(baseName.substring(0, idx - 1).trim());
        } else {
            itemName.append(baseName);
        }
        int fcm = EqModFormatCat.MIDDLE.ordinal();
        String eqmodDesc1 = this.buildEqModDesc(commonListByFC.get(fcm), modListByFC.get(fcm), altModListByFC.get(fcm));
        if (eqmodDesc1.length() > 0) {
            itemName.append(' ').append(eqmodDesc1);
        }
        if (idx >= 0) {
            itemName.append(' ');
            itemName.append(baseName.substring(idx));
        }
        if ((idx1 = itemName.toString().lastIndexOf(41)) >= 0) {
            itemName.setLength(idx1);
            itemName.append('/');
        } else {
            itemName.append(" (");
        }
        SizeAdjustment thisSize = this.getSafe(ObjectKey.SIZE).resolvesTo();
        if (!this.getSafe(ObjectKey.BASESIZE).resolvesTo().equals(thisSize)) {
            itemName.append(thisSize.getDisplayName());
            itemName.append('/');
        }
        int fcp = EqModFormatCat.PARENS.ordinal();
        itemName.append(this.buildEqModDesc(commonListByFC.get(fcp), modListByFC.get(fcp), altModListByFC.get(fcp)));
        if (itemName.toString().endsWith("/") || itemName.toString().endsWith(";")) {
            itemName.setLength(itemName.length() - 1);
        }
        itemName.append(')');
        int idx2 = itemName.toString().indexOf(" ()");
        if (idx2 >= 0) {
            itemName.setLength(idx2);
        }
        return itemName.toString();
    }

    private void suppressMasterwork(Collection<EquipmentModifier> commonList) {
        EquipmentModifier eqMaster = null;
        for (EquipmentModifier eqMod : commonList) {
            if (!"MASTERWORK".equalsIgnoreCase(eqMod.getDisplayName()) && !eqMod.isIType("Masterwork")) continue;
            eqMaster = eqMod;
            break;
        }
        if (eqMaster == null) {
            return;
        }
        for (EquipmentHead head : this.heads) {
            if (Equipment.getMagicBonus(head.getListFor(ListKey.EQMOD)) == null) continue;
            commonList.remove(eqMaster);
            break;
        }
    }

    private String buildEqModDesc(List<EquipmentModifier> commonList, List<EquipmentModifier> modList, List<EquipmentModifier> altModList) {
        StringBuilder desc = new StringBuilder(250);
        String commonDesc = this.getNameFromModifiers(commonList);
        String modDesc = this.getNameFromModifiers(modList);
        String altModDesc = this.getNameFromModifiers(altModList);
        if (modList.isEmpty() && altModList.isEmpty()) {
            desc.append(commonDesc);
        } else if (!this.isDouble()) {
            desc.append(modDesc);
            if (!modList.isEmpty() && !commonList.isEmpty()) {
                desc.append('/');
            }
            desc.append(commonDesc);
        } else {
            if (commonDesc.length() != 0) {
                desc.append(commonDesc).append(';');
            }
            if (modDesc.length() != 0) {
                desc.append(modDesc);
            } else {
                desc.append('-');
            }
            desc.append(';');
            if (altModDesc.length() != 0) {
                desc.append(altModDesc);
            } else {
                desc.append('-');
            }
        }
        return desc.toString();
    }

    public void setLocation(EquipmentLocation newLocation) {
        this.location = EquipmentLocation.CONTAINED.equals((Object)newLocation) ? EquipmentLocation.CARRIED_NEITHER : newLocation;
        this.equipped = this.location.isEquipped();
    }

    public EquipmentLocation getLocation() {
        return this.location;
    }

    public int getMaxCharges() {
        for (EquipmentModifier eqMod : this.getEqModifierList(true)) {
            Integer max = eqMod.get(IntegerKey.MAX_CHARGES);
            if (max == null || max <= 0) continue;
            return max;
        }
        return 0;
    }

    public Integer getMaxDex(PlayerCharacter aPC) {
        Integer mdex = this.getSafe(IntegerKey.MAX_DEX);
        if ((mdex = Integer.valueOf(mdex + (int)this.bonusTo(aPC, "EQMARMOR", "MAXDEX", true))) > 100) {
            mdex = 100;
        }
        if (mdex < 0) {
            mdex = 0;
        }
        return mdex;
    }

    public int getMinCharges() {
        for (EquipmentModifier eqMod : this.getEqModifierList(true)) {
            Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
            if (min == null) continue;
            return min;
        }
        return 0;
    }

    @Override
    public void setName(String aString) {
        super.setName(aString);
        this.setDirty(true);
    }

    public void setModifiedName(String nameString) {
        this.modifiedName = nameString;
        this.setDirty(true);
    }

    public void setMoveString(String aString) {
        this.moveString = aString;
    }

    public String getName() {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(this.getDisplayName());
        if (this.modifiedName.length() > 0) {
            buffer.append(" (").append(this.modifiedName).append(")");
        }
        return buffer.toString();
    }

    public void setNote(String aString) {
        this.noteString = aString;
    }

    public String getNote() {
        return this.noteString;
    }

    public void setNumberCarried(Float aNumber) {
        this.carried = aNumber;
    }

    public void setNumberEquipped(int num) {
        this.numberEquipped = num;
        if (num > 0) {
            this.equipped = true;
        }
    }

    public int getNumberEquipped() {
        return this.numberEquipped;
    }

    public void setOutputIndex(int newIndex) {
        this.outputIndex = newIndex;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputSubindex(int newSubindex) {
        this.outputSubindex = newSubindex;
    }

    public int getOutputSubindex() {
        return this.outputSubindex;
    }

    public void setParent(Equipment parent) {
        this.d_parent = parent;
    }

    public Equipment getParent() {
        return this.d_parent;
    }

    public String getParentName() {
        Equipment anEquip = this.getParent();
        if (anEquip != null) {
            return anEquip.toString();
        }
        if (this.isEquipped()) {
            return "Equipped";
        }
        if (this.numberCarried().intValue() > 0) {
            return "Carried";
        }
        return "";
    }

    public boolean isPreType(String aType) {
        String tString = aType;
        if (tString.startsWith(".IF.TYPE=")) {
            StringTokenizer aTok = new StringTokenizer(tString.substring(9), ".");
            int idx = tString.indexOf(".THEN.");
            if (idx < 0) {
                return false;
            }
            String truePart = tString.substring(idx + 6);
            int idx1 = truePart.indexOf(".ELSE.");
            String falsePart = "";
            if (idx1 >= 0) {
                falsePart = truePart.substring(idx1 + 6);
                truePart = truePart.substring(0, idx1);
            }
            boolean typeFound = false;
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                if (!this.isType(aString, this.bonusPrimary)) continue;
                typeFound = true;
                break;
            }
            if ((tString = typeFound ? truePart : falsePart).length() == 0) {
                return true;
            }
        }
        if (tString.startsWith("EQMODTYPE=") || tString.startsWith("EQMODTYPE.")) {
            tString = tString.substring(10);
            for (EquipmentModifier eqMod : this.getEqModifierList(this.bonusPrimary)) {
                if (!eqMod.isType(tString)) continue;
                return true;
            }
            return false;
        }
        if (tString.startsWith("EQMOD=") || tString.startsWith("EQMOD.")) {
            EquipmentModifier eqMod;
            String key = tString.substring(6);
            String choice = "";
            if (key.indexOf("(") > 0) {
                int i = key.indexOf("(");
                choice = key.substring(i + 1, key.lastIndexOf(")"));
                key = key.substring(0, i);
            }
            if ((eqMod = this.getEqModifierKeyed(key, this.bonusPrimary)) != null) {
                if (StringUtils.isEmpty(choice)) {
                    return true;
                }
                return this.hasAssociations(eqMod) && choice.equalsIgnoreCase(this.getFirstAssociation(eqMod));
            }
            return false;
        }
        return this.isType(tString, this.bonusPrimary);
    }

    public void setQty(String aString) {
        try {
            this.setQty(Double.parseDouble(aString));
        }
        catch (NumberFormatException nfe) {
            this.qty = 0.0;
        }
    }

    public void setQty(Float aFloat) {
        this.setQty(aFloat.doubleValue());
    }

    public Float getQty() {
        return new Float(this.qty);
    }

    public int getRawCritRange(boolean bPrimary) {
        String cr;
        int range = this.getHeadInfo(bPrimary ? 1 : 2, IntegerKey.CRIT_RANGE);
        if (range == 0 && (cr = this.getWeaponInfo("CRITRANGE", bPrimary)).length() != 0) {
            try {
                range = Integer.parseInt(cr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return range;
    }

    @Override
    public String getRawSpecialProperties() {
        StringBuilder retString = new StringBuilder(200);
        boolean first = true;
        for (SpecialProperty sprop : this.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            if (!first) {
                retString.append(", ");
            }
            first = false;
            retString.append(sprop.getText());
        }
        return retString.toString();
    }

    public void setRemainingCharges(int remainingCharges) {
        for (EquipmentModifier eqMod : this.getEqModifierList(true)) {
            Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
            if (min == null || min <= 0) continue;
            EqModSpellInfo.setRemainingCharges(this, eqMod, remainingCharges);
        }
    }

    public int getRemainingCharges() {
        for (EquipmentModifier eqMod : this.getEqModifierList(true)) {
            Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
            if (min == null || min <= 0) continue;
            return EqModSpellInfo.getRemainingCharges(this, eqMod);
        }
        return -1;
    }

    public String getSimpleName() {
        return this.getDisplayName();
    }

    public String getSize() {
        return this.getSafe(ObjectKey.SIZE).resolvesTo().getKeyName();
    }

    public SizeAdjustment getSizeAdjustment() {
        return this.getSafe(ObjectKey.SIZE).resolvesTo();
    }

    public int getSlots(PlayerCharacter aPC) {
        int iSlots = this.getSafe(IntegerKey.SLOTS);
        EquipmentHead head = this.getEquipmentHeadReference(1);
        if (head != null) {
            for (EquipmentModifier eqMod : head.getSafeListFor(ListKey.EQMOD)) {
                iSlots += (int)eqMod.bonusTo(aPC, "EQM", "HANDS", this);
                iSlots += (int)eqMod.bonusTo(aPC, "EQM", "SLOTS", this);
            }
        }
        if (iSlots < 0) {
            iSlots = 0;
        }
        return iSlots;
    }

    public String getSlot() {
        for (EquipSlot es : SystemCollections.getUnmodifiableEquipSlotList()) {
            if (!es.canContainType(this.getType())) continue;
            return es.getSlotName();
        }
        return null;
    }

    public String getSpecialProperties(PlayerCharacter aPC) {
        EquipmentHead head = this.getEquipmentHeadReference(1);
        List<Object> modList = head == null ? Collections.emptyList() : head.getSafeListFor(ListKey.EQMOD);
        EquipmentHead althead = this.getEquipmentHeadReference(2);
        List<Object> altModList = althead == null ? Collections.emptyList() : althead.getSafeListFor(ListKey.EQMOD);
        ArrayList<EquipmentModifier> comn = new ArrayList<EquipmentModifier>();
        Equipment.extractListFromCommon(comn, modList);
        this.removeCommonFromList(altModList, comn, "SPROP: eqMod expected but not found: ");
        String common = StringUtil.join(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(comn, aPC)), (String)", ");
        String saList1 = StringUtil.join(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(modList, aPC)), (String)", ");
        String saList2 = StringUtil.join(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(altModList, aPC)), (String)", ");
        StringBuilder sp = new StringBuilder(200);
        boolean first = true;
        for (SpecialProperty sprop : this.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            String text = sprop.getParsedText(aPC, this, this);
            if ("".equals(text)) continue;
            if (!first) {
                sp.append(", ");
            }
            first = false;
            sp.append(text);
        }
        if (common.length() != 0) {
            if (!first) {
                sp.append(", ");
            }
            first = false;
            sp.append(common);
        }
        if (saList1.length() != 0) {
            if (!first) {
                sp.append(", ");
            }
            first = false;
            if (this.isDouble()) {
                sp.append("Head1: ");
            }
            sp.append(saList1);
        }
        if (this.isDouble() && saList2.length() != 0) {
            if (!first) {
                sp.append(", ");
            }
            sp.append("Head2: ").append(saList2);
        }
        return sp.toString();
    }

    public Equipment getUberParent() {
        if (this.getParent() == null) {
            return this;
        }
        Equipment anEquip = this.getParent();
        while (anEquip.getParent() != null) {
            anEquip = anEquip.getParent();
        }
        return anEquip;
    }

    public int getUsedCharges() {
        for (EquipmentModifier eqMod : this.getEqModifierList(true)) {
            Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
            if (min == null || min <= 0) continue;
            return EqModSpellInfo.getUsedCharges(this, eqMod);
        }
        return -1;
    }

    @Override
    public Float getVariableValue(String varName, String src, PlayerCharacter aPC) {
        return this.getVariableValue(varName, src, this.bonusPrimary, aPC);
    }

    public Float getVariableValue(String varName, String src, boolean bPrimary, PlayerCharacter aPC) {
        VariableProcessorEq vp = new VariableProcessorEq(this, aPC, bPrimary);
        return vp.getVariableValue(null, varName, src, 0);
    }

    public boolean isVisible(EquipmentModifier eqMod, View v) {
        Visibility vis = eqMod.getSafe(ObjectKey.VISIBILITY);
        if (Visibility.QUALIFY.equals((Object)vis)) {
            this.bonusPrimary = true;
            if (PrereqHandler.passesAll(eqMod.getPrerequisiteList(), this, null)) {
                return true;
            }
            if (this.isDouble()) {
                this.bonusPrimary = false;
                return PrereqHandler.passesAll(eqMod.getPrerequisiteList(), this, null);
            }
            return false;
        }
        return vis.isVisibleTo(v);
    }

    public boolean isVisible(EquipmentModifier eqMod, boolean primaryHead, View v) {
        Visibility vis = eqMod.getSafe(ObjectKey.VISIBILITY);
        if (Visibility.QUALIFY.equals((Object)vis)) {
            this.bonusPrimary = primaryHead;
            return PrereqHandler.passesAll(eqMod.getPrerequisiteList(), this, null);
        }
        return vis.isVisibleTo(v);
    }

    public Float getWeight(PlayerCharacter aPC) {
        if (this.isVirtual()) {
            return new Float(0.0);
        }
        return new Float(this.getWeightAsDouble(aPC));
    }

    public BigDecimal getBaseWeight() {
        if (this.isVirtual()) {
            return BigDecimal.ZERO;
        }
        return this.getWeightInPounds().add(this.getSafe(ObjectKey.WEIGHT_MOD));
    }

    public double getWeightAsDouble(PlayerCharacter aPC) {
        double d2;
        if (this.isVirtual()) {
            return 0.0;
        }
        double d1 = this.bonusTo(aPC, "EQM", "WEIGHTMULT", true);
        double aWeight = this.getWeightInPounds().doubleValue();
        if (!CoreUtility.doublesEqual(d1, 0.0)) {
            aWeight *= d1;
        }
        if (!CoreUtility.doublesEqual(d2 = this.bonusTo(aPC, "EQM", "WEIGHTDIV", true), 0.0)) {
            aWeight /= d2;
        }
        aWeight += this.bonusTo(aPC, "EQM", "WEIGHTADD", true);
        return aWeight += this.getSafe(ObjectKey.WEIGHT_MOD).doubleValue();
    }

    public String getWieldName() {
        WieldCategory wield = this.get(ObjectKey.WIELD);
        return wield == null ? "" : wield.getKeyName();
    }

    public Integer acCheck(PlayerCharacter aPC) {
        return Math.min(this.getSafe(IntegerKey.AC_CHECK) + (int)this.bonusTo(aPC, "EQMARMOR", "ACCHECK", true), 0);
    }

    public boolean acceptsChildren() {
        return this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY) != null;
    }

    private void addEqModifier(String aString, boolean bPrimary, boolean isLoading) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String eqModKey = aTok.nextToken();
        EquipmentModifier eqMod = this.getEqModifierKeyed(eqModKey, bPrimary);
        if (eqMod == null) {
            if (eqModKey.equals(EQMOD_WEIGHT)) {
                if (aTok.hasMoreTokens()) {
                    this.put(ObjectKey.WEIGHT_MOD, new BigDecimal(aTok.nextToken().replace(',', '.')));
                }
                return;
            }
            if (eqModKey.equals(EQMOD_DAMAGE)) {
                if (aTok.hasMoreTokens()) {
                    this.put(StringKey.DAMAGE_OVERRIDE, aTok.nextToken());
                }
                return;
            }
            eqMod = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(EquipmentModifier.class, eqModKey);
            if (eqMod == null) {
                Logging.errorPrint("Could not find EquipmentModifier: " + eqModKey);
                return;
            }
            if (eqMod.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                eqMod = eqMod.clone();
            }
            this.addToEqModifierList(eqMod, bPrimary);
        }
        if (eqMod.getSafe(StringKey.CHOICE_STRING).length() != 0) {
            while (aTok.hasMoreTokens()) {
                String x = aTok.nextToken();
                Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
                if (min != null && min > 0 || eqMod.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER") && !isLoading) {
                    this.removeAllAssociations(eqMod);
                }
                this.addAssociation(eqMod, x.replace('=', '|'));
            }
        }
    }

    public void addEqModifier(EquipmentModifier eqMod, boolean bPrimary, PlayerCharacter aPC) {
        this.addEqModifier(eqMod, bPrimary, aPC, null, null);
    }

    public void addEqModifier(EquipmentModifier eqMod, boolean bPrimary, PlayerCharacter aPC, String selectedChoice, EquipmentChoice equipChoice) {
        EquipmentModifier aMod;
        boolean bImporting = false;
        if (aPC != null && aPC.isImporting()) {
            bImporting = true;
        }
        if (!bImporting && !this.canAddModifier(eqMod, bPrimary)) {
            return;
        }
        List<CDOMSingleRef<EquipmentModifier>> replaces = eqMod.getListFor(ListKey.REPLACED_KEYS);
        EquipmentHead head = this.getEquipmentHead(bPrimary ? 1 : 2);
        if (replaces != null) {
            for (CDOMSingleRef<EquipmentModifier> ref : replaces) {
                EquipmentModifier mod = ref.resolvesTo();
                String key = mod.getKeyName();
                for (EquipmentModifier aMod2 : head.getSafeListFor(ListKey.EQMOD)) {
                    if (!key.equalsIgnoreCase(aMod2.getKeyName())) continue;
                    head.removeFromListFor(ListKey.EQMOD, aMod2);
                    if (bPrimary) {
                        this.usePrimaryCache = false;
                    } else {
                        this.useSecondaryCache = false;
                    }
                    this.setDirty(true);
                }
            }
        }
        if (eqMod.isType("BaseMaterial")) {
            for (EquipmentModifier aMod3 : head.getSafeListFor(ListKey.EQMOD)) {
                if (!aMod3.isType("BaseMaterial")) continue;
                head.removeFromListFor(ListKey.EQMOD, aMod3);
                if (bPrimary) {
                    this.usePrimaryCache = false;
                } else {
                    this.useSecondaryCache = false;
                }
                this.setDirty(true);
            }
        } else if (eqMod.isType("MagicalEnhancement")) {
            for (EquipmentModifier aMod3 : head.getSafeListFor(ListKey.EQMOD)) {
                if (!aMod3.isType("MagicalEnhancement")) continue;
                head.removeFromListFor(ListKey.EQMOD, aMod3);
                if (bPrimary) {
                    this.usePrimaryCache = false;
                    continue;
                }
                this.useSecondaryCache = false;
            }
        }
        if ((aMod = this.getEqModifierKeyed(eqMod.getKeyName(), bPrimary)) == null) {
            if (eqMod.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                aMod = eqMod.clone();
                if (aMod == null) {
                    return;
                }
            } else {
                aMod = eqMod;
            }
            head.addToListFor(ListKey.EQMOD, aMod);
            if (bPrimary) {
                this.usePrimaryCache = false;
            } else {
                this.useSecondaryCache = false;
            }
        }
        if (!bImporting) {
            boolean allRemoved = false;
            if (selectedChoice != null && selectedChoice.length() > 0) {
                if (!eqMod.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER.")) {
                    EquipmentChoiceDriver.setChoice(this, aMod, selectedChoice, equipChoice);
                    allRemoved = !this.hasAssociations(aMod);
                }
            } else if (!EquipmentChoiceDriver.getChoice(1, this, aMod, true, aPC)) {
                allRemoved = true;
            }
            if (allRemoved) {
                head.removeFromListFor(ListKey.EQMOD, aMod);
                if (bPrimary) {
                    this.usePrimaryCache = false;
                } else {
                    this.useSecondaryCache = false;
                }
            }
        }
        this.setBase();
    }

    public void addEqModifiers(String aString, boolean bPrimary) {
        this.addEqModifiers(aString, bPrimary, false);
    }

    private void addEqModifiers(String aString, boolean bPrimary, boolean isLoading) {
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        while (aTok.hasMoreTokens()) {
            String aEqModName = aTok.nextToken();
            if (aEqModName.equalsIgnoreCase("None")) continue;
            this.addEqModifier(aEqModName, bPrimary, isLoading);
        }
    }

    public double bonusTo(PlayerCharacter aPC, String aType, String aName, boolean bPrimary) {
        return this.bonusTo(aPC, aType, aName, this, bPrimary);
    }

    private double bonusTo(PlayerCharacter aPC, String aType, String aName, Object anObj, boolean bPrimary) {
        StringBuilder sB = new StringBuilder(aType.toUpperCase());
        sB.append('.');
        sB.append(aName.toUpperCase());
        sB.append('.');
        String aBonusKey = sB.toString();
        for (String aKey : this.getBonusMap().keySet()) {
            if (!aKey.startsWith(aBonusKey)) continue;
            this.putBonusMap(aKey, "0");
        }
        this.bonusPrimary = bPrimary;
        if (bPrimary) {
            BonusCalc.equipBonusTo(this, aType, aName, aPC);
            ArrayList<BonusObj> tbList = new ArrayList<BonusObj>();
            for (BonusObj aBonus : this.getTempBonusList()) {
                if (tbList.contains(aBonus)) continue;
                tbList.add(aBonus);
            }
            BonusCalc.bonusTo(this, aType, aName, anObj, tbList, aPC);
        }
        if (Globals.checkRule("SYS_35WP")) {
            for (EqSizePenalty esp : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(EqSizePenalty.class)) {
                BonusCalc.bonusTo(this, aType, aName, this, esp.getBonuses(), aPC);
            }
        }
        List<EquipmentModifier> eqModList = this.getEqModifierList(bPrimary);
        for (EquipmentModifier eqMod : eqModList) {
            eqMod.bonusTo(aPC, aType, aName, this);
        }
        double iBonus = 0.0;
        for (String key : this.getBonusMap().keySet()) {
            if (!key.startsWith(aBonusKey)) continue;
            iBonus += (double)Float.parseFloat(this.getBonusMap().get(key));
        }
        return iBonus;
    }

    public int calcPlusForCosting() {
        int iPlus = 0;
        for (EquipmentHead head : this.heads) {
            for (EquipmentModifier eqMod : head.getSafeListFor(ListKey.EQMOD)) {
                int iCount = this.getSelectCorrectedAssociationCount(eqMod);
                if (iCount < 1) {
                    iCount = 1;
                }
                iPlus += iCount * eqMod.getSafe(IntegerKey.PLUS);
            }
        }
        return iPlus;
    }

    public int calcPlusForHead(boolean bPrimary) {
        int iPlus = 0;
        int headnum = bPrimary ? 1 : 2;
        EquipmentHead head = this.getEquipmentHeadReference(headnum);
        if (head == null) {
            return iPlus;
        }
        for (EquipmentModifier eqMod : head.getSafeListFor(ListKey.EQMOD)) {
            int iCount = this.getSelectCorrectedAssociationCount(eqMod);
            if (iCount < 1) {
                iCount = 1;
            }
            iPlus += iCount * eqMod.getSafe(IntegerKey.PLUS);
        }
        return iPlus;
    }

    public boolean canAddModifier(PrereqObject eqMod, boolean bPrimary) {
        this.bonusPrimary = bPrimary;
        return this.getSafe(ObjectKey.MOD_CONTROL).getModifiersAllowed() && PrereqHandler.passesAll(eqMod.getPrerequisiteList(), this, null);
    }

    public int canContain(PlayerCharacter aPC, Object obj) {
        if (obj instanceof Equipment) {
            Equipment anEquip = (Equipment)obj;
            Float f = new Float(anEquip.getWeightAsDouble(aPC) * (double)anEquip.numberCarried().floatValue());
            if (this.checkChildWeight(aPC, f)) {
                if (this.checkContainerCapacity(anEquip.eqTypeList(), anEquip.numberCarried())) {
                    return 1;
                }
                return 4;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Equipment clone() {
        Equipment eq = null;
        try {
            eq = (Equipment)super.clone();
            eq.heads = new ArrayList<EquipmentHead>();
            for (EquipmentHead head : this.heads) {
                if (head == null) {
                    eq.heads.add(null);
                    continue;
                }
                eq.heads.add((EquipmentHead)head.clone());
            }
            if (this.bonusMap != null) {
                eq.bonusMap = new HashMap<String, String>(this.bonusMap);
            }
            eq.setMoveString(this.moveString());
            eq.carried = this.carried;
            eq.equipped = this.equipped;
            eq.location = this.location;
            eq.numberEquipped = this.numberEquipped;
            eq.qty = this.qty;
            eq.outputIndex = this.outputIndex;
            eq.d_childTypes = new HashMap<String, Float>(this.d_childTypes);
            eq.d_containedEquipment = new ArrayList<Equipment>(this.d_containedEquipment);
            eq.assocSupt = this.assocSupt.clone();
            eq.getEquipmentHead(1).removeListFor(ListKey.EQMOD);
            eq.getEquipmentHead(2).removeListFor(ListKey.EQMOD);
            eq.getEquipmentHead(1).addAllToListFor(ListKey.EQMOD, this.cloneEqModList(eq, true));
            eq.getEquipmentHead(2).addAllToListFor(ListKey.EQMOD, this.cloneEqModList(eq, false));
        }
        catch (CloneNotSupportedException e) {
            ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.ERROR);
        }
        return eq;
    }

    @Override
    public int compareTo(Object o) {
        Equipment e = (Equipment)o;
        return this.getName().compareToIgnoreCase(e.getName());
    }

    public Integer eDR(PlayerCharacter aPC) {
        return Math.max(0, this.getSafe(IntegerKey.EDR) + (int)this.bonusTo(aPC, "EQMARMOR", "EDR", true));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Equipment other = (Equipment)obj;
        String displayName = this.getDisplayName();
        if (displayName == null ? other.getDisplayName() != null : !displayName.equals(other.getDisplayName())) {
            return false;
        }
        return !(this.modifiedName == null ? other.modifiedName != null : !this.modifiedName.equals(other.modifiedName));
    }

    public String formatSaveLine(char sep, char endPart) {
        String string3;
        String string2;
        String string1;
        SizeAdjustment thisSize;
        Equipment base;
        StringBuilder sbuf = new StringBuilder(100);
        CDOMSingleRef<Equipment> baseItem = this.get(ObjectKey.BASE_ITEM);
        if (baseItem == null) {
            base = this;
            sbuf.append(this.getBaseItemName());
        } else {
            base = baseItem.resolvesTo();
            sbuf.append(base.getKeyName());
            sbuf.append(sep).append("NAME").append(endPart).append(this.toString(false));
        }
        if (!this.getKeyName().equals(this.getName())) {
            sbuf.append(sep).append("KEY").append(endPart).append(this.getKeyName());
        }
        if (!(thisSize = this.getSafe(ObjectKey.SIZE).resolvesTo()).equals(base.getSafe(ObjectKey.SIZE).resolvesTo())) {
            sbuf.append(sep).append("SIZE").append(endPart).append(thisSize.getKeyName());
        }
        if ((string1 = this.getEqModifierString(true)).length() > 0) {
            sbuf.append(sep).append("EQMOD").append(endPart).append(string1);
        }
        if ((string2 = this.getEqModifierString(false)).length() > 0) {
            sbuf.append(sep).append("ALTEQMOD").append(endPart).append(string2);
        }
        if ((string3 = this.getRawSpecialProperties()).length() > 0 && !string3.equals(base.getRawSpecialProperties())) {
            sbuf.append(sep).append("SPROP").append(endPart).append(string3);
        }
        if (!this.costMod.equals(BigDecimal.ZERO)) {
            sbuf.append(sep).append("COSTMOD").append(endPart).append(this.costMod.toString());
        }
        return sbuf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String displayName = this.getDisplayName();
        result = 31 * result + (displayName == null ? 0 : displayName.hashCode());
        result = 31 * result + (this.modifiedName == null ? 0 : this.modifiedName.hashCode());
        return result;
    }

    private int indexOfChild(Object child) {
        if (!(child instanceof Equipment)) {
            return -1;
        }
        return this.getContainedEquipmentIndexOf((Equipment)child);
    }

    public void insertChild(PlayerCharacter aPC, Object child) {
        Float aFloat;
        if (child == null) {
            return;
        }
        Equipment anEquip = (Equipment)child;
        Float bFloat = aFloat = anEquip.numberCarried();
        String aString = this.pickChildType(anEquip.eqTypeList(), aFloat);
        if (this.containsChildType(aString)) {
            aFloat = Float.valueOf(this.getChildType(aString).floatValue() + aFloat.floatValue());
        }
        bFloat = Float.valueOf(this.getChildType("Total").floatValue() + bFloat.floatValue());
        this.setChildType(aString, aFloat);
        this.setChildType("Total", bFloat);
        this.addContainedEquipment(anEquip);
        anEquip.setIndexedUnderType(aString);
        anEquip.setParent(this);
        this.updateContainerContentsString(aPC);
        while (anEquip.getParent() != null) {
            anEquip = anEquip.getParent();
            anEquip.updateContainerContentsString(aPC);
        }
    }

    public int itemDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        int i = 1;
        Equipment anEquip = this.getParent();
        while (anEquip.getParent() != null) {
            anEquip = anEquip.getParent();
            ++i;
        }
        return i;
    }

    public void load(String aLine, String sep, String endPart, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aLine, sep);
        int endPartLen = endPart.length();
        CDOMSingleRef<SizeAdjustment> size = this.getSafe(ObjectKey.SIZE);
        boolean firstSprop = true;
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (aString.startsWith("NAME" + endPart)) {
                this.setName(aString.substring(4 + endPartLen).intern());
                this.put(StringKey.OUTPUT_NAME, this.getDisplayName());
                continue;
            }
            if (aString.startsWith("KEY" + endPart)) {
                this.put(StringKey.KEY_NAME, aString.substring(3 + endPartLen));
                continue;
            }
            if (aString.startsWith("SIZE" + endPart)) {
                size = Globals.getContext().getReferenceContext().getCDOMReference(SizeAdjustment.class, aString.substring(4 + endPartLen));
                continue;
            }
            if (aString.startsWith("EQMOD" + endPart)) {
                this.addEqModifiers(aString.substring(5 + endPartLen), true, true);
                continue;
            }
            if (aString.startsWith("ALTEQMOD" + endPart)) {
                this.addEqModifiers(aString.substring(8 + endPartLen), false);
                continue;
            }
            if (aString.startsWith("SPROP" + endPart)) {
                if (firstSprop) {
                    this.removeListFor(ListKey.SPECIAL_PROPERTIES);
                    firstSprop = false;
                }
                this.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(aString.substring(5 + endPartLen)));
                continue;
            }
            if (aString.startsWith("COSTMOD" + endPart)) {
                this.setCostMod(aString.substring(7 + endPartLen));
                continue;
            }
            if (!aString.startsWith("WEIGHTMOD" + endPart)) continue;
            this.put(ObjectKey.WEIGHT_MOD, new BigDecimal(aString.substring(9 + endPartLen)));
        }
        this.put(ObjectKey.CUSTOMSIZE, size);
    }

    public void setToCustomSize(PlayerCharacter pc) {
        CDOMSingleRef<SizeAdjustment> csr = this.get(ObjectKey.CUSTOMSIZE);
        if (csr != null) {
            SizeAdjustment customSize = csr.resolvesTo();
            if (!this.getSafe(ObjectKey.SIZE).equals(customSize)) {
                this.resizeItem(pc, customSize);
            }
        }
    }

    public String longName() {
        return this.toString(true);
    }

    public boolean meetsPreReqs(PlayerCharacter pc) {
        return PrereqHandler.passesAll(this.getPrerequisiteList(), this, pc);
    }

    public String modifiedName() {
        return this.modifiedName;
    }

    public String moveString() {
        if (this.moveString.length() > 0) {
            Load eqLoad = this.isHeavy() ? Load.HEAVY : (this.isMedium() ? Load.MEDIUM : (this.isLight() ? Load.LIGHT : Load.OVERLOAD));
            StringTokenizer aTok = new StringTokenizer(this.moveString, ",");
            int baseMove = -1;
            int tokenCount = aTok.countTokens();
            switch (tokenCount) {
                case 2: {
                    baseMove = 30;
                    break;
                }
                case 3: {
                    baseMove = 60;
                    break;
                }
                default: {
                    tokenCount = -1;
                }
            }
            if (tokenCount > 0) {
                StringBuilder retString = new StringBuilder(this.moveString.length());
                for (int i = 0; i < tokenCount; ++i) {
                    if (i != 0) {
                        retString.append(',');
                    }
                    retString.append(Globals.calcEncumberedMove(eqLoad, baseMove));
                    baseMove -= 10;
                }
                return retString.toString();
            }
        }
        return this.moveString;
    }

    public String nameItemFromModifiers(PlayerCharacter pc) {
        String itemName = this.getItemNameFromModifiers(this.getBaseItemName());
        this.setDefaultCrit(pc);
        this.setName(itemName);
        String itemKey = this.getItemNameFromModifiers(this.getBaseItemKeyName()).replaceAll("[^A-Za-z0-9/_() +-]", "_");
        this.setKeyName(itemKey);
        this.remove(StringKey.OUTPUT_NAME);
        return this.getKeyName();
    }

    public Float numberCarried() {
        Equipment eqParent;
        if (this.isEquipped() || eqParent == null) {
            return this.carried;
        }
        for (eqParent = this.getParent(); eqParent != null; eqParent = eqParent.getParent()) {
            if (!eqParent.isEquipped() && (eqParent.getParent() != null || eqParent.numberCarried().intValue() == 0)) continue;
            return this.carried;
        }
        return Float.valueOf(0.0f);
    }

    public double qty() {
        return this.qty;
    }

    public void removeChild(PlayerCharacter pc, Object child) {
        int i = this.indexOfChild(child);
        Equipment anEquip = (Equipment)child;
        Float qtyRemoved = anEquip.numberCarried();
        this.setChildType("Total", Float.valueOf(this.getChildType("Total").floatValue() - qtyRemoved.floatValue()));
        String aString = anEquip.isIndexedUnderType();
        this.setChildType(aString, Float.valueOf(this.getChildType(aString).floatValue() - qtyRemoved.floatValue()));
        anEquip.setParent(null);
        this.removeContainedEquipment(i);
        this.updateContainerContentsString(pc);
        Equipment equipment = this;
        while (equipment.getParent() != null) {
            equipment = equipment.getParent();
            equipment.updateContainerContentsString(pc);
        }
    }

    public void removeEqModifier(EquipmentModifier eqMod, boolean bPrimary, PlayerCharacter pc) {
        EquipmentModifier aMod = this.getEqModifierKeyed(eqMod.getKeyName(), bPrimary);
        if (aMod == null) {
            return;
        }
        if (!this.hasAssociations(aMod) || !EquipmentChoiceDriver.getChoice(0, this, aMod, false, pc)) {
            EquipmentHead head = this.getEquipmentHead(bPrimary ? 1 : 2);
            head.removeFromListFor(ListKey.EQMOD, aMod);
            if (bPrimary) {
                this.usePrimaryCache = false;
            } else {
                this.useSecondaryCache = false;
            }
            this.restoreEqModsAfterRemove(eqMod, bPrimary, head);
            this.setDirty(true);
        }
    }

    private void restoreEqModsAfterRemove(EquipmentModifier eqMod, boolean bPrimary, EquipmentHead head) {
        block7: {
            CDOMSingleRef<Equipment> baseItem;
            block6: {
                baseItem = this.get(ObjectKey.BASE_ITEM);
                if (baseItem == null) {
                    return;
                }
                List<CDOMSingleRef<EquipmentModifier>> replaces = eqMod.getListFor(ListKey.REPLACED_KEYS);
                if (replaces != null) {
                    for (CDOMSingleRef<EquipmentModifier> ref : replaces) {
                        EquipmentModifier mod = ref.resolvesTo();
                        String key = mod.getKeyName();
                        for (EquipmentModifier baseMod : baseItem.resolvesTo().getEquipmentHead(bPrimary ? 1 : 2).getSafeListFor(ListKey.EQMOD)) {
                            if (!key.equalsIgnoreCase(baseMod.getKeyName())) continue;
                            head.addToListFor(ListKey.EQMOD, baseMod);
                        }
                    }
                }
                if (!eqMod.isType("BaseMaterial")) break block6;
                for (EquipmentModifier baseMod : baseItem.resolvesTo().getEquipmentHead(bPrimary ? 1 : 2).getSafeListFor(ListKey.EQMOD)) {
                    if (!baseMod.isType("BaseMaterial")) continue;
                    head.addToListFor(ListKey.EQMOD, baseMod);
                }
                break block7;
            }
            if (!eqMod.isType("MagicalEnhancement")) break block7;
            for (EquipmentModifier baseMod : baseItem.resolvesTo().getEquipmentHead(bPrimary ? 1 : 2).getSafeListFor(ListKey.EQMOD)) {
                if (!baseMod.isType("MagicalEnhancement")) continue;
                head.addToListFor(ListKey.EQMOD, baseMod);
            }
        }
    }

    public void removeEqModifiers(String aString, boolean bPrimary, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        while (aTok.hasMoreTokens()) {
            String aEqModName = aTok.nextToken();
            if (aEqModName.equalsIgnoreCase("None")) continue;
            this.removeEqModifier(aEqModName, bPrimary, pc);
        }
    }

    public void resizeItem(PlayerCharacter pc, SizeAdjustment newSize) {
        this.setBase();
        int iOldSize = this.sizeInt();
        int iNewSize = newSize.get(IntegerKey.SIZEORDER);
        if (iNewSize != iOldSize) {
            BigDecimal weightCap;
            String adam;
            this.put(ObjectKey.SIZE, CDOMDirectSingleRef.getRef(newSize));
            CDOMSingleRef<Equipment> baseItem = this.get(ObjectKey.BASE_ITEM);
            Equipment eq = baseItem == null ? this : baseItem.resolvesTo();
            this.put(ObjectKey.CURRENT_COST, eq.getCostAdjustedForSize(pc, newSize));
            this.put(ObjectKey.WEIGHT, eq.getWeightAdjustedForSize(pc, newSize));
            this.adjustACForSize(pc, eq, newSize);
            String dam = eq.getDamageAdjustedForSize(newSize, true);
            if (dam != null && dam.length() > 0) {
                this.getEquipmentHead(1).put(StringKey.DAMAGE, dam);
            }
            if ((adam = eq.getDamageAdjustedForSize(newSize, false)) != null && adam.length() > 0) {
                this.getEquipmentHead(2).put(StringKey.DAMAGE, adam);
            }
            if ((weightCap = this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY)) != null) {
                List<Capacity> capacity;
                double mult = 1.0;
                if (newSize != null && pc != null) {
                    mult = pc.getSizeBonusTo(newSize, "ITEMCAPACITY", eq.typeList(), 1.0);
                }
                BigDecimal multbd = new BigDecimal(mult);
                if (!Capacity.UNLIMITED.equals(weightCap)) {
                    this.put(ObjectKey.CONTAINER_WEIGHT_CAPACITY, weightCap.multiply(multbd));
                }
                if ((capacity = this.removeListFor(ListKey.CAPACITY)) != null) {
                    for (Capacity cap : capacity) {
                        BigDecimal content = cap.getCapacity();
                        if (!Capacity.UNLIMITED.equals(content)) {
                            content = content.multiply(multbd);
                        }
                        this.addToListFor(ListKey.CAPACITY, new Capacity(cap.getType(), content));
                    }
                }
                this.updateContainerCapacityString();
            }
        }
        if (this.hasPrerequisites()) {
            AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
            int maxIndex = ref.getConstructedObjectCount(SizeAdjustment.class);
            for (Prerequisite aBonus : this.getPrerequisiteList()) {
                SizeAdjustment sa;
                int iOldPre;
                if (!"SIZE".equalsIgnoreCase(aBonus.getKind()) || (iNewSize += (iOldPre = (sa = ref.silentlyGetConstructedCDOMObject(SizeAdjustment.class, aBonus.getOperand())).get(IntegerKey.SIZEORDER).intValue()) - iOldSize) < 0 || iNewSize > maxIndex) continue;
                SizeAdjustment size = ref.getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(iNewSize);
                aBonus.setOperand(size.getKeyName());
            }
        }
    }

    public int sizeInt() {
        SizeAdjustment size = this.getSafe(ObjectKey.SIZE).resolvesTo();
        return size.get(IntegerKey.SIZEORDER);
    }

    public Integer spellFailure(PlayerCharacter pc) {
        return Math.max(0, this.getSafe(IntegerKey.SPELL_FAILURE) + (int)this.bonusTo(pc, "EQMARMOR", "SPELLFAILURE", true));
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean addCharges) {
        if (this.isDirty() || this.cachedNameWithCharges == null && this.cachedNameWithoutCharges == null) {
            int rem;
            StringBuilder buffer = new StringBuilder(100);
            if (SettingsHandler.guiUsesOutputNameEquipment()) {
                buffer.append(this.getOutputName());
            } else {
                buffer.append(this.getDisplayName());
            }
            if (this.modifiedName.length() > 0) {
                buffer.append(" (").append(this.modifiedName).append(")");
            }
            this.cachedNameWithoutCharges = buffer.toString();
            if (addCharges && (rem = this.getRemainingCharges()) > 0 && rem < this.getMaxCharges()) {
                buffer.append("(").append(rem).append(")");
            }
            this.cachedNameWithCharges = buffer.toString();
            this.setDirty(false);
        }
        if (addCharges) {
            return this.cachedNameWithCharges;
        }
        return this.cachedNameWithoutCharges;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String typeIndex(int index) {
        List<String> tList = this.typeList();
        if (index < 0 || index >= tList.size()) {
            return "";
        }
        return tList.get(index);
    }

    public List<String> typeList() {
        return this.typeList(true);
    }

    public void updateContainerContentsString(PlayerCharacter pc) {
        StringBuilder tempStringBuilder = new StringBuilder(this.getChildCount() * 20);
        if (pc != null && this.acceptsChildren() && this.getContainedWeight(pc, true).floatValue() >= 0.0f) {
            tempStringBuilder.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(this.getContainedWeight(pc, true).doubleValue())).append(Globals.getGameModeUnitSet().getWeightUnit());
        } else {
            tempStringBuilder.append("0.0 ");
            tempStringBuilder.append(Globals.getGameModeUnitSet().getWeightUnit());
        }
        for (int e = 0; e < this.getChildCount(); ++e) {
            Equipment anEquip = (Equipment)this.getChild(e);
            if (!(anEquip.getQty().floatValue() > 0.0f)) continue;
            tempStringBuilder.append(", ");
            tempStringBuilder.append(BigDecimalHelper.trimZeros(anEquip.getQty().toString()));
            tempStringBuilder.append(" ");
            tempStringBuilder.append(anEquip.getOutputName());
        }
        this.containerContentsString = tempStringBuilder.toString();
    }

    private void setDefaultCrit(PlayerCharacter aPC) {
        if (this.isWeapon()) {
            if (aPC != null && aPC.getCritRange(this, true) == 0) {
                this.getEquipmentHead(1).put(IntegerKey.CRIT_RANGE, 1);
            }
            if (this.getCritMultiplier() == 0) {
                this.getEquipmentHead(1).put(IntegerKey.CRIT_MULT, 2);
            }
        }
    }

    public void setQty(double argQty) {
        this.qty = argQty;
    }

    static void clearEquipmentTypes() {
        S_EQUIPMENT_TYPES.clear();
    }

    String getType(boolean bPrimary) {
        List<String> typeList = this.typeList(bPrimary);
        int typeSize = typeList.size();
        StringBuilder aType = new StringBuilder(typeSize * 5);
        for (String s : typeList) {
            if (aType.length() != 0) {
                aType.append('.');
            }
            aType.append(s);
        }
        return aType.toString();
    }

    boolean save(BufferedWriter output) {
        FileAccess.write(output, "BASEITEM:" + this.formatSaveLine('\t', ':'));
        FileAccess.newLine(output);
        return true;
    }

    public void setBase() {
        CDOMSingleRef<Equipment> baseItem;
        if (this.get(ObjectKey.BASE_ITEM) == null) {
            Equipment eq = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, this.getKeyName());
            if (eq != null) {
                this.put(ObjectKey.BASE_ITEM, CDOMDirectSingleRef.getRef(eq));
            } else {
                Logging.errorPrint("Unable to find base item for " + this.getDisplayName() + " with key " + this.getKeyName());
            }
        }
        if (this.hasConsolidatedProfName() && (baseItem = this.get(ObjectKey.BASE_ITEM)) != null) {
            CDOMSingleRef<ShieldProf> spRef;
            CDOMSingleRef<ArmorProf> apRef;
            Equipment eq = baseItem.resolvesTo();
            CDOMSingleRef<WeaponProf> wpRef = eq.get(ObjectKey.WEAPON_PROF);
            if (wpRef != null) {
                this.put(ObjectKey.WEAPON_PROF, wpRef);
            }
            if ((apRef = eq.get(ObjectKey.ARMOR_PROF)) != null) {
                this.put(ObjectKey.ARMOR_PROF, apRef);
            }
            if ((spRef = eq.get(ObjectKey.SHIELD_PROF)) != null) {
                this.put(ObjectKey.SHIELD_PROF, spRef);
            }
        }
    }

    public String consolidatedProfName() {
        if (this.isWeapon()) {
            CDOMSingleRef<WeaponProf> wpRef = this.get(ObjectKey.WEAPON_PROF);
            if (wpRef != null) {
                return wpRef.resolvesTo().getKeyName();
            }
        } else {
            if (this.isArmor()) {
                return this.getArmorProf().getKeyName();
            }
            if (this.isShield()) {
                return this.getShieldProf().getKeyName();
            }
        }
        return "";
    }

    private boolean hasConsolidatedProfName() {
        if (this.isWeapon()) {
            return this.get(ObjectKey.WEAPON_PROF) != null;
        }
        if (this.isArmor()) {
            return this.get(ObjectKey.ARMOR_PROF) != null;
        }
        if (this.isShield()) {
            return this.get(ObjectKey.SHIELD_PROF) != null;
        }
        return false;
    }

    private Float getChildType(String aType) {
        return this.d_childTypes.get(aType);
    }

    private int getContainedEquipmentIndexOf(Equipment e) {
        return this.d_containedEquipment.indexOf(e);
    }

    private BigDecimal getCostAdjustedForSize(PlayerCharacter aPC, SizeAdjustment saSize) {
        BigDecimal c = this.getSafe(ObjectKey.COST);
        SizeAdjustment saBase = this.getSafe(ObjectKey.BASESIZE).resolvesTo();
        if (saSize == null) {
            return c;
        }
        if (aPC != null) {
            double saDbl = aPC.getSizeBonusTo(saSize, "ITEMCOST", this.typeList(), 1.0);
            double saBaseDbl = aPC.getSizeBonusTo(saBase, "ITEMCOST", this.typeList(), 1.0);
            double mult = saDbl / saBaseDbl;
            c = c.multiply(new BigDecimal(mult));
        }
        return c;
    }

    private String getEqModifierString(boolean bPrimary) {
        String dmg;
        BigDecimal mod;
        List<EquipmentModifier> eqModList = this.getEqModifierList(bPrimary);
        StringBuilder aString = new StringBuilder(eqModList.size() * 10);
        for (EquipmentModifier eqMod : eqModList) {
            if (aString.length() != 0) {
                aString.append('.');
            }
            aString.append(eqMod.getKeyName());
            for (String strMod : this.getAssociationList(eqMod)) {
                aString.append('|').append(strMod.replace('|', '='));
            }
        }
        if (bPrimary && (mod = this.get(ObjectKey.WEIGHT_MOD)) != null) {
            if (aString.length() != 0) {
                aString.append('.');
            }
            aString.append(EQMOD_WEIGHT).append('|').append(mod.toString().replace('.', ','));
        }
        if ((dmg = this.get(StringKey.DAMAGE_OVERRIDE)) != null) {
            if (aString.length() != 0) {
                aString.append('.');
            }
            aString.append(EQMOD_DAMAGE).append('|').append(dmg.replace('.', ','));
        }
        return aString.toString();
    }

    private void setIndexedUnderType(String aType) {
        this.indexedUnderType = aType;
    }

    private String isIndexedUnderType() {
        return this.indexedUnderType;
    }

    private static EquipmentModifier getMagicBonus(Iterable<EquipmentModifier> eqModList) {
        if (eqModList != null) {
            for (EquipmentModifier eqMod : eqModList) {
                if (!eqMod.isType("MagicalEnhancement") && !eqMod.isIType("Magic")) continue;
                return eqMod;
            }
        }
        return null;
    }

    private String getNameFromModifiers(List<EquipmentModifier> eqModList) {
        ArrayList<EquipmentModifier> eqList = new ArrayList<EquipmentModifier>(eqModList);
        Globals.sortPObjectList(eqList);
        StringBuilder sMod = new StringBuilder(70);
        for (EquipmentModifier eqMod : eqList) {
            String modDesc = eqMod.getSafe(ObjectKey.NAME_OPT).returnName(this, eqMod);
            if (sMod.length() > 0 && modDesc.length() > 0) {
                sMod.append('/');
            }
            sMod.append(modDesc);
        }
        return sMod.toString();
    }

    private List<String> getSpecialAbilityList(Iterable<EquipmentModifier> eqModList, PlayerCharacter pc) {
        ArrayList<String> saList = new ArrayList<String>();
        for (EquipmentModifier eqMod : eqModList) {
            saList.addAll(eqMod.getSpecialProperties(this, pc));
        }
        return saList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getCostFromPluses(int iPlus, int altPlus) {
        if ((iPlus != 0 || altPlus != 0) && JEPResourceChecker.getMissingResourceCount() == 0) {
            PJEP myParser = null;
            try {
                String costExpr;
                String typeMatched;
                myParser = PjepPool.getInstance().aquire();
                myParser.addVariable("PLUS", iPlus);
                myParser.addVariable("ALTPLUS", altPlus);
                myParser.addVariable("BASECOST", this.getSafe(ObjectKey.COST).doubleValue());
                if (this.isAmmunition()) {
                    myParser.addVariable("BASEQTY", this.getSafe(IntegerKey.BASE_QUANTITY));
                }
                BigDecimal maxCost = null;
                List<String> itemTypes = this.typeList();
                for (int idx = 0; idx < itemTypes.size(); ++idx) {
                    typeMatched = itemTypes.get(idx);
                    costExpr = SettingsHandler.getGame().getPlusCalculation(typeMatched);
                    if (costExpr == null) continue;
                    BigDecimal thisCost = this.evaluateCost(myParser, costExpr);
                    if (maxCost != null && thisCost.compareTo(maxCost) <= 1) continue;
                    maxCost = thisCost;
                }
                if (maxCost != null) {
                    BigDecimal bigDecimal = maxCost;
                    return bigDecimal;
                }
                typeMatched = "ANY";
                costExpr = SettingsHandler.getGame().getPlusCalculation(typeMatched);
                if (costExpr != null) {
                    BigDecimal bigDecimal = this.evaluateCost(myParser, costExpr);
                    return bigDecimal;
                }
            }
            finally {
                PjepPool.getInstance().release(myParser);
            }
        }
        return BigDecimal.ZERO;
    }

    private boolean isMagicLimitedType() {
        boolean limited = false;
        if (this.isType("HEADGEAR") || this.isType("EYEGEAR") || this.isType("CAPE") || this.isType("AMULET") || this.isSuit() || this.isType("ROBE") || this.isType("SHIRT") || this.isType("BRACER") || this.isType("GLOVE") || this.isType("RING") || this.isType("BELT") || this.isType("BOOT")) {
            limited = true;
        }
        return limited;
    }

    private List<String> getSpecialAbilityTimesList(List<String> abilityList) {
        ArrayList<String> sortList = new ArrayList<String>();
        int[] numTimes = new int[abilityList.size()];
        for (int i = 0; i < abilityList.size(); ++i) {
            String ability = abilityList.get(i);
            if (!sortList.contains(ability)) {
                sortList.add(ability);
                numTimes[i] = 1;
                continue;
            }
            for (int j = 0; j < sortList.size(); ++j) {
                String testAbility = (String)sortList.get(j);
                if (!testAbility.equals(ability)) continue;
                int n = j;
                numTimes[n] = numTimes[n] + 1;
            }
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < sortList.size(); ++i) {
            String ability = (String)sortList.get(i);
            if (numTimes[i] > 1) {
                ability = ability + " (" + numTimes[i] + ")";
            }
            retList.add(ability);
        }
        return retList;
    }

    private BigDecimal getWeightAdjustedForSize(PlayerCharacter aPC, SizeAdjustment newSA) {
        if (this.isVirtual()) {
            return BigDecimal.ZERO;
        }
        SizeAdjustment currSA = this.getSafe(ObjectKey.SIZE).resolvesTo();
        BigDecimal weight = this.getBaseWeight();
        if (newSA == null || currSA == null) {
            return weight;
        }
        if (aPC != null) {
            double mult = aPC.getSizeBonusTo(newSA, "ITEMWEIGHT", this.typeList(), 1.0) / aPC.getSizeBonusTo(currSA, "ITEMWEIGHT", this.typeList(), 1.0);
            weight = weight.multiply(new BigDecimal(mult));
        }
        return weight;
    }

    private void addContainedEquipment(Equipment e) {
        this.d_containedEquipment.add(e);
    }

    private void adjustACForSize(PlayerCharacter aPC, Equipment baseEq, SizeAdjustment newSA) {
        if (this.getRawBonusList(aPC) != null && this.isArmor()) {
            int iOffs;
            String aString;
            double mult = 1.0;
            SizeAdjustment currSA = baseEq.getSafe(ObjectKey.SIZE).resolvesTo();
            if (newSA != null && aPC != null) {
                mult = aPC.getSizeBonusTo(newSA, "ACVALUE", baseEq.typeList(), 1.0) / aPC.getSizeBonusTo(currSA, "ACVALUE", baseEq.typeList(), 1.0);
            }
            List<BonusObj> baseEqBonusList = baseEq.getRawBonusList(aPC);
            List<BonusObj> eqBonusList = this.getRawBonusList(aPC);
            for (int i = eqBonusList.size() - 1; i >= 0; --i) {
                BonusObj aBonus = eqBonusList.get(i);
                aString = aBonus.toString();
                if (!aString.startsWith("COMBAT|AC|") || (iOffs = aString.indexOf(124, 10)) <= 10) continue;
                this.removeFromListFor(ListKey.BONUS, aBonus);
            }
            for (BonusObj aBonus : baseEqBonusList) {
                aString = aBonus.toString();
                if (!aString.startsWith("COMBAT|AC|") || (iOffs = aString.indexOf(124, 10)) <= 10) continue;
                Integer acCombatBonus = Integer.valueOf(aString.substring(10, iOffs));
                double d = acCombatBonus.doubleValue() * mult;
                acCombatBonus = (int)d;
                aString = aString.substring(0, 10) + acCombatBonus.toString() + aString.substring(iOffs);
                BonusObj b = Bonus.newBonus(Globals.getContext(), aString);
                if (b == null) continue;
                this.addToListFor(ListKey.BONUS, b);
            }
        }
    }

    private boolean checkChildWeight(PlayerCharacter aPC, Float aFloat) {
        BigDecimal weightCap = this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY);
        return weightCap != null && (Capacity.UNLIMITED.equals(weightCap) || (double)(aFloat.floatValue() + this.getContainedWeight(aPC).floatValue()) <= weightCap.doubleValue());
    }

    private boolean checkContainerCapacity(SortedSet<String> aTypeList, Float aQuant) {
        return Capacity.ANY.equals(this.get(ObjectKey.TOTAL_CAPACITY)) || !"".equals(this.pickChildType(aTypeList, aQuant));
    }

    private List<EquipmentModifier> cloneEqModList(Equipment other, boolean primary) {
        ArrayList<EquipmentModifier> clonedList = new ArrayList<EquipmentModifier>();
        for (EquipmentModifier eqMod : this.getEqModifierList(primary)) {
            if (eqMod.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                EquipmentModifier newEqMod = eqMod.clone();
                other.assocSupt.convertAssociations(eqMod, newEqMod);
                eqMod = newEqMod;
            }
            clonedList.add(eqMod);
        }
        return clonedList;
    }

    private boolean containsChildType(String aType) {
        return this.d_childTypes.containsKey(aType);
    }

    private SortedSet<String> eqTypeList() {
        return new TreeSet<String>(this.typeList());
    }

    private static void extractListFromCommon(List<EquipmentModifier> commonList, List<EquipmentModifier> extractList) {
        for (int i = extractList.size() - 1; i >= 0; --i) {
            EquipmentModifier eqMod = extractList.get(i);
            if (!eqMod.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) continue;
            commonList.add(0, eqMod);
            extractList.remove(i);
        }
    }

    private BigDecimal evaluateCost(PJEP myParser, String costExpr) {
        Object result;
        myParser.parseExpression(costExpr);
        if (!myParser.hasError() && (result = myParser.getValueAsObject()) != null) {
            return new BigDecimal(result.toString());
        }
        Logging.errorPrint("Bad equipment cost expression: " + costExpr);
        return BigDecimal.ZERO;
    }

    private boolean ignoresCostDouble() {
        boolean noDouble = false;
        if (this.isType("MANTLE") || this.isType("POTION") || this.isType("SCROLL") || this.isType("STAFF") || this.isType("WAND")) {
            noDouble = true;
        }
        return noDouble;
    }

    private String pickChildType(SortedSet<String> aTypeList, Float quantToAdd) {
        BigDecimal capValue;
        Capacity totalCap = this.get(ObjectKey.TOTAL_CAPACITY);
        BigDecimal bigDecimal = capValue = totalCap == null ? BigDecimal.ZERO : totalCap.getCapacity();
        if (this.getChildType("Total") == null) {
            this.setChildType("Total", Float.valueOf(0.0f));
        }
        String canContain = "";
        if ((double)(this.getChildType("Total").floatValue() + quantToAdd.floatValue()) <= capValue.doubleValue()) {
            boolean anyContain = false;
            float childType = this.containsChildType("Any") ? this.getChildType("Any").floatValue() : 0.0f;
            block0: for (Capacity c : this.getSafeListFor(ListKey.CAPACITY)) {
                String capType = c.getType();
                double val = c.getCapacity().doubleValue();
                for (String aType : aTypeList) {
                    if (capType.equalsIgnoreCase(aType)) {
                        if (!(this.containsChildType(aType) && (double)(this.getChildType(aType).floatValue() + quantToAdd.floatValue()) <= val) && !((double)quantToAdd.floatValue() <= val)) continue;
                        canContain = aType;
                        break block0;
                    }
                    if (!"Any".equalsIgnoreCase(capType) || !((double)(childType + quantToAdd.floatValue()) <= val)) continue;
                    anyContain = true;
                }
            }
            if ("".equals(canContain) && anyContain) {
                if (!this.containsChildType("Any")) {
                    this.setChildType("Any", Float.valueOf(0.0f));
                }
                canContain = "Any";
            }
        }
        return canContain;
    }

    private void removeCommonFromList(List<EquipmentModifier> altList, List<EquipmentModifier> commonList, String errMsg) {
        for (int i = altList.size() - 1; i >= 0; --i) {
            EquipmentModifier eqMod = altList.get(i);
            if (!eqMod.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) continue;
            int j = commonList.indexOf(eqMod);
            if (j >= 0) {
                altList.remove(i);
                continue;
            }
            Logging.errorPrint(errMsg + eqMod.getDisplayName());
        }
    }

    private List<List<EquipmentModifier>> initSplitModList() {
        ArrayList<List<EquipmentModifier>> modListArray = new ArrayList<List<EquipmentModifier>>();
        for (int i = 0; i < EqModFormatCat.values().length; ++i) {
            modListArray.add(new ArrayList());
        }
        return modListArray;
    }

    private void splitModListByFormatCat(List<EquipmentModifier> modList, List<List<EquipmentModifier>> splitModList) {
        for (EquipmentModifier aModList : modList) {
            int o = aModList.getSafe(ObjectKey.FORMAT).ordinal();
            splitModList.get(o).add(aModList);
        }
    }

    private void removeContainedEquipment(int i) {
        this.d_containedEquipment.remove(i);
    }

    private void removeEqModifier(String aString, boolean bPrimary, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String eqModKey = aTok.nextToken();
        EquipmentModifier eqMod = this.getEqModifierKeyed(eqModKey, bPrimary);
        if (eqMod == null) {
            return;
        }
        while (aTok.hasMoreTokens()) {
            String x = aTok.nextToken().replace('=', '|');
            for (String aChoice : this.getAssociationList(eqMod)) {
                if (!aChoice.startsWith(x)) continue;
                this.removeAssociation(eqMod, aChoice);
            }
        }
        if (!this.hasAssociations(eqMod)) {
            this.removeEqModifier(eqMod, bPrimary, aPC);
        }
    }

    private List<String> typeList(boolean bPrimary) {
        if (bPrimary && this.usePrimaryCache) {
            return this.typeListCachePrimary;
        }
        if (!bPrimary && this.useSecondaryCache) {
            return this.typeListCacheSecondary;
        }
        List<Type> initializingList = this.getEquipmentHead(2).getListFor(ListKey.TYPE);
        if (bPrimary || initializingList == null || initializingList.isEmpty()) {
            initializingList = this.getTrueTypeList(false);
        } else if (!this.isDouble()) {
            return new ArrayList<String>();
        }
        LinkedHashSet<Object> calculatedTypeList = new LinkedHashSet<String>();
        if (initializingList != null) {
            for (Type t : initializingList) {
                calculatedTypeList.add(t.getComparisonString());
            }
        }
        ArrayList<String> modTypeList = new ArrayList<String>();
        EquipmentModifier aEqMod = this.getEqModifierKeyed("ADDTYPE", bPrimary);
        if (aEqMod != null) {
            for (String aType : this.getAssociationList(aEqMod)) {
                if (calculatedTypeList.contains(aType = aType.toUpperCase())) continue;
                modTypeList.add(aType);
            }
        }
        List<EquipmentModifier> eqModList = this.getEqModifierList(bPrimary);
        for (EquipmentModifier eqMod : eqModList) {
            LinkedHashSet<String> newTypeList = new LinkedHashSet<String>(calculatedTypeList);
            for (ChangeArmorType cat : eqMod.getSafeListFor(ListKey.ARMORTYPE)) {
                List<String> tempTypeList = cat.applyProcessor(newTypeList);
                LinkedHashSet<String> tempTypeSet = new LinkedHashSet<String>(tempTypeList);
                boolean noMatch = newTypeList.size() != tempTypeList.size() || newTypeList.equals(tempTypeSet);
                newTypeList = tempTypeSet;
                if (noMatch) continue;
                break;
            }
            ArrayList removedTypeList = new ArrayList(calculatedTypeList);
            removedTypeList.removeAll(newTypeList);
            modTypeList.removeAll(removedTypeList);
            calculatedTypeList = newTypeList;
            for (String aType : eqMod.getSafeListFor(ListKey.ITEM_TYPES)) {
                aType = aType.toUpperCase();
                if (calculatedTypeList.contains("BOTH") && calculatedTypeList.contains("MELEE") && ("RANGED".equals(aType) || "THROWN".equals(aType)) || calculatedTypeList.contains(aType) || modTypeList.contains(aType)) continue;
                modTypeList.add(aType);
            }
        }
        calculatedTypeList.addAll(modTypeList);
        ArrayList<String> resultingTypeList = new ArrayList<String>(calculatedTypeList);
        int idx = resultingTypeList.indexOf("MAGIC");
        if (idx > 0) {
            resultingTypeList.remove(idx);
            resultingTypeList.add(0, "MAGIC");
        }
        if (bPrimary) {
            this.typeListCachePrimary = resultingTypeList;
            this.usePrimaryCache = true;
        } else {
            this.typeListCacheSecondary = resultingTypeList;
            this.useSecondaryCache = true;
        }
        return resultingTypeList;
    }

    private void updateContainerCapacityString() {
        List<Capacity> capacity;
        StringBuilder tempStringBuilder = new StringBuilder(100);
        boolean comma = false;
        BigDecimal weightCap = this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY);
        if (weightCap != null && !Capacity.UNLIMITED.equals(weightCap)) {
            tempStringBuilder.append(weightCap).append(' ').append(Globals.getGameModeUnitSet().getWeightUnit());
            comma = true;
        }
        if ((capacity = this.getListFor(ListKey.CAPACITY)) != null) {
            for (Capacity c : capacity) {
                BigDecimal capValue;
                if (comma) {
                    tempStringBuilder.append(", ");
                    comma = false;
                }
                if (!Capacity.UNLIMITED.equals(capValue = c.getCapacity())) {
                    tempStringBuilder.append(capValue).append(' ');
                    tempStringBuilder.append(c.getType());
                    comma = true;
                    continue;
                }
                if (c.getType() == null) continue;
                comma = true;
                tempStringBuilder.append(c.getType());
            }
        }
        this.containerCapacityString = tempStringBuilder.toString();
    }

    @Override
    public void activateBonuses(PlayerCharacter aPC) {
        for (BonusObj bonus : this.getRawBonusList(aPC)) {
            aPC.setApplied(bonus, PrereqHandler.passesAll(bonus.getPrerequisiteList(), this, aPC));
        }
    }

    public boolean isCalculatingCost() {
        return this.calculatingCost;
    }

    public boolean isWeightAlreadyUsed() {
        return this.weightAlreadyUsed;
    }

    public BigDecimal getWeightInPounds() {
        return this.isVirtual() ? BigDecimal.ZERO : this.getSafe(ObjectKey.WEIGHT);
    }

    public void setWeightAlreadyUsed(boolean weightAlreadyUsed) {
        this.weightAlreadyUsed = weightAlreadyUsed;
    }

    public String getNonHeadedName() {
        if (this.wholeItemName == null || this.wholeItemName.length() == 0) {
            return this.getName();
        }
        return this.wholeItemName;
    }

    public String getWholeItemName() {
        return this.wholeItemName;
    }

    public void setWholeItemName(String wholeItemName) {
        this.wholeItemName = wholeItemName;
    }

    public String createKeyForAutoResize(SizeAdjustment newSize) {
        if (newSize == null) {
            return this.getKeyName();
        }
        String displayName = newSize.getDisplayName();
        String finalSize = displayName.toUpperCase().substring(0, 1);
        String thisKey = this.getKeyName();
        if (thisKey.startsWith("AUTOSIZE")) {
            int index = "AUTOSIZE".length();
            String keySize = thisKey.substring(index, index + 1).toUpperCase();
            if (keySize.equals(finalSize)) {
                return thisKey;
            }
            thisKey = thisKey.substring(index + 1);
        }
        return "AUTOSIZE" + finalSize + thisKey;
    }

    public String createNameForAutoResize(SizeAdjustment newSize) {
        if (newSize == null) {
            return this.getName();
        }
        String displayName = newSize.getDisplayName();
        String thisName = this.getName();
        String upName = thisName.toUpperCase();
        SizeAdjustment sa1 = this.getSafe(ObjectKey.SIZE).resolvesTo();
        String upThisSize = sa1.getDisplayName().toUpperCase();
        int start = upName.indexOf(upThisSize);
        int end = start + upThisSize.length();
        if (start > -1 && (upName.substring(start - 1).startsWith("(") || upName.substring(start - 1).startsWith("/")) && (upName.substring(end).startsWith(")") || upName.substring(end).startsWith("/"))) {
            return thisName.substring(0, start) + displayName + thisName.substring(end);
        }
        return thisName + " (" + displayName + ")";
    }

    public void makeVirtual() {
        this.virtualItem = true;
    }

    private boolean isVirtual() {
        return this.virtualItem;
    }

    public String getCritMult() {
        return Equipment.multAsString(this.getCritMultiplier());
    }

    public String getAltCritMult() {
        return Equipment.multAsString(this.getAltCritMultiplier());
    }

    private static String multAsString(int mult) {
        if (mult == 0) {
            return "";
        }
        if (mult < 0) {
            return "-";
        }
        return "x" + Integer.toString(mult);
    }

    public int getCritMultiplier() {
        String cm;
        int mult = this.getHeadInfo(1, IntegerKey.CRIT_MULT);
        if (mult == 0 && (cm = this.getWeaponInfo("CRITMULT", true)).length() != 0) {
            mult = Integer.parseInt(cm);
        }
        return mult;
    }

    public int getAltCritMultiplier() {
        String cm;
        int mult = this.getHeadInfo(2, IntegerKey.CRIT_MULT);
        if (mult == 0 && (cm = this.getWeaponInfo("CRITMULT", false)).length() != 0) {
            mult = Integer.parseInt(cm);
        }
        return mult;
    }

    private int getHeadInfo(int headnum, IntegerKey ik) {
        EquipmentHead head = this.getEquipmentHeadReference(headnum);
        return head == null ? 0 : head.getSafe(ik);
    }

    public boolean isFinessable(PlayerCharacter pc) {
        WieldCategory wCat = this.getEffectiveWieldCategory(pc);
        return this.isType("Finesseable") || wCat != null && wCat.isFinessable();
    }

    public boolean isWeaponLightForPC(PlayerCharacter pc) {
        if (pc == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wc = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, "Light");
        return wc != null && wc.equals(this.getEffectiveWieldCategory(pc));
    }

    public boolean isWeaponOneHanded(PlayerCharacter pc) {
        if (pc == null && !this.isWeapon()) {
            return false;
        }
        WieldCategory wCat = this.getEffectiveWieldCategory(pc);
        return wCat != null && wCat.getHandsRequired() == 1;
    }

    public boolean isWeaponOutsizedForPC(PlayerCharacter pc) {
        if (pc == null || !this.isWeapon()) {
            return true;
        }
        WieldCategory wCat = this.getEffectiveWieldCategory(pc);
        return wCat != null && (wCat.getHandsRequired() > 2 || wCat.getHandsRequired() < 0);
    }

    public boolean isWeaponTooLargeForPC(PlayerCharacter pc) {
        if (pc == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(pc);
        return wieldCategory != null && wieldCategory.getHandsRequired() > 2;
    }

    public boolean isWeaponTwoHanded(PlayerCharacter pc) {
        if (pc == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(pc);
        return wieldCategory != null && wieldCategory.getHandsRequired() == 2;
    }

    public WieldCategory getEffectiveWieldCategory(PlayerCharacter aPC) {
        CDOMSingleRef<WeaponProf> ref = this.get(ObjectKey.WEAPON_PROF);
        WeaponProf wp = ref == null ? null : ref.resolvesTo();
        WieldCategory wCat = this.get(ObjectKey.WIELD);
        if (wCat != null && !Globals.checkRule("SIZEOBJ")) {
            wCat = wCat.adjustForSize(aPC, this);
        } else {
            int sizeDiff;
            int pcSize = aPC.sizeInt();
            if (wp != null) {
                pcSize = (int)((double)pcSize + aPC.getTotalBonusTo("WEAPONPROF=" + wp.getKeyName(), "PCSIZE"));
            }
            wCat = (sizeDiff = wCat != null && Globals.checkRule("SIZEOBJ") ? wCat.getObjectSizeInt(this) - pcSize : this.sizeInt() - pcSize) > 1 ? Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, "TooLarge") : (sizeDiff == 1 ? Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, "TwoHanded") : (sizeDiff == 0 ? Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, "OneHanded") : Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, "Light")));
        }
        int aBump = 0;
        if (wp != null) {
            int iHands = wp.getSafe(IntegerKey.HANDS);
            if (iHands == -1) {
                iHands = aPC.sizeInt() > this.sizeInt() ? 1 : 2;
            }
            while (wCat.getHandsRequired() < iHands) {
                wCat = wCat.getWieldCategoryStep(1);
            }
            String expProfName = wp.getKeyName();
            aBump += (int)aPC.getTotalBonusTo("WEAPONPROF=" + expProfName, "WIELDCATEGORY");
            int modWield = 0;
            for (String eqType : this.typeList()) {
                StringBuilder sB = new StringBuilder("WEAPONPROF=TYPE.");
                sB.append(eqType);
                int i = (int)aPC.getTotalBonusTo(sB.toString(), "WIELDCATEGORY");
                if (i >= modWield) continue;
                modWield = i;
            }
            aBump += modWield;
        }
        if ((aBump += (int)this.bonusTo(aPC, "WEAPON", "WIELDCATEGORY", true)) == 0) {
            return wCat;
        }
        return wCat.getWieldCategoryStep(aBump);
    }

    public Integer getACBonus(PlayerCharacter aPC) {
        int dbon = (int)this.bonusTo(aPC, "COMBAT", "AC", true);
        return dbon += (int)this.bonusTo(aPC, "EQMARMOR", "ACBONUS", true);
    }

    public Integer getACMod(PlayerCharacter aPC) {
        return (int)this.bonusTo(aPC, "EQMARMOR", "AC", true) + (int)this.bonusTo(aPC, "COMBAT", "AC", true);
    }

    public String getDamage(PlayerCharacter aPC) {
        return this.getDamage(aPC, true);
    }

    private String getDamage(PlayerCharacter apc, boolean bPrimary) {
        int headnum = bPrimary ? 1 : 2;
        EquipmentHead head = this.getEquipmentHeadReference(headnum);
        if (head == null) {
            return "";
        }
        String dam = head.get(StringKey.DAMAGE);
        if (!this.isWeapon() || !bPrimary && !this.isDouble()) {
            return dam == null ? "" : dam;
        }
        if (bPrimary && dam == null) {
            EquipmentHead altHead = this.getEquipmentHead(2);
            dam = altHead.get(StringKey.DAMAGE);
        }
        String override = this.get(StringKey.DAMAGE_OVERRIDE);
        if (bPrimary && override != null) {
            dam = override;
        }
        if (dam == null) {
            dam = this.getWeaponInfo("DAMAGE", bPrimary);
        }
        int iSize = this.sizeInt();
        int iMod = iSize + (int)this.bonusTo(apc, "EQMWEAPON", "DAMAGESIZE", bPrimary);
        AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
        if ((iMod += (int)this.bonusTo(apc, "WEAPON", "DAMAGESIZE", bPrimary)) < 0) {
            iMod = 0;
        } else {
            int maxIndex = ref.getConstructedObjectCount(SizeAdjustment.class) - 1;
            if (iMod > maxIndex) {
                iMod = maxIndex;
            }
        }
        SizeAdjustment sa = ref.getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(iMod);
        return this.adjustDamage(dam, sa);
    }

    public String getAltDamage(PlayerCharacter aPC) {
        return this.getDamage(aPC, false);
    }

    public int getBonusToDamage(PlayerCharacter aPC, boolean bPrimary) {
        return (int)this.bonusTo(aPC, "WEAPON", "DAMAGE", bPrimary);
    }

    public int getBonusToHit(PlayerCharacter aPC, boolean bPrimary) {
        return (int)this.bonusTo(aPC, "WEAPON", "TOHIT", bPrimary);
    }

    public void setCarried(Float argCarried) {
        this.carried = argCarried;
    }

    public Float getCarried() {
        return this.carried;
    }

    public boolean isEquipped() {
        return this.equipped;
    }

    private Object getChild(int childIndex) {
        return this.getContainedEquipment(childIndex);
    }

    public int getChildCount() {
        return this.getContainedEquipmentCount();
    }

    private void setChildType(String aType, Float quantity) {
        this.d_childTypes.put(aType, quantity);
    }

    public Equipment getContainedByIndex(int index) {
        ArrayList<Equipment> contents = new ArrayList<Equipment>(this.getContents());
        if (contents.size() > 0 && index <= contents.size()) {
            return (Equipment)contents.get(index);
        }
        return null;
    }

    public Equipment getContainedEquipment(int i) {
        return this.d_containedEquipment.get(i);
    }

    public int getContainedEquipmentCount() {
        return this.d_containedEquipment.size();
    }

    public double getContainedValue(PlayerCharacter aPC) {
        double total = 0.0;
        if (this.getChildCount() == 0) {
            return total;
        }
        for (int e = 0; e < this.getContainedEquipmentCount(); ++e) {
            Equipment anEquip = this.getContainedEquipment(e);
            if (anEquip.getContainedEquipmentCount() > 0) {
                total += anEquip.getContainedValue(aPC);
                continue;
            }
            total += (double)anEquip.getCost(aPC).floatValue();
        }
        return total;
    }

    public Float getContainedWeight(PlayerCharacter aPC) {
        return this.getContainedWeight(aPC, false);
    }

    public Float getBaseContainedWeight() {
        return this.getBaseContainedWeight(false);
    }

    private Float getBaseContainedWeight(boolean effective) {
        Float total = Float.valueOf(0.0f);
        if (this.getSafe(ObjectKey.CONTAINER_CONSTANT_WEIGHT).booleanValue() && !effective || this.getChildCount() == 0) {
            return total;
        }
        for (int e = 0; e < this.getContainedEquipmentCount(); ++e) {
            Equipment anEquip = this.getContainedEquipment(e);
            total = anEquip.getContainedEquipmentCount() > 0 ? Float.valueOf(total.floatValue() + anEquip.getBaseWeight().floatValue() + anEquip.getBaseContainedWeight().floatValue()) : Float.valueOf(total.floatValue() + anEquip.getBaseWeight().floatValue() * anEquip.getCarried().floatValue());
        }
        Integer crw = this.get(IntegerKey.CONTAINER_REDUCE_WEIGHT);
        if (crw != null && crw != 0) {
            total = Float.valueOf(total.floatValue() * (crw.floatValue() / 100.0f));
        }
        return total;
    }

    public Float getContainedWeight(PlayerCharacter aPC, boolean effective) {
        Float total = Float.valueOf(0.0f);
        if (this.getSafe(ObjectKey.CONTAINER_CONSTANT_WEIGHT).booleanValue() && !effective || this.getChildCount() == 0) {
            return total;
        }
        for (int e = 0; e < this.getContainedEquipmentCount(); ++e) {
            Equipment anEquip = this.getContainedEquipment(e);
            total = anEquip.getContainedEquipmentCount() > 0 ? new Float((double)total.floatValue() + anEquip.getWeightAsDouble(aPC) + (double)anEquip.getContainedWeight(aPC).floatValue()) : new Float((double)total.floatValue() + anEquip.getWeightAsDouble(aPC) * (double)anEquip.getQty().floatValue());
        }
        Integer crw = this.get(IntegerKey.CONTAINER_REDUCE_WEIGHT);
        if (crw != null && crw != 0) {
            total = Float.valueOf(total.floatValue() * (crw.floatValue() / 100.0f));
        }
        return total;
    }

    public String getContainerByType(String aType, String aSubTag) {
        int typeIndex;
        String type;
        ArrayList<Equipment> contents = new ArrayList<Equipment>(this.getContents());
        int numCharToRemove = 0;
        for (int i = aType.length() - 1; i > 0 && aType.charAt(i) >= '0' && aType.charAt(i) <= '9'; --i) {
            ++numCharToRemove;
        }
        if (numCharToRemove > 0) {
            int l = aType.length() - numCharToRemove;
            type = aType.substring(0, l);
            typeIndex = Integer.parseInt(aType.substring(l));
        } else {
            type = aType;
            typeIndex = -1;
        }
        for (Equipment eq : contents) {
            if (eq.isType(type)) continue;
            contents.remove(eq);
        }
        if (typeIndex < contents.size()) {
            if ("SPROP".equals(aSubTag)) {
                return ((Equipment)contents.get(typeIndex)).getRawSpecialProperties();
            }
            return ((Equipment)contents.get(typeIndex)).getName();
        }
        return " ";
    }

    public String getContainerContentsString() {
        if (this.containerContentsString == null) {
            this.updateContainerContentsString(null);
        }
        return this.containerContentsString;
    }

    public Collection<Equipment> getContents() {
        ArrayList<Equipment> contents = new ArrayList<Equipment>();
        for (int it = 0; it < this.getContainedEquipmentCount(); ++it) {
            Equipment aEquip = this.getContainedEquipment(it);
            contents.add(aEquip);
        }
        return contents;
    }

    public String getContainerCapacityString() {
        if (this.containerCapacityString == null) {
            this.updateContainerCapacityString();
        }
        return this.containerCapacityString;
    }

    public boolean isContainer() {
        return this.acceptsChildren();
    }

    public EquipmentHead getEquipmentHead(int index) {
        EquipmentHead head;
        if (index <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int headsIndex = index - 1;
        int currentSize = this.heads.size();
        if (headsIndex >= currentSize) {
            for (int i = 0; i < headsIndex - currentSize; ++i) {
                this.heads.add(null);
            }
            head = new EquipmentHead(this, index);
            this.heads.add(head);
        } else {
            head = this.heads.get(headsIndex);
            if (head == null) {
                head = new EquipmentHead(this, index);
                this.heads.set(headsIndex, head);
            }
        }
        return head;
    }

    public EquipmentHead getEquipmentHeadReference(int index) {
        if (index <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index <= this.heads.size()) {
            return this.heads.get(index - 1);
        }
        return null;
    }

    private String adjustDamage(String aDamage, SizeAdjustment aSize) {
        if (aDamage == null) {
            return null;
        }
        if (!"special".equalsIgnoreCase(aDamage) && !"-".equals(aDamage)) {
            return Globals.adjustDamage(aDamage, this.getSafe(ObjectKey.SIZE).resolvesTo(), aSize);
        }
        return aDamage;
    }

    private String getDamageAdjustedForSize(SizeAdjustment aSize, boolean bPrimary) {
        int headnum = bPrimary ? 1 : 2;
        EquipmentHead head = this.getEquipmentHeadReference(headnum);
        if (head == null) {
            return null;
        }
        String dam = head.get(StringKey.DAMAGE);
        if (!this.isWeapon() || !bPrimary && !this.isDouble()) {
            return dam;
        }
        if (dam == null) {
            dam = this.getWeaponInfo("DAMAGE", bPrimary);
        }
        return this.adjustDamage(dam, aSize);
    }

    public Integer getRange(PlayerCharacter pc) {
        String aRange;
        int range = this.getSafe(IntegerKey.RANGE);
        if (range == 0 && (aRange = this.getWeaponInfo("RANGE", true)).length() != 0) {
            range = Integer.valueOf(aRange);
        }
        int r = range + (int)this.bonusTo(pc, "EQMWEAPON", "RANGEADD", true);
        int i = (int)this.bonusTo(pc, "EQMWEAPON", "RANGEMULT", true);
        double rangeMult = 1.0;
        if (i > 0) {
            rangeMult += (double)(i - 1);
        }
        int postAdd = 0;
        if (pc != null) {
            if (this.isThrown()) {
                r += (int)pc.getTotalBonusTo("RANGEADD", "THROWN");
                postAdd = (int)pc.getTotalBonusTo("POSTRANGEADD", "THROWN");
                rangeMult += (double)((int)pc.getTotalBonusTo("RANGEMULT", "THROWN")) / 100.0;
            } else if (this.isProjectile()) {
                r += (int)pc.getTotalBonusTo("RANGEADD", "PROJECTILE");
                postAdd = (int)pc.getTotalBonusTo("POSTRANGEADD", "PROJECTILE");
                rangeMult += (double)((int)pc.getTotalBonusTo("RANGEMULT", "PROJECTILE")) / 100.0;
            }
        }
        r = (int)((double)r * rangeMult);
        return r += postAdd;
    }

    private String getWeaponInfo(String infoType, boolean bPrimary) {
        String it = infoType + "|";
        EquipmentModifier eqMod = this.getEqModifierKeyed("PCGENi_WEAPON", bPrimary);
        if (eqMod != null) {
            for (String aString : this.getAssociationList(eqMod)) {
                if (!aString.startsWith(it)) continue;
                return aString.substring(it.length());
            }
        }
        return "";
    }

    public ShieldProf getShieldProf() {
        if (this.isShield()) {
            CDOMSingleRef<ShieldProf> ref = this.get(ObjectKey.SHIELD_PROF);
            if (ref == null) {
                ShieldProf sp = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(ShieldProf.class, this.getKeyName());
                if (sp == null) {
                    return Globals.getContext().getReferenceContext().constructCDOMObject(ShieldProf.class, this.getKeyName());
                }
                return sp;
            }
            return ref.resolvesTo();
        }
        return null;
    }

    public ArmorProf getArmorProf() {
        if (this.isArmor()) {
            CDOMSingleRef<ArmorProf> ref = this.get(ObjectKey.ARMOR_PROF);
            if (ref == null) {
                ArmorProf ap = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(ArmorProf.class, this.getKeyName());
                if (ap == null) {
                    return Globals.getContext().getReferenceContext().constructCDOMObject(ArmorProf.class, this.getKeyName());
                }
                return ap;
            }
            return ref.resolvesTo();
        }
        return null;
    }

    public void addAssociation(CDOMObject obj, String o) {
        this.assocSupt.addAssoc(obj, AssociationListKey.CHOICES, new FixedStringList(new String[]{o}));
    }

    public boolean containsAssociated(CDOMObject obj, String o) {
        List<FixedStringList> list = this.assocSupt.getAssocList(obj, AssociationListKey.CHOICES);
        if (list != null) {
            for (FixedStringList fsl : list) {
                if (FixedStringList.CASE_INSENSITIVE_ORDER.compare(fsl, new FixedStringList(new String[]{o})) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getSelectCorrectedAssociationCount(CDOMObject obj) {
        Formula f = obj.getSafe(FormulaKey.SELECT);
        int select = f.resolve(this, true, null, "").intValue();
        return this.assocSupt.getAssocCount(obj, AssociationListKey.CHOICES) / select;
    }

    public List<String> getAssociationList(CDOMObject obj) {
        ArrayList<String> list = new ArrayList<String>();
        List<FixedStringList> assocList = this.assocSupt.getAssocList(obj, AssociationListKey.CHOICES);
        if (assocList != null) {
            for (FixedStringList ac : assocList) {
                String choiceStr = ac.get(0);
                if ("".equals(choiceStr)) {
                    list.add(null);
                    continue;
                }
                list.add(choiceStr);
            }
        }
        return list;
    }

    public boolean hasAssociations(Object obj) {
        return this.assocSupt.hasAssocs(obj, AssociationListKey.CHOICES);
    }

    public List<String> removeAllAssociations(CDOMObject obj) {
        List<String> list = this.getAssociationList(obj);
        this.assocSupt.removeAllAssocs(obj, AssociationListKey.CHOICES);
        return list;
    }

    public void removeAssociation(CDOMObject obj, String o) {
        this.assocSupt.removeAssoc(obj, AssociationListKey.CHOICES, new FixedStringList(new String[]{o}));
    }

    public String getFirstAssociation(CDOMObject obj) {
        return this.assocSupt.getAssocList(obj, AssociationListKey.CHOICES).get(0).get(0);
    }

    public Map<String, String> getBonusMap() {
        if (this.bonusMap == null) {
            this.bonusMap = new HashMap<String, String>();
        }
        return this.bonusMap;
    }

    private void putBonusMap(String aKey, String aVal) {
        this.getBonusMap().put(aKey, aVal);
    }

    public void setBonusStackFor(double bonus, String aType) {
        StringTokenizer aTok;
        String bType = aType != null ? aType.toUpperCase() : null;
        int index = -1;
        if (aType != null && (aTok = new StringTokenizer(bType, ".")).countTokens() >= 2) {
            aTok.nextToken();
            String aString = aTok.nextToken();
            String nextTok = null;
            if ("BASE".equals(aString)) {
                if (aTok.hasMoreTokens()) {
                    aTok.nextToken();
                }
                if (aTok.hasMoreTokens()) {
                    nextTok = aTok.nextToken();
                }
            } else if (aTok.hasMoreTokens()) {
                nextTok = aTok.nextToken();
            }
            if (nextTok != null) {
                index = SettingsHandler.getGame().getUnmodifiableBonusStackList().indexOf(nextTok);
            }
            if (nextTok == null) {
                index = 1;
            } else if ("NULL".equals(nextTok)) {
                index = 1;
            }
        }
        if (bType != null && (bType.endsWith(".STACK") || bType.endsWith(".REPLACE"))) {
            index = 1;
        }
        if (bonus < 0.0) {
            index = 1;
        }
        if (index == -1) {
            String aVal = this.getBonusMap().get(bType);
            if (aVal == null) {
                this.putBonusMap(bType, String.valueOf(bonus));
            } else {
                this.putBonusMap(bType, String.valueOf(Math.max(bonus, (double)Float.parseFloat(aVal))));
            }
        } else {
            String type = bType == null ? "" : (bType.endsWith(".REPLACE.STACK") ? bType.substring(0, bType.length() - 6) : bType);
            String aVal = this.getBonusMap().get(type);
            if (aVal == null) {
                this.putBonusMap(type, String.valueOf(bonus));
            } else {
                this.putBonusMap(type, String.valueOf(bonus + (double)Float.parseFloat(aVal)));
            }
        }
    }

    private void dumpTypeCache() {
        this.usePrimaryCache = false;
        this.useSecondaryCache = false;
    }

    public void addType(Type newType) {
        this.addToListFor(ListKey.TYPE, newType);
        this.dumpTypeCache();
    }

    public void removeType(Type t) {
        while (this.removeFromListFor(ListKey.TYPE, t)) {
        }
        this.dumpTypeCache();
    }

    public void addWeaponToLocation(Float num, EquipmentLocation eLoc, PlayerCharacter aPC) {
        Float numEquipped = Float.valueOf(eLoc == EquipmentLocation.EQUIPPED_TWO_HANDS ? 2.0f : num.floatValue());
        this.setNumberEquipped(numEquipped.intValue());
        this.setLocation(eLoc);
        if (eLoc != EquipmentLocation.EQUIPPED_NEITHER) {
            this.setQty(num);
            this.setNumberCarried(num);
            this.setIsEquipped(true, aPC);
        }
    }

    public void addEquipmentToLocation(Float num, EquipmentLocation eLoc, boolean equip, PlayerCharacter aPC) {
        this.setLocation(eLoc);
        this.setQty(num);
        this.setIsEquipped(equip, aPC);
        Float numCarried = Float.valueOf(eLoc == EquipmentLocation.NOT_CARRIED ? 0.0f : num.floatValue());
        this.setNumberCarried(numCarried);
    }

    public List<BonusObj> getTempBonusList() {
        return this.getSafeListFor(ListKey.TEMP_BONUS);
    }

    public void addTempBonus(BonusObj aBonus) {
        this.addToListFor(ListKey.TEMP_BONUS, aBonus);
    }

    public void removeTempBonus(BonusObj aBonus) {
        this.removeFromListFor(ListKey.TEMP_BONUS, aBonus);
    }

    public void resetTempBonusList() {
        this.removeListFor(ListKey.TEMP_BONUS);
    }

    public boolean hasBonusWithInfo(PlayerCharacter pc, String aString) {
        for (BonusObj bonus : this.getRawBonusList(pc)) {
            if (!bonus.getBonusInfo().equalsIgnoreCase(aString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getTypes() {
        String type = this.getType();
        return type.split("\\.");
    }

    @Override
    public List<String> getTypesForDisplay() {
        List<Type> trueTypeList = this.getTrueTypeList(true);
        ArrayList<String> result = new ArrayList<String>(trueTypeList.size());
        for (Type type : trueTypeList) {
            result.add(type.toString());
        }
        return result;
    }

    @Override
    public File getIcon() {
        URI uri = this.get(ObjectKey.ICON_URI);
        if (uri != null) {
            return new File(uri);
        }
        GameMode game = SettingsHandler.getGame();
        List<String> typeList = this.typeList(true);
        String iconPath = null;
        int iconPriority = 0;
        for (String type : typeList) {
            String path = game.getEquipTypeIcon(type);
            if (path == null) continue;
            int priority = game.getEquipTypeIconPriority(type);
            if (iconPath != null && priority < iconPriority) continue;
            iconPath = path;
            iconPriority = priority;
        }
        if (iconPath != null) {
            return new File(iconPath);
        }
        String path = game.getEquipTypeIcon("Default");
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    private static class EquipmentHeadCostSummary {
        BigDecimal postSizeCost = BigDecimal.ZERO;
        BigDecimal nonDoubleCost = BigDecimal.ZERO;
        int headPlus = 0;

        private EquipmentHeadCostSummary() {
        }
    }
}

