/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.util.enumeration.ProhibitedSpellType;

public class SpellProhibitor
extends ConcretePrereqObject {
    private ProhibitedSpellType type = null;
    private List<String> valueList = null;

    public ProhibitedSpellType getType() {
        return this.type;
    }

    public List<String> getValueList() {
        return this.valueList;
    }

    public void setType(ProhibitedSpellType prohibitedType) {
        this.type = prohibitedType;
    }

    public void addValue(String value) {
        if (this.valueList == null) {
            this.valueList = new ArrayList<String>();
        }
        this.valueList.add(value);
    }

    public boolean isProhibited(Spell s, PlayerCharacter aPC, CDOMObject owner) {
        if (this.type.equals((Object)ProhibitedSpellType.ALIGNMENT) && !Globals.checkRule("PROHIBITSPELLS")) {
            return false;
        }
        if (!this.qualifies(aPC, owner)) {
            return false;
        }
        int hits = 0;
        for (String typeDesc : this.type.getCheckList(s)) {
            for (String prohib : this.valueList) {
                if (!prohib.equalsIgnoreCase(typeDesc)) continue;
                ++hits;
            }
        }
        return hits == this.type.getRequiredCount(this.valueList);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.valueList.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpellProhibitor)) {
            return false;
        }
        SpellProhibitor other = (SpellProhibitor)o;
        if (this.type == null && other.type == null || this.type != null && this.type.equals((Object)other.type)) {
            return other.valueList == null && this.valueList == null || this.valueList != null && this.valueList.equals(other.valueList);
        }
        return false;
    }
}

