/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.display;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.base.math.OrderedPair;
import pcgen.base.util.NamedValue;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.Handed;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.facet.ActiveSpellsFacet;
import pcgen.cdom.facet.AutoLanguageGrantedFacet;
import pcgen.cdom.facet.AutoLanguageUnconditionalFacet;
import pcgen.cdom.facet.DamageReductionFacet;
import pcgen.cdom.facet.EquipSetFacet;
import pcgen.cdom.facet.EquipmentFacet;
import pcgen.cdom.facet.EquippedEquipmentFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.HitPointFacet;
import pcgen.cdom.facet.KitFacet;
import pcgen.cdom.facet.LevelInfoFacet;
import pcgen.cdom.facet.MasterFacet;
import pcgen.cdom.facet.NoteItemFacet;
import pcgen.cdom.facet.PrimaryWeaponFacet;
import pcgen.cdom.facet.SecondaryWeaponFacet;
import pcgen.cdom.facet.SkillRankFacet;
import pcgen.cdom.facet.SpellBookFacet;
import pcgen.cdom.facet.SpellListFacet;
import pcgen.cdom.facet.StartingLanguageFacet;
import pcgen.cdom.facet.StatBonusFacet;
import pcgen.cdom.facet.StatCalcFacet;
import pcgen.cdom.facet.StatValueFacet;
import pcgen.cdom.facet.SubClassFacet;
import pcgen.cdom.facet.SubstitutionClassFacet;
import pcgen.cdom.facet.XPTableFacet;
import pcgen.cdom.facet.analysis.AgeSetFacet;
import pcgen.cdom.facet.analysis.ArmorClassFacet;
import pcgen.cdom.facet.analysis.BaseMovementFacet;
import pcgen.cdom.facet.analysis.ChallengeRatingFacet;
import pcgen.cdom.facet.analysis.ChangeProfFacet;
import pcgen.cdom.facet.analysis.FaceFacet;
import pcgen.cdom.facet.analysis.FavoredClassFacet;
import pcgen.cdom.facet.analysis.FollowerOptionFacet;
import pcgen.cdom.facet.analysis.HandsFacet;
import pcgen.cdom.facet.analysis.HasAnyFavoredClassFacet;
import pcgen.cdom.facet.analysis.InitiativeFacet;
import pcgen.cdom.facet.analysis.LegsFacet;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.analysis.LevelTableFacet;
import pcgen.cdom.facet.analysis.LoadFacet;
import pcgen.cdom.facet.analysis.MovementResultFacet;
import pcgen.cdom.facet.analysis.MultiClassFacet;
import pcgen.cdom.facet.analysis.NonAbilityFacet;
import pcgen.cdom.facet.analysis.NonProficiencyPenaltyFacet;
import pcgen.cdom.facet.analysis.RaceTypeFacet;
import pcgen.cdom.facet.analysis.RacialSubTypesFacet;
import pcgen.cdom.facet.analysis.ReachFacet;
import pcgen.cdom.facet.analysis.SpecialAbilityFacet;
import pcgen.cdom.facet.analysis.SubRaceFacet;
import pcgen.cdom.facet.analysis.TotalWeightFacet;
import pcgen.cdom.facet.analysis.UnarmedDamageFacet;
import pcgen.cdom.facet.analysis.VisionFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.fact.AgeFacet;
import pcgen.cdom.facet.fact.CharacterTypeFacet;
import pcgen.cdom.facet.fact.ChronicleEntryFacet;
import pcgen.cdom.facet.fact.FactFacet;
import pcgen.cdom.facet.fact.FollowerFacet;
import pcgen.cdom.facet.fact.GenderFacet;
import pcgen.cdom.facet.fact.HandedFacet;
import pcgen.cdom.facet.fact.HeightFacet;
import pcgen.cdom.facet.fact.PortraitThumbnailRectFacet;
import pcgen.cdom.facet.fact.PreviewSheetFacet;
import pcgen.cdom.facet.fact.RegionFacet;
import pcgen.cdom.facet.fact.SkillFilterFacet;
import pcgen.cdom.facet.fact.SuppressBioFieldFacet;
import pcgen.cdom.facet.fact.WeightFacet;
import pcgen.cdom.facet.fact.XPFacet;
import pcgen.cdom.facet.input.ProhibitedSchoolFacet;
import pcgen.cdom.facet.input.UserSpecialAbilityFacet;
import pcgen.cdom.facet.model.AlignmentFacet;
import pcgen.cdom.facet.model.ArmorProfProviderFacet;
import pcgen.cdom.facet.model.BioSetFacet;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.DeityFacet;
import pcgen.cdom.facet.model.DomainFacet;
import pcgen.cdom.facet.model.LanguageFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.ShieldProfProviderFacet;
import pcgen.cdom.facet.model.SizeFacet;
import pcgen.cdom.facet.model.SkillFacet;
import pcgen.cdom.facet.model.StatFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.cdom.facet.model.WeaponProfModelFacet;
import pcgen.cdom.helper.ProfProvider;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.AgeSet;
import pcgen.core.ArmorProf;
import pcgen.core.BioSet;
import pcgen.core.ChronicleEntry;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.FollowerOption;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.Movement;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.core.Vision;
import pcgen.core.WeaponProf;
import pcgen.core.XPTable;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.VisionType;

public class CharacterDisplay {
    private final CharID id;
    private FactFacet factFacet = FacetLibrary.getFacet(FactFacet.class);
    private LevelFacet levelFacet = FacetLibrary.getFacet(LevelFacet.class);
    private RaceTypeFacet raceTypeFacet = FacetLibrary.getFacet(RaceTypeFacet.class);
    private RegionFacet regionFacet = FacetLibrary.getFacet(RegionFacet.class);
    private SpellBookFacet spellBookFacet = FacetLibrary.getFacet(SpellBookFacet.class);
    private ChronicleEntryFacet chronicleEntryFacet = FacetLibrary.getFacet(ChronicleEntryFacet.class);
    private AgeSetFacet ageSetFacet = FacetLibrary.getFacet(AgeSetFacet.class);
    private ActiveSpellsFacet activeSpellsFacet = FacetLibrary.getFacet(ActiveSpellsFacet.class);
    private SuppressBioFieldFacet suppressBioFieldFacet = FacetLibrary.getFacet(SuppressBioFieldFacet.class);
    private TemplateFacet templateFacet = FacetLibrary.getFacet(TemplateFacet.class);
    private VisionFacet visionFacet = FacetLibrary.getFacet(VisionFacet.class);
    private FormulaResolvingFacet formulaResolvingFacet = FacetLibrary.getFacet(FormulaResolvingFacet.class);
    private ArmorClassFacet armorClassFacet = FacetLibrary.getFacet(ArmorClassFacet.class);
    private AgeFacet ageFacet = FacetLibrary.getFacet(AgeFacet.class);
    private MovementResultFacet moveResultFacet = FacetLibrary.getFacet(MovementResultFacet.class);
    private RaceFacet raceFacet = FacetLibrary.getFacet(RaceFacet.class);
    private CharacterTypeFacet characterTypeFacet = FacetLibrary.getFacet(CharacterTypeFacet.class);
    private ClassFacet classFacet = FacetLibrary.getFacet(ClassFacet.class);
    private SubClassFacet subClassFacet = FacetLibrary.getFacet(SubClassFacet.class);
    private FavoredClassFacet favClassFacet = FacetLibrary.getFacet(FavoredClassFacet.class);
    private HasAnyFavoredClassFacet hasAnyFavoredFacet = FacetLibrary.getFacet(HasAnyFavoredClassFacet.class);
    private StartingLanguageFacet startingLangFacet = FacetLibrary.getFacet(StartingLanguageFacet.class);
    private ChangeProfFacet changeProfFacet = FacetLibrary.getFacet(ChangeProfFacet.class);
    private BioSetFacet bioSetFacet = FacetLibrary.getFacet(BioSetFacet.class);
    private BaseMovementFacet baseMovementFacet = FacetLibrary.getFacet(BaseMovementFacet.class);
    private LegsFacet legsFacet = FacetLibrary.getFacet(LegsFacet.class);
    private StatValueFacet statValueFacet = FacetLibrary.getFacet(StatValueFacet.class);
    private SubstitutionClassFacet substitutionClassFacet = FacetLibrary.getFacet(SubstitutionClassFacet.class);
    private EquippedEquipmentFacet equippedFacet = FacetLibrary.getFacet(EquippedEquipmentFacet.class);
    private ArmorProfProviderFacet armorProfFacet = FacetLibrary.getFacet(ArmorProfProviderFacet.class);
    private SpellListFacet spellListFacet = FacetLibrary.getFacet(SpellListFacet.class);
    private HitPointFacet hitPointFacet = FacetLibrary.getFacet(HitPointFacet.class);
    private FollowerFacet followerFacet = FacetLibrary.getFacet(FollowerFacet.class);
    private GenderFacet genderFacet = FacetLibrary.getFacet(GenderFacet.class);
    private LoadFacet loadFacet = FacetLibrary.getFacet(LoadFacet.class);
    private StatFacet statFacet = FacetLibrary.getFacet(StatFacet.class);
    private ReachFacet reachFacet = FacetLibrary.getFacet(ReachFacet.class);
    private HandsFacet handsFacet = FacetLibrary.getFacet(HandsFacet.class);
    private TotalWeightFacet totalWeightFacet = FacetLibrary.getFacet(TotalWeightFacet.class);
    private MultiClassFacet multiClassFacet = FacetLibrary.getFacet(MultiClassFacet.class);
    private LevelTableFacet levelTableFacet = FacetLibrary.getFacet(LevelTableFacet.class);
    private DamageReductionFacet drFacet = FacetLibrary.getFacet(DamageReductionFacet.class);
    private UnarmedDamageFacet unarmedDamageFacet = FacetLibrary.getFacet(UnarmedDamageFacet.class);
    private StatBonusFacet statBonusFacet = FacetLibrary.getFacet(StatBonusFacet.class);
    private NonAbilityFacet nonAbilityFacet = FacetLibrary.getFacet(NonAbilityFacet.class);
    private LevelInfoFacet levelInfoFacet = FacetLibrary.getFacet(LevelInfoFacet.class);
    private KitFacet kitFacet = FacetLibrary.getFacet(KitFacet.class);
    private AutoLanguageGrantedFacet autoLangGrantedFacet = FacetLibrary.getFacet(AutoLanguageGrantedFacet.class);
    private AutoLanguageUnconditionalFacet autoLangUnconditionalFacet = FacetLibrary.getFacet(AutoLanguageUnconditionalFacet.class);
    private XPTableFacet xpTableFacet = FacetLibrary.getFacet(XPTableFacet.class);
    private XPFacet xpFacet = FacetLibrary.getFacet(XPFacet.class);
    private WeightFacet weightFacet = FacetLibrary.getFacet(WeightFacet.class);
    private NoteItemFacet noteItemFacet = FacetLibrary.getFacet(NoteItemFacet.class);
    private SubRaceFacet subRaceFacet = FacetLibrary.getFacet(SubRaceFacet.class);
    private UserSpecialAbilityFacet userSpecialAbilityFacet = FacetLibrary.getFacet(UserSpecialAbilityFacet.class);
    private SkillRankFacet skillRankFacet = FacetLibrary.getFacet(SkillRankFacet.class);
    private ShieldProfProviderFacet shieldProfFacet = FacetLibrary.getFacet(ShieldProfProviderFacet.class);
    private SpecialAbilityFacet specialAbilityFacet = FacetLibrary.getFacet(SpecialAbilityFacet.class);
    private SecondaryWeaponFacet secondaryWeaponFacet = FacetLibrary.getFacet(SecondaryWeaponFacet.class);
    private PrimaryWeaponFacet primaryWeaponFacet = FacetLibrary.getFacet(PrimaryWeaponFacet.class);
    private NonProficiencyPenaltyFacet nonppFacet = FacetLibrary.getFacet(NonProficiencyPenaltyFacet.class);
    private MasterFacet masterFacet = FacetLibrary.getFacet(MasterFacet.class);
    private FollowerOptionFacet foFacet = FacetLibrary.getFacet(FollowerOptionFacet.class);
    private HeightFacet heightFacet = FacetLibrary.getFacet(HeightFacet.class);
    private StatCalcFacet statCalcFacet = FacetLibrary.getFacet(StatCalcFacet.class);
    private EquipmentFacet equipmentFacet = FacetLibrary.getFacet(EquipmentFacet.class);
    private EquipSetFacet equipSetFacet = FacetLibrary.getFacet(EquipSetFacet.class);
    private AlignmentFacet alignmentFacet = FacetLibrary.getFacet(AlignmentFacet.class);
    private SkillFacet skillFacet = FacetLibrary.getFacet(SkillFacet.class);
    private DomainFacet domainFacet = FacetLibrary.getFacet(DomainFacet.class);
    private ChallengeRatingFacet crFacet = FacetLibrary.getFacet(ChallengeRatingFacet.class);
    private ProhibitedSchoolFacet prohibitedSchoolFacet = FacetLibrary.getFacet(ProhibitedSchoolFacet.class);
    private RacialSubTypesFacet subTypesFacet = FacetLibrary.getFacet(RacialSubTypesFacet.class);
    private SizeFacet sizeFacet = FacetLibrary.getFacet(SizeFacet.class);
    private WeaponProfModelFacet weaponProfFacet = FacetLibrary.getFacet(WeaponProfModelFacet.class);
    private FaceFacet faceFacet = FacetLibrary.getFacet(FaceFacet.class);
    private LanguageFacet languageFacet = FacetLibrary.getFacet(LanguageFacet.class);
    private InitiativeFacet initiativeFacet = FacetLibrary.getFacet(InitiativeFacet.class);
    private HandedFacet handedFacet = FacetLibrary.getFacet(HandedFacet.class);
    private DeityFacet deityFacet = FacetLibrary.getFacet(DeityFacet.class);
    private PortraitThumbnailRectFacet portraitThumbnailRectFacet = FacetLibrary.getFacet(PortraitThumbnailRectFacet.class);
    private PreviewSheetFacet previewSheetFacet = FacetLibrary.getFacet(PreviewSheetFacet.class);
    private SkillFilterFacet skillFilterFacet = FacetLibrary.getFacet(SkillFilterFacet.class);

    public CharacterDisplay(CharID id) {
        this.id = id;
    }

    public String getSafeStringFor(PCStringKey key) {
        String s = this.factFacet.get(this.id, key);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public String getBio() {
        return this.getSafeStringFor(PCStringKey.BIO);
    }

    public String getCatchPhrase() {
        return this.getSafeStringFor(PCStringKey.CATCHPHRASE);
    }

    public String getHanded() {
        return this.getSafeStringFor(PCStringKey.HANDED);
    }

    public String getInterests() {
        return this.getSafeStringFor(PCStringKey.INTERESTS);
    }

    public String getLocation() {
        return this.getSafeStringFor(PCStringKey.LOCATION);
    }

    public String getSpeechTendency() {
        return this.getSafeStringFor(PCStringKey.SPEECHTENDENCY);
    }

    public String getTabName() {
        return this.getSafeStringFor(PCStringKey.TABNAME);
    }

    public String getTrait1() {
        return this.getSafeStringFor(PCStringKey.PERSONALITY1);
    }

    public String getTrait2() {
        return this.getSafeStringFor(PCStringKey.PERSONALITY2);
    }

    public boolean getSuppressBioField(BiographyField field) {
        return this.suppressBioFieldFacet.getSuppressField(this.id, field);
    }

    public Collection<Vision> getVisionList() {
        return this.visionFacet.getActiveVision(this.id);
    }

    public String getRaceType() {
        RaceType rt = this.raceTypeFacet.getRaceType(this.id);
        return rt == null ? "None" : rt.toString();
    }

    public int getTotalLevels() {
        return this.levelFacet.getTotalLevels(this.id);
    }

    public int getTemplateSR(PCTemplate pct, int level, int hitdice) {
        Formula ltReduction;
        String qualifiedKey = pct.getQualifiedKey();
        Formula reduction = pct.getSafe(ObjectKey.SR).getReduction();
        int aSR = this.formulaResolvingFacet.resolve(this.id, reduction, qualifiedKey).intValue();
        for (PCTemplate rlt : pct.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate lt : rlt.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                if (lt.get(IntegerKey.LEVEL) > level) continue;
                Formula ltReduction2 = lt.getSafe(ObjectKey.SR).getReduction();
                int ltSR = this.formulaResolvingFacet.resolve(this.id, ltReduction2, qualifiedKey).intValue();
                aSR = Math.max(aSR, ltSR);
            }
        }
        for (PCTemplate lt : pct.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            if (lt.get(IntegerKey.LEVEL) > level) continue;
            ltReduction = lt.getSafe(ObjectKey.SR).getReduction();
            int ltSR = this.formulaResolvingFacet.resolve(this.id, ltReduction, qualifiedKey).intValue();
            aSR = Math.max(aSR, ltSR);
        }
        for (PCTemplate lt : pct.getSafeListFor(ListKey.HD_TEMPLATES)) {
            if (lt.get(IntegerKey.HD_MAX) > hitdice || lt.get(IntegerKey.HD_MIN) < hitdice) continue;
            ltReduction = lt.getSafe(ObjectKey.SR).getReduction();
            int ltSR = this.formulaResolvingFacet.resolve(this.id, ltReduction, qualifiedKey).intValue();
            aSR = Math.max(aSR, ltSR);
        }
        return aSR;
    }

    @Deprecated
    public List<PCTemplate> getOutputVisibleTemplateList() {
        return this.getVisibleToTemplateList(View.VISIBLE_EXPORT);
    }

    public List<PCTemplate> getDisplayVisibleTemplateList() {
        return this.getVisibleToTemplateList(View.VISIBLE_DISPLAY);
    }

    private List<PCTemplate> getVisibleToTemplateList(View v) {
        ArrayList<PCTemplate> tl = new ArrayList<PCTemplate>();
        TreeSet<Loadable> treeSet = new TreeSet<Loadable>(CDOMObjectUtilities.CDOM_SORTER);
        for (PCTemplate template : this.templateFacet.getSet(this.id)) {
            if (!template.getSafe(ObjectKey.VISIBILITY).isVisibleTo(v)) continue;
            treeSet.add(template);
        }
        tl.addAll(treeSet);
        return tl;
    }

    public String getRegionString() {
        return this.regionFacet.getRegion(this.id);
    }

    public String getSubRegion() {
        return this.regionFacet.getSubRegion(this.id);
    }

    public int getSpellBookCount() {
        return this.spellBookFacet.getCount(this.id);
    }

    public List<String> getSpellBookNames() {
        return new ArrayList<String>(this.spellBookFacet.getBookNames(this.id));
    }

    public SpellBook getSpellBookByName(String name) {
        return this.spellBookFacet.getBookNamed(this.id, name);
    }

    public int calcACOfType(String type) {
        return this.armorClassFacet.calcACOfType(this.id, type);
    }

    public int getAge() {
        return this.ageFacet.getAge(this.id);
    }

    public int getBaseMovement(String moveType, Load load) {
        return this.moveResultFacet.getBaseMovement(this.id, moveType, load);
    }

    public boolean hasMovement(String moveType) {
        return this.moveResultFacet.hasMovement(this.id, moveType);
    }

    public List<NamedValue> getMovementValues() {
        return this.moveResultFacet.getMovementValues(this.id);
    }

    public int getNumberOfMovements() {
        return this.moveResultFacet.countMovementTypes(this.id);
    }

    public Race getRace() {
        return (Race)((AbstractItemFacet)this.raceFacet).get(this.id);
    }

    public String getCharacterType() {
        return (String)((AbstractItemFacet)this.characterTypeFacet).get(this.id);
    }

    public String getPreviewSheet() {
        return (String)this.previewSheetFacet.get(this.id);
    }

    public SkillFilter getSkillFilter() {
        return (SkillFilter)((Object)this.skillFilterFacet.get(this.id));
    }

    public Set<PCClass> getClassSet() {
        return this.classFacet.getSet(this.id);
    }

    public String getSubClassName(PCClass cl) {
        return (String)this.subClassFacet.get(this.id, cl);
    }

    public final int getLevel(PCClass pcc) {
        return this.classFacet.getLevel(this.id, pcc);
    }

    @Deprecated
    public SortedSet<PCClass> getFavoredClasses() {
        TreeSet<Loadable> favored = new TreeSet<Loadable>(CDOMObjectUtilities.CDOM_SORTER);
        favored.addAll(this.favClassFacet.getSet(this.id));
        return favored;
    }

    @Deprecated
    public boolean hasAnyFavoredClass() {
        return this.hasAnyFavoredFacet.contains(this.id, Boolean.TRUE);
    }

    public Collection<Follower> getFollowerList() {
        return this.followerFacet.getSet(this.id);
    }

    public Gender getGenderObject() {
        return this.genderFacet.getGender(this.id);
    }

    @Deprecated
    public Set<Language> getSortedLanguageSet() {
        return new TreeSet<Language>(this.languageFacet.getSet(this.id));
    }

    public int initiativeMod() {
        return this.initiativeFacet.getInitiative(this.id);
    }

    public int initiativeBonus() {
        return this.initiativeFacet.getInitiativeBonus(this.id);
    }

    public Handed getHandedObject() {
        return this.handedFacet.getHanded(this.id);
    }

    public OrderedPair getFace() {
        return this.faceFacet.get(this.id);
    }

    public SortedSet<WeaponProf> getSortedWeaponProfs() {
        return Collections.unmodifiableSortedSet(new TreeSet<WeaponProf>(this.weaponProfFacet.getSet(this.id)));
    }

    public String getSize() {
        return this.sizeFacet.getSizeAbb(this.id);
    }

    @Deprecated
    public String getResidence() {
        return this.getSafeStringFor(PCStringKey.RESIDENCE);
    }

    public Collection<RaceSubType> getRacialSubTypes() {
        return this.subTypesFacet.getRacialSubTypes(this.id);
    }

    public Collection<? extends SpellProhibitor> getProhibitedSchools(Object source) {
        return this.prohibitedSchoolFacet.getSet(this.id, source);
    }

    public String getPortraitPath() {
        return this.getSafeStringFor(PCStringKey.PORTRAIT_PATH);
    }

    public Rectangle getPortraitThumbnailRect() {
        Rectangle rect = (Rectangle)this.portraitThumbnailRectFacet.get(this.id);
        return rect == null ? null : (Rectangle)rect.clone();
    }

    public String getName() {
        return this.getSafeStringFor(PCStringKey.NAME);
    }

    public String getFileName() {
        return this.getSafeStringFor(PCStringKey.FILE_NAME);
    }

    public String getPlayersName() {
        return this.getSafeStringFor(PCStringKey.PLAYERSNAME);
    }

    public Integer calcCR() {
        return this.crFacet.getCR(this.id);
    }

    public Integer calcBaseCR() {
        return this.crFacet.calcRaceCR(this.id);
    }

    public float getBaseHD() {
        return this.crFacet.getBaseHD(this.id);
    }

    public int getXPAward() {
        return this.crFacet.getXPAward(this.id);
    }

    public int getRacialHDSize() {
        int hdSize = 0;
        LevelCommandFactory lcf = this.getRace().get(ObjectKey.MONSTER_CLASS);
        if (lcf != null) {
            hdSize = this.getLevelHitDie(lcf.getPCClass(), 1).getDie();
        }
        return hdSize;
    }

    public Set<Domain> getSortedDomainSet() {
        TreeSet<Loadable> domains = new TreeSet<Loadable>(CDOMObjectUtilities.CDOM_SORTER);
        domains.addAll(this.domainFacet.getSet(this.id));
        return domains;
    }

    public List<Skill> getPartialSkillList(View v) {
        ArrayList<Skill> aList = new ArrayList<Skill>();
        for (Skill po : this.skillFacet.getSet(this.id)) {
            if (!po.getSafe(ObjectKey.VISIBILITY).isVisibleTo(v)) continue;
            aList.add(po);
        }
        return aList;
    }

    public PCAlignment getPCAlignment() {
        return (PCAlignment)((AbstractItemFacet)this.alignmentFacet).get(this.id);
    }

    public ArrayList<PCClass> getClassList() {
        return new ArrayList<PCClass>(this.getClassSet());
    }

    public String getCurrentEquipSetName() {
        return this.getSafeStringFor(PCStringKey.CURRENT_EQUIP_SET_NAME);
    }

    public Deity getDeity() {
        return (Deity)((AbstractItemFacet)this.deityFacet).get(this.id);
    }

    public Collection<EquipSet> getEquipSet() {
        return this.equipSetFacet.getSet(this.id);
    }

    public EquipSet getEquipSetByIdPath(String path) {
        return this.equipSetFacet.getEquipSetByIdPath(this.id, path);
    }

    public Set<Equipment> getEquipmentSet() {
        return this.equipmentFacet.getSet(this.id);
    }

    public int getHeight() {
        return this.heightFacet.getHeight(this.id);
    }

    public Set<Language> getLanguageSet() {
        return this.languageFacet.getSet(this.id);
    }

    public Map<FollowerOption, CDOMObject> getAvailableFollowers(String aType, Comparator<FollowerOption> comp) {
        return this.foFacet.getAvailableFollowers(this.id, aType, comp);
    }

    public Follower getMaster() {
        return (Follower)this.masterFacet.get(this.id);
    }

    public int getNonProficiencyPenalty() {
        return this.nonppFacet.getPenalty(this.id);
    }

    public Collection<Equipment> getPrimaryWeapons() {
        return this.primaryWeaponFacet.getSet(this.id);
    }

    public boolean hasPrimaryWeapons() {
        return !this.primaryWeaponFacet.isEmpty(this.id);
    }

    public boolean hasSecondaryWeapons() {
        return !this.secondaryWeaponFacet.isEmpty(this.id);
    }

    public Collection<Equipment> getSecondaryWeapons() {
        return this.secondaryWeaponFacet.getSet(this.id);
    }

    public Collection<Skill> getSkillSet() {
        return this.skillFacet.getSet(this.id);
    }

    @Deprecated
    public List<SpecialAbility> getResolvedSpecialAbilities(CDOMObject cdo) {
        return this.specialAbilityFacet.getResolved(this.id, cdo);
    }

    @Deprecated
    public List<SpecialAbility> getResolvedUserSpecialAbilities(CDOMObject cdo) {
        return this.userSpecialAbilityFacet.getResolved(this.id, cdo);
    }

    public String getSpellBookNameToAutoAddKnown() {
        return this.getSafeStringFor(PCStringKey.SPELLBOOK_AUTO_ADD_KNOWN);
    }

    public Collection<SpellBook> getSpellBooks() {
        return this.spellBookFacet.getBooks(this.id);
    }

    @Deprecated
    public String getSubRace() {
        return this.subRaceFacet.getSubRace(this.id);
    }

    public Collection<PCTemplate> getTemplateSet() {
        return this.templateFacet.getSet(this.id);
    }

    public int getWeight() {
        return this.weightFacet.getWeight(this.id);
    }

    public int getXP() {
        return this.xpFacet.getXP(this.id);
    }

    public String getXPTableName() {
        return ((XPTable)this.xpTableFacet.get(this.id)).getName();
    }

    public boolean hasWeaponProf(WeaponProf wp) {
        return this.weaponProfFacet.containsProf(this.id, wp);
    }

    public int racialSizeInt() {
        return this.sizeFacet.racialSizeInt(this.id);
    }

    public int getACTotal() {
        return this.armorClassFacet.calcACOfType(this.id, "Total");
    }

    public Set<Language> getAutoLanguages() {
        HashSet<Language> languages = new HashSet<Language>();
        languages.addAll(this.autoLangGrantedFacet.getSet(this.id));
        languages.addAll(this.autoLangUnconditionalFacet.getSet(this.id));
        return languages;
    }

    public int getECL() {
        return this.levelFacet.getECL(this.id);
    }

    public Collection<Kit> getKitInfo() {
        return ((AbstractListFacet)this.kitFacet).getSet(this.id);
    }

    public Collection<PCLevelInfo> getLevelInfo() {
        return this.levelInfoFacet.getSet(this.id);
    }

    public PCLevelInfo getLevelInfo(int index) {
        return this.levelInfoFacet.get(this.id, index);
    }

    public int getLevelInfoSize() {
        return this.levelInfoFacet.getCount(this.id);
    }

    public String getLevelInfoClassKeyName(int idx) {
        if (idx >= 0 && idx < this.getLevelInfoSize()) {
            return this.levelInfoFacet.get(this.id, idx).getClassKeyName();
        }
        return "";
    }

    public int getLevelInfoClassLevel(int idx) {
        if (idx >= 0 && idx < this.getLevelInfoSize()) {
            return this.levelInfoFacet.get(this.id, idx).getClassLevel();
        }
        return 0;
    }

    public boolean isNonAbility(PCStat stat) {
        return this.nonAbilityFacet.isNonAbility(this.id, stat);
    }

    public boolean isSecondaryWeapon(Equipment eq) {
        if (eq == null) {
            return false;
        }
        for (Equipment eqI : this.secondaryWeaponFacet.getSet(this.id)) {
            if (!eqI.getName().equalsIgnoreCase(eq.getName()) || eqI.getLocation() != eq.getLocation()) continue;
            return true;
        }
        return false;
    }

    public double getStatBonusTo(String aType, String aName) {
        return this.statBonusFacet.getStatBonusTo(this.id, aType, aName);
    }

    public String getUDamForRace() {
        return this.unarmedDamageFacet.getUDamForRace(this.id);
    }

    public Set<List<String>> getUnarmedDamage() {
        return this.unarmedDamageFacet.getSet(this.id);
    }

    public int abilityAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Ability");
    }

    public int baseAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Base");
    }

    public String calcDR() {
        return this.drFacet.getDRString(this.id);
    }

    public String getNoUnitToken() {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(this.getWeight());
    }

    public String getWeightToken() {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(this.getWeight()) + Globals.getGameModeUnitSet().getWeightUnit();
    }

    public boolean isPrimaryWeapon(Equipment eq) {
        if (eq == null) {
            return false;
        }
        for (Equipment eqI : this.primaryWeaponFacet.getSet(this.id)) {
            if (!eqI.getName().equalsIgnoreCase(eq.getName()) || eqI.getLocation() != eq.getLocation()) continue;
            return true;
        }
        return false;
    }

    public int classAC() {
        return this.armorClassFacet.calcACOfType(this.id, "ClassDefense");
    }

    public int dodgeAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Dodge");
    }

    public int equipmentAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Equipment") + this.armorClassFacet.calcACOfType(this.id, "Armor");
    }

    public int flatfootedAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Flatfooted");
    }

    public int minXPForNextECL() {
        return this.levelTableFacet.minXPForLevel(this.levelFacet.getECL(this.id) + 1, this.id);
    }

    public int miscAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Misc");
    }

    public double multiclassXPMultiplier() {
        return this.multiClassFacet.getMultiClassXPMultiplier(this.id);
    }

    public int naturalAC() {
        return this.armorClassFacet.calcACOfType(this.id, "NaturalArmor");
    }

    public int sizeAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Size");
    }

    public int sizeInt() {
        return this.sizeFacet.sizeInt(this.id);
    }

    public int totalHitDice() {
        return this.levelFacet.getMonsterLevelCount(this.id);
    }

    public int totalNonMonsterLevels() {
        return this.levelFacet.getNonMonsterLevelCount(this.id);
    }

    public Float totalWeight() {
        return this.totalWeightFacet.getTotalWeight(this.id);
    }

    public int touchAC() {
        return this.armorClassFacet.calcACOfType(this.id, "Touch");
    }

    public SizeAdjustment getSizeAdjustment() {
        return this.sizeFacet.get(this.id);
    }

    public int getHands() {
        return this.handsFacet.getHands(this.id);
    }

    public boolean hasKit(Kit kit) {
        return this.kitFacet.contains(this.id, kit);
    }

    public int getReach() {
        return this.reachFacet.getReach(this.id);
    }

    public boolean hasSkill(Skill skill) {
        return this.skillFacet.contains(this.id, skill);
    }

    public boolean hasTemplate(PCTemplate template) {
        return this.templateFacet.contains(this.id, template);
    }

    public Collection<PCStat> getStatSet() {
        return ((AbstractListFacet)this.statFacet).getSet(this.id);
    }

    public boolean hasDomain(Domain domain) {
        return this.domainFacet.contains(this.id, domain);
    }

    public boolean hasDomains() {
        return !this.domainFacet.isEmpty(this.id);
    }

    public int getDomainCount() {
        return this.domainFacet.getCount(this.id);
    }

    public Set<Domain> getDomainSet() {
        return this.domainFacet.getSet(this.id);
    }

    public int getStatCount() {
        return ((AbstractListFacet)this.statFacet).getCount(this.id);
    }

    public PCClassLevel getActiveClassLevel(PCClass pcc, int lvl) {
        return this.classFacet.getClassLevel(this.id, pcc, lvl);
    }

    public int getClassCount() {
        return this.classFacet.getCount(this.id);
    }

    public Float getMaxLoad() {
        return this.loadFacet.getMaxLoad(this.id);
    }

    public Float getMaxLoad(double mult) {
        return this.loadFacet.getMaxLoad(this.id, mult);
    }

    public Load getLoadType() {
        return this.loadFacet.getLoadType(this.id);
    }

    public double getMovementOfType(String moveType) {
        return this.moveResultFacet.getMovementOfType(this.id, moveType);
    }

    public boolean hasEquipSet() {
        return !this.equipSetFacet.isEmpty(this.id);
    }

    public boolean hasCharacterSpells(CDOMObject cdo) {
        return this.activeSpellsFacet.containsFrom(this.id, cdo);
    }

    public Collection<? extends CharacterSpell> getCharacterSpells(CDOMObject cdo) {
        return this.activeSpellsFacet.getSet(this.id, cdo);
    }

    public AgeSet getAgeSet() {
        return (AgeSet)((AbstractItemFacet)this.ageSetFacet).get(this.id);
    }

    public Collection<ChronicleEntry> getChronicleEntries() {
        return this.chronicleEntryFacet.getSet(this.id);
    }

    public HitDie getLevelHitDie(PCClass pcClass, int classLevel) {
        return this.hitPointFacet.getLevelHitDie(this.id, pcClass, classLevel);
    }

    public List<? extends CDOMList<Spell>> getSpellLists(CDOMObject cdo) {
        return this.spellListFacet.getSet(this.id, cdo);
    }

    public String getDisplayName() {
        String custom = this.getSafeStringFor(PCStringKey.TABNAME);
        if (!"".equals(custom)) {
            return custom;
        }
        StringBuilder displayName = new StringBuilder(100).append(this.getName());
        switch (SettingsHandler.getNameDisplayStyle()) {
            case 0: {
                break;
            }
            case 1: {
                displayName.append(" the ").append(this.getDisplayClassName());
                break;
            }
            case 2: {
                displayName.append(" the ").append(this.getDisplayRaceName());
                break;
            }
            case 3: {
                displayName.append(" the ").append(this.getDisplayRaceName()).append(' ').append(this.getDisplayClassName());
                break;
            }
            case 4: {
                return this.getFullDisplayName();
            }
        }
        return displayName.toString();
    }

    public String getFullDisplayName() {
        int levels = this.getTotalLevels();
        String displayClass = this.classFacet.getCount(this.id) > 1 ? this.getFullDisplayClassName() : this.getDisplayClassName();
        return new StringBuilder(100).append(this.getName()).append(" the ").append(levels).append(this.getOrdinal(levels)).append(" level ").append(this.getDisplayRaceName()).append(' ').append(displayClass).toString();
    }

    private String getOrdinal(int cardinal) {
        switch (cardinal) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private String getDisplayClassName() {
        ArrayList<PCClass> classList = this.getClassList();
        return this.classFacet.isEmpty(this.id) ? "Nobody" : this.getDisplayClassName(classList.get(classList.size() - 1));
    }

    private String getDisplayRaceName() {
        String raceName = this.getRace().toString();
        return raceName.equals("<none selected>") ? "Nothing" : raceName;
    }

    private String getFullDisplayClassName() {
        if (this.classFacet.isEmpty(this.id)) {
            return "Nobody";
        }
        StringBuilder buf = new StringBuilder(50);
        boolean first = true;
        for (PCClass c : this.getClassSet()) {
            if (!first) {
                buf.append('/');
                first = false;
            }
            buf.append(this.getFullDisplayClassName(c));
        }
        return buf.toString();
    }

    public String getFullDisplayClassName(PCClass pcClass) {
        StringBuilder buf = new StringBuilder(40);
        buf.append(this.getDisplayClassName(pcClass));
        return buf.append(" ").append(this.getLevel(pcClass)).toString();
    }

    public String getDisplayClassName(PCClass pcClass) {
        SubClass sc;
        String subClassKey;
        if (pcClass != null && (subClassKey = this.getSubClassName(pcClass)) != null && subClassKey.length() > 0 && !subClassKey.equals("None") && (sc = pcClass.getSubClassKeyed(subClassKey)) != null) {
            return sc.getDisplayName();
        }
        return pcClass.getDisplayName();
    }

    public double getLoadToken(String type) {
        Float mult = SettingsHandler.getGame().getLoadInfo().getLoadMultiplier(type.toUpperCase());
        if (mult != null) {
            return this.getMaxLoad(mult.floatValue()).intValue();
        }
        return 0.0;
    }

    @Deprecated
    public String getCharacterHeightInchPart() {
        return Integer.toString(this.getHeight() % 12);
    }

    @Deprecated
    public String getCharacterHeightFootPart() {
        return Integer.toString(this.getHeight() / 12);
    }

    @Deprecated
    public String getHeightString() {
        String retString = "ftin".equals(Globals.getGameModeUnitSet().getHeightUnit()) ? this.getCharacterHeightFootPart() + "' " + this.getCharacterHeightInchPart() + "\"" : Globals.getGameModeUnitSet().displayHeightInUnitSet(this.getHeight()) + " " + Globals.getGameModeUnitSet().getHeightUnit();
        return retString;
    }

    @Deprecated
    public String getAlignmentDisplayString() {
        if (Globals.getGameModeAlignmentText().length() == 0) {
            return "";
        }
        PCAlignment alignment = this.getPCAlignment();
        return alignment == null ? "None" : alignment.getDisplayName();
    }

    public Collection<ProfProvider<ArmorProf>> getArmorProfList() {
        return this.armorProfFacet.getQualifiedSet(this.id);
    }

    public Set<Equipment> getEquippedEquipmentSet() {
        return this.equippedFacet.getSet(this.id);
    }

    public String getFullRegion() {
        return this.regionFacet.getFullRegion(this.id);
    }

    public Vision getVision(VisionType type) {
        return this.visionFacet.getActiveVision(this.id, type);
    }

    public String getSubstitutionClassName(PCClassLevel lvl) {
        return (String)this.substitutionClassFacet.get(this.id, lvl);
    }

    public Integer getStat(PCStat stat) {
        return (Integer)this.statValueFacet.get(this.id, stat);
    }

    public boolean containsRacialSubType(RaceSubType st) {
        return this.subTypesFacet.contains(this.id, st);
    }

    public int getLegs() {
        return this.legsFacet.getLegs(this.id);
    }

    public Integer getDR(String key) {
        return this.drFacet.getDR(this.id, key);
    }

    public boolean hasMovement() {
        return !this.baseMovementFacet.isEmpty(this.id);
    }

    public Collection<WeaponProf> getWeaponProfSet() {
        return this.weaponProfFacet.getSet(this.id);
    }

    public List<? extends SpecialAbility> getUserSpecialAbilityList(CDOMObject source) {
        return this.userSpecialAbilityFacet.getSet(this.id, source);
    }

    public Integer getHP(PCClassLevel pcl) {
        return (Integer)this.hitPointFacet.get(this.id, pcl);
    }

    public BioSet getBioSet() {
        return (BioSet)this.bioSetFacet.get(this.id);
    }

    public int getAgeSetIndex() {
        return this.ageSetFacet.getAgeSetIndex(this.id);
    }

    public boolean hasFollowers() {
        return !this.followerFacet.isEmpty(this.id);
    }

    public boolean hasEquipment() {
        return !this.equipmentFacet.isEmpty(this.id);
    }

    public boolean hasLanguage(Language lang) {
        return this.languageFacet.contains(this.id, lang);
    }

    public int getLanguageCount() {
        return ((AbstractSourcedListFacet)this.languageFacet).getCount(this.id);
    }

    public boolean hasTemplates() {
        return !this.templateFacet.isEmpty(this.id);
    }

    public Collection<ProfProvider<ShieldProf>> getShieldProfList() {
        return this.shieldProfFacet.getQualifiedSet(this.id);
    }

    public int getTotalStatFor(PCStat stat) {
        return this.statCalcFacet.getTotalStatFor(this.id, stat);
    }

    public int getStatModFor(PCStat stat) {
        return this.statCalcFacet.getStatModFor(this.id, stat);
    }

    public int getBaseStatFor(PCStat stat) {
        return this.statCalcFacet.getBaseStatFor(this.id, stat);
    }

    public int getTemplateCount() {
        return ((AbstractSourcedListFacet)this.templateFacet).getCount(this.id);
    }

    public int getFollowerCount() {
        return this.followerFacet.getCount(this.id);
    }

    public int getRacialSubTypeCount() {
        return this.subTypesFacet.getCount(this.id);
    }

    public int getVisionCount() {
        return this.visionFacet.getVisionCount(this.id);
    }

    public Double getBaseMovement() {
        return ((Movement)this.baseMovementFacet.getSet(this.id).iterator().next()).getDoubleMovement();
    }

    public double movementOfType(String moveType) {
        return this.moveResultFacet.movementOfType(this.id, moveType);
    }

    public boolean containsNote(NoteItem note) {
        return this.noteItemFacet.contains(this.id, note);
    }

    public int getNotesCount() {
        return this.noteItemFacet.getCount(this.id);
    }

    public Collection<NoteItem> getNotesList() {
        return this.noteItemFacet.getSet(this.id);
    }

    public boolean hasDeity(Deity deity) {
        return this.deityFacet.matches(this.id, deity);
    }

    public int getFavoredClassLevel() {
        return this.favClassFacet.getFavoredClassLevel(this.id);
    }

    public Float getRank(Skill sk) {
        return Float.valueOf(this.skillRankFacet.getRank(this.id, sk));
    }

    public List<WeaponProf> getWeaponProfsInTarget(CDOMGroupRef<WeaponProf> master) {
        return this.changeProfFacet.getWeaponProfsInTarget(this.id, master);
    }

    public Set<Language> getLanguageBonusSelectionList() {
        return this.startingLangFacet.getSet(this.id);
    }

    public boolean isProficientWithArmor(Equipment eq) {
        return this.armorProfFacet.isProficientWithArmor(this.id, eq);
    }
}

