/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.kit.BaseKit;

public class KitDeity
extends BaseKit {
    private CDOMSingleRef<Deity> theDeityRef;
    private Formula choiceCount;
    private List<CDOMSingleRef<Domain>> theDomains = null;
    private transient Deity theDeity = null;
    private transient List<Domain> domainsToAdd = null;

    public void addDomain(CDOMSingleRef<Domain> ref) {
        if (this.theDomains == null) {
            this.theDomains = new ArrayList<CDOMSingleRef<Domain>>(3);
        }
        this.theDomains.add(ref);
    }

    public List<CDOMSingleRef<Domain>> getDomains() {
        if (this.theDomains == null) {
            return null;
        }
        return Collections.unmodifiableList(this.theDomains);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.theDeityRef.getLSTformat(false));
        if (this.theDomains != null && this.theDomains.size() > 0) {
            buf.append(" (");
            if (this.choiceCount != null) {
                buf.append(this.choiceCount.toString());
                buf.append(" of ");
            }
            Iterator<CDOMSingleRef<Domain>> i = this.theDomains.iterator();
            while (i.hasNext()) {
                buf.append(i.next());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        List<CDOMSingleRef<Domain>> xs;
        this.domainsToAdd = null;
        this.theDeity = this.theDeityRef.resolvesTo();
        if (!aPC.canSelectDeity(this.theDeity)) {
            warnings.add("DEITY: Cannot select deity \"" + this.theDeity.getDisplayName() + "\"");
            return false;
        }
        aPC.setDeity(this.theDeity);
        if (this.theDomains == null || this.theDomains.size() == 0) {
            return true;
        }
        if (aPC.getMaxCharacterDomains() <= 0) {
            warnings.add("DEITY: Not allowed to choose a domain");
            return true;
        }
        int numberOfChoices = this.choiceCount == null ? this.theDomains.size() : this.choiceCount.resolve(aPC, "").intValue();
        if (numberOfChoices > this.theDomains.size()) {
            numberOfChoices = this.theDomains.size();
        }
        if (numberOfChoices == 0) {
            return true;
        }
        if (numberOfChoices == this.theDomains.size()) {
            xs = this.theDomains;
        } else {
            while ((xs = Globals.getChoiceFromList("Choose Domains", this.theDomains, new ArrayList(), numberOfChoices, aPC)).size() == 0) {
            }
        }
        for (CDOMSingleRef<Domain> ref : xs) {
            Domain domain = ref.resolvesTo();
            if (!domain.qualifies(aPC, domain)) {
                warnings.add("DEITY: Not qualified for domain \"" + domain.getDisplayName() + "\"");
                continue;
            }
            if (aPC.getDomainCount() >= aPC.getMaxCharacterDomains()) {
                warnings.add("DEITY: No more allowed domains");
                return false;
            }
            if (!aPC.hasDefaultDomainSource()) {
                warnings.add("DEITY: Cannot add domain \"" + domain.getDisplayName() + "\" as the character does not have a domain " + "source yet.");
                return false;
            }
            if (this.domainsToAdd == null) {
                this.domainsToAdd = new ArrayList<Domain>();
            }
            this.domainsToAdd.add(domain);
            aPC.addDomain(domain);
            DomainApplication.applyDomain(aPC, domain);
        }
        aPC.calcActiveBonuses();
        return true;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        if (this.theDeity == null) {
            return;
        }
        aPC.setDeity(this.theDeity);
        if (this.domainsToAdd != null) {
            for (Domain domain : this.domainsToAdd) {
                aPC.addDomain(domain);
                DomainApplication.applyDomain(aPC, domain);
            }
        }
        aPC.calcActiveBonuses();
        this.theDeity = null;
        this.domainsToAdd = null;
    }

    @Override
    public String getObjectName() {
        return "Deity";
    }

    public void setCount(Formula formula) {
        this.choiceCount = formula;
    }

    public Formula getCount() {
        return this.choiceCount;
    }

    public void setDeity(CDOMSingleRef<Deity> ref) {
        this.theDeityRef = ref;
    }

    public CDOMSingleRef<Deity> getDeityRef() {
        return this.theDeityRef;
    }
}

