/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.utils.CoreUtility;
import pcgen.system.LanguageBundle;

public enum PrerequisiteOperator {
    GTEQ{

        @Override
        public String getFormulaSyntax() {
            return ">=";
        }

        @Override
        public PrerequisiteOperator invert() {
            return LT;
        }

        @Override
        public boolean booleanCompare(float a, float b) {
            return a >= b;
        }
    }
    ,
    GT{

        @Override
        public String getFormulaSyntax() {
            return ">";
        }

        @Override
        public PrerequisiteOperator invert() {
            return LTEQ;
        }

        @Override
        public boolean booleanCompare(float a, float b) {
            return a > b;
        }
    }
    ,
    EQ{

        @Override
        public String getFormulaSyntax() {
            return "=";
        }

        @Override
        public PrerequisiteOperator invert() {
            return NEQ;
        }

        @Override
        public boolean booleanCompare(float a, float b) {
            return CoreUtility.doublesEqual(a, b);
        }
    }
    ,
    NEQ{

        @Override
        public String getFormulaSyntax() {
            return "!=";
        }

        @Override
        public PrerequisiteOperator invert() {
            return EQ;
        }

        @Override
        public boolean booleanCompare(float a, float b) {
            return !CoreUtility.doublesEqual(a, b);
        }
    }
    ,
    LT{

        @Override
        public String getFormulaSyntax() {
            return "<";
        }

        @Override
        public PrerequisiteOperator invert() {
            return GTEQ;
        }

        @Override
        public boolean booleanCompare(float a, float b) {
            return a < b;
        }
    }
    ,
    LTEQ{

        @Override
        public String getFormulaSyntax() {
            return "<=";
        }

        @Override
        public PrerequisiteOperator invert() {
            return GT;
        }

        @Override
        public boolean booleanCompare(float a, float b) {
            return a <= b;
        }
    };


    public abstract String getFormulaSyntax();

    public abstract PrerequisiteOperator invert();

    public String toDisplayString() {
        return LanguageBundle.getString("PrerequisiteOperator.display." + this.toString().toLowerCase());
    }

    public int compare(int leftHandOp, int rightHandOp) {
        return (int)this.compare((float)leftHandOp, (float)rightHandOp);
    }

    public float compare(float leftHandOp, float rightHandOp) {
        boolean passes = this.booleanCompare(leftHandOp, rightHandOp);
        if (passes) {
            if ((double)leftHandOp < 0.0 || CoreUtility.doublesEqual(leftHandOp, 0.0)) {
                return 1.0f;
            }
            return leftHandOp;
        }
        return 0.0f;
    }

    public abstract boolean booleanCompare(float var1, float var2);

    public static PrerequisiteOperator getOperatorByName(String operatorName) throws PrerequisiteException {
        try {
            return PrerequisiteOperator.valueOf(operatorName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            for (PrerequisiteOperator po : PrerequisiteOperator.values()) {
                if (!po.getFormulaSyntax().equals(operatorName)) continue;
                return po;
            }
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PrerequisiteOperator.error.invalid_operator", operatorName));
        }
    }
}

