/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.List;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.list.ClassSpellList;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCMaxCastableClassTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private ClassSpellList spellList;

    public PCMaxCastableClassTermEvaluator(String originalText, String classKey) {
        this.originalText = originalText;
        this.spellList = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(ClassSpellList.class, classKey);
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        Float max = Float.valueOf(-1.0f);
        for (PCClass spClass : pc.getDisplay().getClassSet()) {
            int i;
            List<? extends CDOMList<Spell>> lists = pc.getDisplay().getSpellLists(spClass);
            if (this.spellList == null || !lists.contains(this.spellList)) continue;
            int cutoff = pc.getSpellSupport(spClass).getHighestLevelSpell();
            if (pc.getSpellSupport(spClass).hasCastList()) {
                for (i = 0; i < cutoff; ++i) {
                    if (pc.getSpellSupport(spClass).getCastForLevel(i, pc) == 0) continue;
                    max = Float.valueOf(Math.max(max.floatValue(), (float)i));
                }
                continue;
            }
            for (i = 0; i < cutoff; ++i) {
                if (pc.getSpellSupport(spClass).getKnownForLevel(i, "null", pc) == 0) continue;
                max = Float.valueOf(Math.max(max.floatValue(), (float)i));
            }
        }
        return max;
    }

    @Override
    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

