/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import pcgen.facade.util.AbstractListFacade;

public class DefaultListFacade<E>
extends AbstractListFacade<E> {
    private ArrayList<E> elementList;

    public DefaultListFacade() {
        this.elementList = new ArrayList();
    }

    public DefaultListFacade(Collection<? extends E> elements) {
        this.elementList = new ArrayList<E>(elements);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private ListIterator<E> iterator;
            private int index;
            {
                this.iterator = DefaultListFacade.this.elementList.listIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                this.index = this.iterator.nextIndex();
                return this.iterator.next();
            }

            @Override
            public void remove() {
                Object element = DefaultListFacade.this.getElementAt(this.index);
                this.iterator.remove();
                DefaultListFacade.this.fireElementRemoved(this, element, this.index);
            }
        };
    }

    @Override
    public E getElementAt(int index) {
        return this.elementList.get(index);
    }

    @Override
    public int getSize() {
        return this.elementList.size();
    }

    @Override
    public boolean containsElement(E element) {
        return this.elementList.contains(element);
    }

    public int getIndexOfElement(E element) {
        return this.elementList.indexOf(element);
    }

    public void addElement(E element) {
        this.addElement(this.elementList.size(), element);
    }

    public void addElement(int index, E element) {
        this.elementList.add(index, element);
        this.fireElementAdded(this, element, index);
    }

    public boolean removeElement(E element) {
        int index = this.elementList.indexOf(element);
        if (this.elementList.remove(element)) {
            this.fireElementRemoved(this, element, index);
            return true;
        }
        return false;
    }

    public void removeElement(int index) {
        this.fireElementRemoved(this, this.elementList.remove(index), index);
    }

    public void modifyElement(E element) {
        int index = this.getIndexOfElement(element);
        if (index >= 0) {
            this.fireElementModified(this, element, index);
        }
    }

    public void setContents(Collection<? extends E> elements) {
        this.elementList.clear();
        this.elementList.addAll(elements);
        this.fireElementsChanged(this);
    }

    public void clearContents() {
        if (!this.isEmpty()) {
            this.elementList.clear();
            this.fireElementsChanged(this);
        }
    }

    public void updateContents(List<? extends E> newElements) {
        int maxUpdateSize = 20;
        if (this.isEmpty() || newElements.isEmpty() || Math.abs(this.getSize() - newElements.size()) > 20) {
            this.setContents(newElements);
            return;
        }
        int currPos = 0;
        Iterator<E> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            boolean found = false;
            for (int index = currPos; index < newElements.size(); ++index) {
                if (!e.equals(newElements.get(index))) continue;
                currPos = index + 1;
                found = true;
                break;
            }
            if (found) continue;
            int loc = this.elementList.indexOf(e);
            iterator.remove();
            this.fireElementRemoved(this, e, loc);
        }
        currPos = 0;
        for (E e : newElements) {
            if (this.elementList.size() <= currPos || !e.equals(this.elementList.get(currPos))) {
                this.addElement(currPos, e);
            }
            ++currPos;
        }
    }

    public void updateContentsNoOrder(List<? extends E> newElements) {
        int maxUpdateSize = 20;
        if (this.isEmpty() || newElements.isEmpty() || Math.abs(this.getSize() - newElements.size()) > 20) {
            this.setContents(newElements);
            return;
        }
        for (E elem : newElements) {
            if (this.containsElement(elem)) continue;
            this.addElement(elem);
        }
        Iterator<E> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (newElements.contains(e)) continue;
            int index = this.elementList.indexOf(e);
            iterator.remove();
            this.fireElementRemoved(this, e, index);
        }
    }

    public List<E> getContents() {
        return new ArrayList<E>(this.elementList);
    }

    public String toString() {
        return String.valueOf(this.elementList);
    }
}

