/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pcgen.facade.util.AbstractMapFacade;

public class DefaultMapFacade<K, V>
extends AbstractMapFacade<K, V> {
    private Map<K, V> map;

    public DefaultMapFacade() {
        this.map = new HashMap();
    }

    public DefaultMapFacade(Map<? extends K, ? extends V> map) {
        this.map = new HashMap<K, V>(map);
    }

    @Override
    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public V getValue(K key) {
        return this.map.get(key);
    }

    public void putValue(K key, V value) {
        boolean hasKey = this.map.containsKey(key);
        V oldValue = this.map.put(key, value);
        if (hasKey) {
            this.fireValueChanged(this, key, oldValue, value);
        } else {
            this.fireKeyAdded(this, key, value);
        }
    }

    public void removeKey(K key) {
        if (this.map.containsKey(key)) {
            V value = this.map.remove(key);
            this.fireKeyRemoved(this, key, value);
        }
    }

    public void setContents(Map<? extends K, ? extends V> newMap) {
        this.map.clear();
        this.map.putAll(newMap);
        this.fireKeysChanged(this);
    }

    public void clear() {
        this.map.clear();
        this.fireKeysChanged(this);
    }

    public String toString() {
        return "DefaultMapFacade [map=" + this.map + "]";
    }
}

