/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.csheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.core.TempBonusFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.csheet.CharacterSheetPanel;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.PCGenAction;
import pcgen.gui2.util.AbstractListMenu;
import pcgen.gui2.util.AbstractRadioListMenu;

public class CharacterSheetFrame
extends JFrame {
    private final CharacterSheetPanel sheetPanel;
    private CharacterFacade character;
    private EquipmentSetMenu equipMenu;
    private TempBonusMenu bonusMenu;

    public CharacterSheetFrame(PCGenFrame frame, CharacterFacade character) {
        this.character = character;
        this.sheetPanel = new CharacterSheetPanel();
        this.sheetPanel.setCharacter(character);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)this.sheetPanel, "Center");
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        return toolBar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        bar.add(this.createFileMenu());
        this.equipMenu = new EquipmentSetMenu();
        bar.add(this.equipMenu);
        this.bonusMenu = new TempBonusMenu();
        bar.add(this.bonusMenu);
        return bar;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(new SaveAction()));
        menu.addSeparator();
        menu.add(new JMenuItem(new CloseAction()));
        return menu;
    }

    private void close() {
        this.equipMenu.dispose();
        this.bonusMenu.dispose();
    }

    private class TempBonusMenu
    extends AbstractListMenu<TempBonusFacade>
    implements ItemListener {
        public TempBonusMenu() {
            super(new PCGenAction("mnuEditTempBonus"));
            this.setListModel(CharacterSheetFrame.this.character.getAvailableTempBonuses());
        }

        public void dispose() {
        }

        @Override
        protected JMenuItem createMenuItem(TempBonusFacade item, int index) {
            return new AbstractListMenu.CheckBoxMenuItem(item, CharacterSheetFrame.this.character.getTempBonuses().containsElement(item), this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TempBonusFacade bonus = (TempBonusFacade)e.getItemSelectable().getSelectedObjects()[0];
            if (e.getStateChange() == 1) {
                CharacterSheetFrame.this.character.addTempBonus(bonus);
            } else {
                CharacterSheetFrame.this.character.removeTempBonus(bonus);
            }
        }
    }

    private class EquipmentSetMenu
    extends AbstractRadioListMenu<EquipmentSetFacade>
    implements ReferenceListener<EquipmentSetFacade> {
        public EquipmentSetMenu() {
            super(new PCGenAction("mnuEditEquipmentSet"));
            this.setListModel(CharacterSheetFrame.this.character.getEquipmentSets());
            CharacterSheetFrame.this.character.getEquipmentSetRef().addReferenceListener(this);
        }

        public void dispose() {
            CharacterSheetFrame.this.character.getEquipmentSetRef().removeReferenceListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CharacterSheetFrame.this.character.setEquipmentSet((EquipmentSetFacade)e.getItem());
            }
        }

        @Override
        public void referenceChanged(ReferenceEvent<EquipmentSetFacade> e) {
            this.setSelectedItem(e.getNewReference());
        }
    }

    private class CloseAction
    extends PCGenAction {
        public CloseAction() {
            super("mnuFileClose", null, "shortcut W", Icons.Close16, new Object[0]);
        }
    }

    private class SaveAction
    extends PCGenAction {
        public SaveAction() {
            super("mnuFileSave", null, "shortcut S", Icons.Save16, new Object[0]);
        }
    }
}

