/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import pcgen.gui2.dialog.AbstractPreferencesDialog;
import pcgen.gui2.dialog.PreferencesPluginsPanel;
import pcgen.gui2.prefs.CharacterStatsPanel;
import pcgen.gui2.prefs.ColorsPanel;
import pcgen.gui2.prefs.CopySettingsPanel;
import pcgen.gui2.prefs.DefaultsPanel;
import pcgen.gui2.prefs.DisplayOptionsPanel;
import pcgen.gui2.prefs.EquipmentPanel;
import pcgen.gui2.prefs.HitPointsPanel;
import pcgen.gui2.prefs.HouseRulesPanel;
import pcgen.gui2.prefs.InputPanel;
import pcgen.gui2.prefs.LanguagePanel;
import pcgen.gui2.prefs.LevelUpPanel;
import pcgen.gui2.prefs.LocationPanel;
import pcgen.gui2.prefs.LookAndFeelPanel;
import pcgen.gui2.prefs.MonsterPanel;
import pcgen.gui2.prefs.OutputPanel;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.prefs.SourcesPanel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public final class PreferencesDialog
extends AbstractPreferencesDialog {
    private static final long serialVersionUID = 5042379023317257550L;
    private static String in_appearance = LanguageBundle.getString("in_Prefs_appearance");
    private static String in_character = LanguageBundle.getString("in_Prefs_character");
    public static final String LB_PREFS_PLUGINS_RUN = "in_Prefs_pluginsRun";
    public static final String LB_PREFS_PLUGIN_PCGEN_WIN = "in_Prefs_pluginPcgenWin";
    public static final String LB_PREFS_PLUGIN_GMGEN_WIN = "in_Prefs_pluginGMGenWin";
    private DefaultTreeModel settingsModel;
    private FlippingSplitPane splitPane;
    private JPanel settingsPanel;
    private JScrollPane settingsScroll;
    private JTree settingsTree;
    private List<PCGenPrefsPanel> panelList;
    private PCGenPrefsPanel characterStatsPanel;
    private PCGenPrefsPanel hitPointsPanel;
    private PCGenPrefsPanel houseRulesPanel;
    private PCGenPrefsPanel monsterPanel;
    private PCGenPrefsPanel defaultsPanel;
    private PCGenPrefsPanel colorsPanel;
    private PCGenPrefsPanel displayOptionsPanel;
    private PCGenPrefsPanel levelUpPanel;
    private PCGenPrefsPanel lookAndFeelPanel;
    private PCGenPrefsPanel equipmentPanel;
    private LanguagePanel languagePanel;
    private PCGenPrefsPanel locationPanel;
    private PCGenPrefsPanel inputPanel;
    private PCGenPrefsPanel outputPanel;
    private PCGenPrefsPanel sourcesPanel;
    private CopySettingsPanel copySettingsPanel;
    private PreferencesPluginsPanel pluginsPanel;

    private PreferencesDialog(JFrame parent, boolean modal) {
        super(parent, "PCGen", modal);
        this.applyOptionValuesToControls();
        this.settingsTree.setSelectionRow(1);
        this.pack();
        Utility.setDialogRelativeLocation(this.getParent(), this);
    }

    public static void show(JFrame frame) {
        PreferencesDialog prefsDialog = new PreferencesDialog(frame, true);
        prefsDialog.setVisible(true);
    }

    private void addPluginPanes(DefaultMutableTreeNode rootNode, DefaultMutableTreeNode pluginNode) {
        if (this.pluginsPanel == null) {
            this.pluginsPanel = new PreferencesPluginsPanel();
        }
        JTabbedPane tpane = new JTabbedPane();
        tpane.add(this.pluginsPanel.toString(), this.pluginsPanel);
        this.settingsPanel.add((Component)tpane, LanguageBundle.getString("in_Prefs_plugins"));
        rootNode.add(pluginNode);
    }

    public void applyPluginPreferences() {
        this.pluginsPanel.applyPreferences();
    }

    private void setOptionsBasedOnControls() {
        boolean needsRestart = false;
        for (PCGenPrefsPanel prefsPanel : this.panelList) {
            prefsPanel.setOptionsBasedOnControls();
            needsRestart |= prefsPanel.needsRestart();
        }
        if (needsRestart) {
            JOptionPane.showMessageDialog(this.getParent(), LanguageBundle.getString("in_Prefs_restartRequired"), "PCGen", 1);
        }
    }

    private void applyOptionValuesToControls() {
        for (PCGenPrefsPanel prefsPanel : this.panelList) {
            prefsPanel.applyOptionValuesToControls();
        }
        this.copySettingsPanel.registerAffectedPanel(this.characterStatsPanel);
        this.copySettingsPanel.registerAffectedPanel(this.defaultsPanel);
        this.copySettingsPanel.registerAffectedPanel(this.languagePanel);
    }

    private JPanel buildEmptyPanel(String title, String messageText) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, title);
        title1.setTitleJustification(1);
        panel.setBorder(title1);
        gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        Utility.buildConstraints(c, 5, 20, 1, 1, 1.0, 1.0);
        c.fill = 1;
        JLabel label = new JLabel(messageText, 0);
        gridbag.setConstraints(label, c);
        panel.add(label);
        return panel;
    }

    @Override
    protected JComponent getCenter() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Root");
        this.panelList = new ArrayList<PCGenPrefsPanel>(15);
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new CardLayout());
        this.settingsPanel.setPreferredSize(new Dimension(780, 420));
        DefaultMutableTreeNode characterNode = new DefaultMutableTreeNode(in_character);
        this.settingsPanel.add((Component)this.buildEmptyPanel("", LanguageBundle.getString("in_Prefs_charTip")), in_character);
        this.characterStatsPanel = new CharacterStatsPanel(this);
        this.addPanelToTree(characterNode, this.characterStatsPanel);
        this.hitPointsPanel = new HitPointsPanel();
        this.addPanelToTree(characterNode, this.hitPointsPanel);
        this.houseRulesPanel = new HouseRulesPanel();
        this.addPanelToTree(characterNode, this.houseRulesPanel);
        this.monsterPanel = new MonsterPanel();
        this.addPanelToTree(characterNode, this.monsterPanel);
        this.defaultsPanel = new DefaultsPanel();
        this.addPanelToTree(characterNode, this.defaultsPanel);
        rootNode.add(characterNode);
        DefaultMutableTreeNode appearanceNode = new DefaultMutableTreeNode(in_appearance);
        this.settingsPanel.add((Component)this.buildEmptyPanel("", LanguageBundle.getString("in_Prefs_appearanceTip")), in_appearance);
        this.colorsPanel = new ColorsPanel();
        this.addPanelToTree(appearanceNode, this.colorsPanel);
        this.displayOptionsPanel = new DisplayOptionsPanel();
        this.addPanelToTree(appearanceNode, this.displayOptionsPanel);
        this.levelUpPanel = new LevelUpPanel();
        this.addPanelToTree(appearanceNode, this.levelUpPanel);
        this.lookAndFeelPanel = new LookAndFeelPanel(this);
        this.addPanelToTree(appearanceNode, this.lookAndFeelPanel);
        rootNode.add(appearanceNode);
        DefaultMutableTreeNode pcGenNode = new DefaultMutableTreeNode("PCGen");
        this.settingsPanel.add((Component)this.buildEmptyPanel("", LanguageBundle.getString("in_Prefs_pcgenTip")), "PCGen");
        this.equipmentPanel = new EquipmentPanel();
        this.addPanelToTree(pcGenNode, this.equipmentPanel);
        this.languagePanel = new LanguagePanel();
        this.addPanelToTree(pcGenNode, this.languagePanel);
        this.locationPanel = new LocationPanel();
        this.addPanelToTree(pcGenNode, this.locationPanel);
        this.inputPanel = new InputPanel();
        this.addPanelToTree(pcGenNode, this.inputPanel);
        this.outputPanel = new OutputPanel();
        this.addPanelToTree(pcGenNode, this.outputPanel);
        this.sourcesPanel = new SourcesPanel();
        this.addPanelToTree(pcGenNode, this.sourcesPanel);
        rootNode.add(pcGenNode);
        String in_gamemode = LanguageBundle.getString("in_mnuSettingsCampaign");
        DefaultMutableTreeNode gameModeNode = new DefaultMutableTreeNode(in_gamemode);
        this.settingsPanel.add((Component)this.buildEmptyPanel("", LanguageBundle.getString("in_mnuSettingsCampaignTip")), in_gamemode);
        this.copySettingsPanel = new CopySettingsPanel();
        this.addPanelToTree(gameModeNode, this.copySettingsPanel);
        rootNode.add(gameModeNode);
        DefaultMutableTreeNode pluginNode = new DefaultMutableTreeNode(LanguageBundle.getString("in_Prefs_plugins"));
        this.addPluginPanes(rootNode, pluginNode);
        this.settingsModel = new DefaultTreeModel(rootNode);
        this.settingsTree = new JTree(this.settingsModel);
        if (UIManager.getLookAndFeel().getName().equals("Kunststoff")) {
            this.settingsTree.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        } else {
            this.settingsTree.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }
        this.settingsTree.setRootVisible(false);
        this.settingsTree.setShowsRootHandles(true);
        this.settingsTree.getSelectionModel().setSelectionMode(1);
        this.settingsScroll = new JScrollPane(this.settingsTree, 20, 30);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        this.settingsTree.setCellRenderer(renderer);
        this.settingsTree.expandPath(new TreePath(characterNode.getPath()));
        this.settingsTree.expandPath(new TreePath(pcGenNode.getPath()));
        this.settingsTree.expandPath(new TreePath(appearanceNode.getPath()));
        this.settingsTree.expandPath(new TreePath(gameModeNode.getPath()));
        this.settingsTree.expandPath(new TreePath(pluginNode.getPath()));
        this.settingsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PreferencesDialog.this.settingsTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                CardLayout cl = (CardLayout)PreferencesDialog.this.settingsPanel.getLayout();
                cl.show(PreferencesDialog.this.settingsPanel, String.valueOf(node));
            }
        });
        this.splitPane = new FlippingSplitPane(1, this.settingsScroll, (Component)this.settingsPanel, "Prefs");
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        return this.splitPane;
    }

    private void addPanelToTree(DefaultMutableTreeNode parent, PCGenPrefsPanel prefsPanel) {
        this.panelList.add(prefsPanel);
        parent.add(new DefaultMutableTreeNode(prefsPanel.getTitle()));
        JScrollPane rightScroll = new JScrollPane(prefsPanel);
        this.settingsPanel.add((Component)rightScroll, prefsPanel.getTitle());
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.resetOptionValues();
        super.cancelButtonActionPerformed();
    }

    private void resetOptionValues() {
        for (PCGenPrefsPanel prefsPanel : this.panelList) {
            prefsPanel.resetOptionValues();
        }
    }

    @Override
    public void applyButtonActionPerformed() {
        this.setOptionsBasedOnControls();
        this.applyPluginPreferences();
    }
}

