/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SizeAdjustment;
import pcgen.core.utils.CoreUtility;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class CharacterUtils {
    public static void selectClothes(PlayerCharacter aPC) {
        if (Globals.checkRule("FREECLOTHES") && aPC.getDisplay().totalNonMonsterLevels() == 1) {
            List<Equipment> clothes = aPC.getEquipmentOfType("Clothing.Resizable", 3);
            boolean hasClothes = false;
            SizeAdjustment pcSizeAdj = aPC.getDisplay().getSizeAdjustment();
            if (clothes.size() != 0) {
                for (Equipment eq : clothes) {
                    if (eq.isType("Magic") || !CoreUtility.doublesEqual(eq.getCost(aPC).doubleValue(), 0.0) || !pcSizeAdj.equals(eq.getSafe(ObjectKey.SIZE))) continue;
                    hasClothes = true;
                    break;
                }
            }
            if (!hasClothes) {
                Equipment eq;
                clothes = EquipmentList.getEquipmentOfType("Clothing.Resizable.Starting", "Magic.Custom.Auto_Gen");
                if (clothes.isEmpty()) {
                    clothes = EquipmentList.getEquipmentOfType("Clothing.Resizable", "Magic.Custom.Auto_Gen");
                }
                List<Object> selectedClothes = new ArrayList();
                selectedClothes = Globals.getChoiceFromList(LanguageBundle.getString("in_sumSelectAFreeSetOfClothing"), clothes, selectedClothes, 1, aPC);
                if (selectedClothes.size() != 0 && (eq = (Equipment)selectedClothes.get(0)) != null) {
                    eq = eq.clone();
                    eq.setQty(new Float(1.0f));
                    if (!pcSizeAdj.equals(eq.getSafe(ObjectKey.SIZE))) {
                        eq.resizeItem(aPC, pcSizeAdj);
                    }
                    eq.setCostMod('-' + eq.getCost(aPC).toString());
                    if (aPC.getEquipmentNamed(eq.nameItemFromModifiers(aPC)) == null) {
                        aPC.addEquipment(eq);
                    } else {
                        Logging.errorPrint("Cannot add duplicate equipment to PC");
                    }
                }
            }
        }
    }
}

