/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.core.ChronicleEntry;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.facade.core.ChronicleEntryFacade;
import pcgen.facade.core.DescriptionFacade;
import pcgen.facade.core.NoteFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.system.LanguageBundle;

public class DescriptionFacadeImpl
implements DescriptionFacade {
    private static final String NOTE_NAME_BIO = LanguageBundle.getString("in_bio");
    private static final String NOTE_NAME_DESCRIP = LanguageBundle.getString("in_descrip");
    private static final String NOTE_NAME_COMPANION = LanguageBundle.getString("in_companions");
    private static final String NOTE_NAME_OTHER_ASSETS = LanguageBundle.getString("in_otherAssets");
    private static final String NOTE_NAME_MAGIC_ITEMS = LanguageBundle.getString("in_magicItems");
    private static final String NOTE_NAME_GM_NOTES = LanguageBundle.getString("in_gmNotes");
    private final PlayerCharacter theCharacter;
    private final CharacterDisplay charDisplay;
    private DefaultListFacade<ChronicleEntryFacade> chronicleEntries;
    private DefaultListFacade<NoteFacade> notes;
    private DefaultReferenceFacade<String> birthday;
    private DefaultReferenceFacade<String> location;
    private DefaultReferenceFacade<String> city;
    private DefaultReferenceFacade<String> region;
    private DefaultReferenceFacade<String> birthplace;
    private DefaultReferenceFacade<String> personalityTrait1;
    private DefaultReferenceFacade<String> personalityTrait2;
    private DefaultReferenceFacade<String> phobias;
    private DefaultReferenceFacade<String> interests;
    private DefaultReferenceFacade<String> catchPhrase;
    private DefaultReferenceFacade<String> hairStyle;
    private DefaultReferenceFacade<String> speechPattern;
    private DefaultListFacade<BiographyField> customBiographyFields;

    public DescriptionFacadeImpl(PlayerCharacter pc) {
        this.theCharacter = pc;
        this.charDisplay = pc.getDisplay();
        this.chronicleEntries = new DefaultListFacade();
        for (ChronicleEntryFacade chronicleEntryFacade : this.charDisplay.getChronicleEntries()) {
            this.chronicleEntries.addElement(chronicleEntryFacade);
        }
        this.notes = new DefaultListFacade();
        this.addDefaultNotes();
        for (NoteItem noteItem : this.charDisplay.getNotesList()) {
            this.notes.addElement(noteItem);
        }
        this.birthday = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.BIRTHDAY));
        this.location = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.LOCATION));
        this.city = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.RESIDENCE));
        this.region = new DefaultReferenceFacade<String>(this.charDisplay.getRegionString());
        this.birthplace = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.BIRTHPLACE));
        this.personalityTrait1 = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.PERSONALITY1));
        this.personalityTrait2 = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.PERSONALITY2));
        this.phobias = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.PHOBIAS));
        this.interests = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.INTERESTS));
        this.catchPhrase = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.CATCHPHRASE));
        this.hairStyle = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.HAIRSTYLE));
        this.speechPattern = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.SPEECHTENDENCY));
        this.customBiographyFields = new DefaultListFacade();
        this.addCharacterCustomFields();
    }

    private void addDefaultNotes() {
        this.notes.addElement(this.createDefaultNote(NOTE_NAME_BIO, this.charDisplay.getBio()));
        this.notes.addElement(this.createDefaultNote(NOTE_NAME_DESCRIP, this.charDisplay.getSafeStringFor(PCStringKey.DESCRIPTION)));
        this.notes.addElement(this.createDefaultNote(NOTE_NAME_COMPANION, this.charDisplay.getSafeStringFor(PCStringKey.COMPANIONS)));
        this.notes.addElement(this.createDefaultNote(NOTE_NAME_OTHER_ASSETS, this.charDisplay.getSafeStringFor(PCStringKey.ASSETS)));
        this.notes.addElement(this.createDefaultNote(NOTE_NAME_MAGIC_ITEMS, this.charDisplay.getSafeStringFor(PCStringKey.MAGIC)));
        this.notes.addElement(this.createDefaultNote(NOTE_NAME_GM_NOTES, this.charDisplay.getSafeStringFor(PCStringKey.GMNOTES)));
    }

    private NoteFacade createDefaultNote(String noteName, String value) {
        NoteItem note = new NoteItem(0, -1, noteName, value);
        note.setRequired(true);
        return note;
    }

    private void addCharacterCustomFields() {
        for (BiographyField field : EnumSet.range(BiographyField.SPEECH_PATTERN, BiographyField.CATCH_PHRASE)) {
            if (!StringUtils.isNotEmpty(this.getBiographyField(field).getReference())) continue;
            this.customBiographyFields.addElement(field);
        }
    }

    @Override
    public ChronicleEntryFacade createChronicleEntry() {
        ChronicleEntry chronicleEntry = new ChronicleEntry();
        this.theCharacter.addChronicleEntry(chronicleEntry);
        this.chronicleEntries.addElement(chronicleEntry);
        return chronicleEntry;
    }

    @Override
    public void removeChronicleEntry(ChronicleEntryFacade chronicleEntry) {
        if (chronicleEntry instanceof ChronicleEntry) {
            this.theCharacter.removeChronicleEntry((ChronicleEntry)chronicleEntry);
        }
        this.chronicleEntries.removeElement(chronicleEntry);
    }

    @Override
    public ListFacade<ChronicleEntryFacade> getChronicleEntries() {
        return this.chronicleEntries;
    }

    @Override
    public ListFacade<NoteFacade> getNotes() {
        return this.notes;
    }

    @Override
    public void setNote(NoteFacade note, String text) {
        if (note == null || !(note instanceof NoteItem)) {
            return;
        }
        NoteItem noteItem = (NoteItem)note;
        noteItem.setValue(text);
        if (noteItem.isRequired()) {
            String noteName = noteItem.getName();
            if (NOTE_NAME_BIO.equals(noteName)) {
                this.theCharacter.setBio(text);
            } else if (NOTE_NAME_DESCRIP.equals(noteName)) {
                this.theCharacter.setDescription(text);
            } else if (NOTE_NAME_COMPANION.equals(noteName)) {
                this.theCharacter.setStringFor(PCStringKey.COMPANIONS, text);
            } else if (NOTE_NAME_OTHER_ASSETS.equals(noteName)) {
                this.theCharacter.setStringFor(PCStringKey.ASSETS, text);
            } else if (NOTE_NAME_MAGIC_ITEMS.equals(noteName)) {
                this.theCharacter.setStringFor(PCStringKey.MAGIC, text);
            } else if (NOTE_NAME_GM_NOTES.equals(noteName)) {
                this.theCharacter.setStringFor(PCStringKey.GMNOTES, text);
            }
        }
    }

    @Override
    public void renameNote(NoteFacade note, String newName) {
        if (note == null || !(note instanceof NoteItem) || note.isRequired()) {
            return;
        }
        NoteItem noteItem = (NoteItem)note;
        noteItem.setName(newName);
        this.notes.modifyElement(noteItem);
    }

    @Override
    public void deleteNote(NoteFacade note) {
        if (note == null || !(note instanceof NoteItem) || note.isRequired()) {
            return;
        }
        this.theCharacter.removeNote((NoteItem)note);
        this.notes.removeElement(note);
    }

    @Override
    public void addNewNote() {
        String baseName;
        int parentId = -1;
        int newNodeId = 0;
        for (NoteItem currItem : this.charDisplay.getNotesList()) {
            if (currItem.getId() <= newNodeId) continue;
            newNodeId = currItem.getId();
        }
        ++newNodeId;
        HashSet<String> names = new HashSet<String>();
        for (NoteFacade note : this.notes) {
            names.add(note.getName());
        }
        String name = baseName = LanguageBundle.getString("in_newItem");
        int num = 0;
        while (names.contains(name)) {
            name = baseName + " " + ++num;
        }
        NoteItem note = new NoteItem(newNodeId, parentId, name, LanguageBundle.getString("in_newValue"));
        this.theCharacter.addNotesItem(note);
        this.notes.addElement(note);
    }

    @Override
    public ReferenceFacade<String> getBiographyField(BiographyField field) {
        switch (field) {
            case SPEECH_PATTERN: {
                return this.speechPattern;
            }
            case BIRTHDAY: {
                return this.birthday;
            }
            case LOCATION: {
                return this.location;
            }
            case CITY: {
                return this.city;
            }
            case REGION: {
                return this.region;
            }
            case BIRTHPLACE: {
                return this.birthplace;
            }
            case PERSONALITY_TRAIT_1: {
                return this.personalityTrait1;
            }
            case PERSONALITY_TRAIT_2: {
                return this.personalityTrait2;
            }
            case PHOBIAS: {
                return this.phobias;
            }
            case INTERESTS: {
                return this.interests;
            }
            case CATCH_PHRASE: {
                return this.catchPhrase;
            }
            case HAIR_STYLE: {
                return this.hairStyle;
            }
        }
        throw new UnsupportedOperationException("The field " + (Object)((Object)field) + " must use a dedicated getter.");
    }

    @Override
    public void setBiographyField(BiographyField field, String newValue) {
        switch (field) {
            case SPEECH_PATTERN: {
                this.speechPattern.setReference(newValue);
                this.theCharacter.setSpeechTendency(newValue);
                break;
            }
            case BIRTHDAY: {
                this.birthday.setReference(newValue);
                this.theCharacter.setBirthday(newValue);
                break;
            }
            case LOCATION: {
                this.location.setReference(newValue);
                this.theCharacter.setLocation(newValue);
                break;
            }
            case CITY: {
                this.city.setReference(newValue);
                this.theCharacter.setResidence(newValue);
                break;
            }
            case BIRTHPLACE: {
                this.birthplace.setReference(newValue);
                this.theCharacter.setBirthplace(newValue);
                break;
            }
            case PERSONALITY_TRAIT_1: {
                this.personalityTrait1.setReference(newValue);
                this.theCharacter.setTrait1(newValue);
                break;
            }
            case PERSONALITY_TRAIT_2: {
                this.personalityTrait2.setReference(newValue);
                this.theCharacter.setTrait2(newValue);
                break;
            }
            case PHOBIAS: {
                this.phobias.setReference(newValue);
                this.theCharacter.setPhobias(newValue);
                break;
            }
            case INTERESTS: {
                this.interests.setReference(newValue);
                this.theCharacter.setInterests(newValue);
                break;
            }
            case CATCH_PHRASE: {
                this.catchPhrase.setReference(newValue);
                this.theCharacter.setCatchPhrase(newValue);
                break;
            }
            case HAIR_STYLE: {
                this.hairStyle.setReference(newValue);
                this.theCharacter.setHairStyle(newValue);
                break;
            }
            case REGION: {
                throw new UnsupportedOperationException("The field " + (Object)((Object)field) + " cannot be set from the UI.");
            }
            default: {
                throw new UnsupportedOperationException("The field " + (Object)((Object)field) + " must use a dedicated setter.");
            }
        }
    }

    @Override
    public ListFacade<BiographyField> getCustomBiographyFields() {
        return this.customBiographyFields;
    }

    @Override
    public void addCustomBiographyField(BiographyField field) {
        this.customBiographyFields.addElement(field);
    }

    @Override
    public void removeCustomBiographyField(BiographyField field) {
        this.customBiographyFields.removeElement(field);
    }
}

