/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;

public class DisplayOptionsPanel
extends PCGenPrefsPanel {
    private static String in_displayOpts = LanguageBundle.getString("in_Prefs_displayOpts");
    private static String in_useOutputNamesEquipment = LanguageBundle.getString("in_Prefs_useOutputNamesEquipment");
    private static String in_useOutputNamesSpells = LanguageBundle.getString("in_Prefs_useOutputNamesSpells");
    private static String in_useOutputNamesOther = LanguageBundle.getString("in_Prefs_useOutputNamesOther");
    private static String in_showSkillModifierBreakdown = LanguageBundle.getString("in_Prefs_showSkillModifierBreakdown");
    private static String in_showSkillRanksBreakdown = LanguageBundle.getString("in_Prefs_showSkillRanksBreakdown");
    private static String in_singleChoiceOption = LanguageBundle.getString("in_Prefs_singleChoiceOption");
    private static String in_cmNone = LanguageBundle.getString("in_Prefs_cmNone");
    private static String in_cmSelect = LanguageBundle.getString("in_Prefs_cmSelect");
    private static String in_cmSelectExit = LanguageBundle.getString("in_Prefs_cmSelectExit");
    private static String[] singleChoiceMethods = new String[]{in_cmNone, in_cmSelect, in_cmSelectExit};
    private JCheckBox showSkillModifier = new JCheckBox();
    private JCheckBox showSkillRanks = new JCheckBox();
    private JCheckBox useOutputNamesEquipment = new JCheckBox();
    private JCheckBox useOutputNamesSpells = new JCheckBox();
    private JCheckBox useOutputNamesOther = new JCheckBox();
    private JComboBoxEx cmbChoiceMethods = new JComboBoxEx(singleChoiceMethods);

    public DisplayOptionsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_displayOpts);
        int line = 0;
        title1.setTitleJustification(4);
        this.setBorder(title1);
        gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        TreeMap<String, JComponent> options = new TreeMap<String, JComponent>();
        options.put(in_showSkillModifierBreakdown, this.showSkillModifier);
        options.put(in_showSkillRanksBreakdown, this.showSkillRanks);
        options.put(in_singleChoiceOption, this.cmbChoiceMethods);
        options.put(in_useOutputNamesEquipment, this.useOutputNamesEquipment);
        options.put(in_useOutputNamesSpells, this.useOutputNamesSpells);
        options.put(in_useOutputNamesOther, this.useOutputNamesOther);
        for (Map.Entry entry : options.entrySet()) {
            line = this.addDisplayOption(line, c, gridbag, this, (String)entry.getKey(), (JComponent)entry.getValue());
        }
        Utility.buildConstraints(c, 0, line, 0, 1, 1.0, 1.0);
        c.fill = 1;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    private int addDisplayOption(int line, GridBagConstraints constraints, GridBagLayout gridbag, JPanel panel, String labelText, JComponent c) {
        if (c instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)c;
            checkbox.setText(labelText);
            Utility.buildConstraints(constraints, 0, line, 0, 1, 0.0, 0.0);
        } else {
            JLabel label = new JLabel(labelText);
            Utility.buildConstraints(constraints, 0, line, 1, 1, 0.0, 0.0);
            panel.add((Component)label, constraints);
            Utility.buildConstraints(constraints, 1, line, 0, 1, 0.0, 0.0);
        }
        panel.add((Component)c, constraints);
        return line + 1;
    }

    @Override
    public String getTitle() {
        return in_displayOpts;
    }

    @Override
    public void setOptionsBasedOnControls() {
        SettingsHandler.setGUIUsesOutputNameEquipment(this.useOutputNamesEquipment.isSelected());
        SettingsHandler.setGUIUsesOutputNameSpells(this.useOutputNamesSpells.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("showOutputNameForOtherItems", this.useOutputNamesOther.isSelected());
        UIPropertyContext.setSingleChoiceAction(this.cmbChoiceMethods.getSelectedIndex());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("showSkillModBreakdown", this.showSkillModifier.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("showSkillRankBreakdown", this.showSkillRanks.isSelected());
    }

    @Override
    public void applyOptionValuesToControls() {
        this.cmbChoiceMethods.setSelectedIndex(UIPropertyContext.getSingleChoiceAction());
        this.showSkillModifier.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("showSkillModBreakdown", false));
        this.showSkillRanks.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("showSkillRankBreakdown", false));
        this.useOutputNamesEquipment.setSelected(SettingsHandler.guiUsesOutputNameEquipment());
        this.useOutputNamesSpells.setSelected(SettingsHandler.guiUsesOutputNameSpells());
        this.useOutputNamesOther.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("showOutputNameForOtherItems", false));
    }
}

