/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CompanionFacade;
import pcgen.facade.core.CompanionStubFacade;
import pcgen.facade.core.CompanionSupportFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.MapFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.MapEvent;
import pcgen.facade.util.event.MapListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilteredListFacade;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.models.HtmlSheetSupport;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.DisplayAwareTab;
import pcgen.gui2.util.JTreeTable;
import pcgen.gui2.util.treetable.AbstractTreeTableModel;
import pcgen.gui2.util.treetable.DefaultTreeTableNode;
import pcgen.gui2.util.treetable.SortableTreeTableModel;
import pcgen.gui2.util.treetable.TreeTableModel;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.CharacterManager;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.util.Comparators;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class CompanionInfoTab
extends FlippingSplitPane
implements CharacterInfoTab,
TodoHandler,
DisplayAwareTab {
    private final JTreeTable companionsTable = new JTreeTable(){

        @Override
        protected void configureEnclosingScrollPane() {
        }
    };
    private final JEditorPane infoPane = new JEditorPane();
    private final JButton loadButton = new JButton();
    private CompanionDialog companionDialog = null;

    public CompanionInfoTab() {
        super("Companion");
        this.initComponents();
    }

    private void initDialog() {
        if (this.companionDialog == null) {
            this.companionDialog = new CompanionDialog();
        }
    }

    private void initComponents() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        TableColumn column = new TableColumn(0);
        column.setResizable(true);
        model.addColumn(column);
        column = new TableColumn(1, 120, new ButtonCellRenderer(), null);
        column.setMaxWidth(120);
        column.setResizable(false);
        model.addColumn(column);
        this.companionsTable.setAutoResizeMode(4);
        this.companionsTable.getTableHeader().setResizingAllowed(false);
        this.companionsTable.setAutoCreateColumnsFromModel(false);
        this.companionsTable.setColumnModel(model);
        this.companionsTable.setIntercellSpacing(new Dimension(0, 0));
        this.companionsTable.setFocusable(false);
        this.companionsTable.setRowHeight(23);
        this.companionsTable.setSelectionMode(0);
        this.setLeftComponent(new JScrollPane(this.companionsTable));
        JPanel rightPane = new JPanel(new BorderLayout());
        this.infoPane.setOpaque(false);
        this.infoPane.setEditable(false);
        this.infoPane.setFocusable(true);
        this.infoPane.setContentType("text/html");
        rightPane.add((Component)new JScrollPane(this.infoPane), "Center");
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(this.loadButton);
        rightPane.add((Component)buttonPane, "South");
        this.setRightComponent(rightPane);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(CompanionsModel.class, new CompanionsModel(character));
        models.put(ButtonCellEditor.class, new ButtonCellEditor(character));
        models.put(LoadButtonAndSheetHandler.class, new LoadButtonAndSheetHandler());
        models.put(TreeExpansionHandler.class, new TreeExpansionHandler());
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        this.companionsTable.setTreeTableModel(models.get(CompanionsModel.class));
        this.companionsTable.setDefaultEditor(Object.class, models.get(ButtonCellEditor.class));
        models.get(TreeExpansionHandler.class).install();
        models.get(LoadButtonAndSheetHandler.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(TreeExpansionHandler.class).uninstall();
        models.get(LoadButtonAndSheetHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return new TabTitle(Tab.COMPANIONS);
    }

    @Override
    public void tabSelected() {
        LoadButtonAndSheetHandler action = (LoadButtonAndSheetHandler)this.loadButton.getAction();
        if (action != null) {
            action.showCompanion(false);
        }
    }

    private void selectCompanion(CompanionFacade compFacade) {
        TreeTableModel treeTableModel = this.companionsTable.getTreeTableModel();
        treeTableModel.getRoot();
        TreePath path = null;
        JTree tree = this.companionsTable.getTree();
        String companionType = compFacade.getCompanionType();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            CompanionFacade rowComp;
            TreePath pathForRow = tree.getPathForRow(i);
            Object lastPathComponent = pathForRow.getLastPathComponent();
            if (lastPathComponent.toString().startsWith(companionType)) {
                tree.expandRow(i);
                continue;
            }
            if (!(lastPathComponent instanceof CompanionsModel.CompanionNode) || (rowComp = (CompanionFacade)((CompanionsModel.CompanionNode)lastPathComponent).getValueAt(0)) == null || rowComp.getFileRef().getReference() != compFacade.getFileRef().getReference() || rowComp.getNameRef().getReference() != compFacade.getNameRef().getReference() || rowComp.getRaceRef().getReference() != compFacade.getRaceRef().getReference()) continue;
            path = pathForRow;
        }
        if (path != null) {
            this.companionsTable.getTree().setSelectionPath(path);
            this.companionsTable.getTree().scrollPathToVisible(path);
        }
    }

    @Override
    public void adviseTodo(String fieldName) {
        CompanionsModel model = (CompanionsModel)this.companionsTable.getTreeTableModel();
        CompanionsModel.RootNode root = (CompanionsModel.RootNode)model.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode node = root.getChildAt(i);
            if (!node.toString().startsWith(fieldName)) continue;
            this.companionsTable.getSelectionModel().setSelectionInterval(i, i);
            return;
        }
    }

    private static class CompanionsModel
    extends AbstractTreeTableModel
    implements SortableTreeTableModel {
        private CompanionSupportFacade support;
        private MapFacade<String, Integer> maxMap;

        public CompanionsModel(CharacterFacade character) {
            this.support = character.getCompanionSupport();
            this.maxMap = this.support.getMaxCompanionsMap();
            this.setRoot(new RootNode());
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            if (column > 0) {
                Object value = this.getValueAt(node, column);
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                return true;
            }
            return super.isCellEditable(node, column);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public void sortModel(Comparator<List<?>> comparator) {
        }

        class RootNode
        extends DefaultTreeTableNode
        implements MapListener<String, Integer>,
        ListListener<CompanionFacade> {
            private List<String> types = new ArrayList<String>();
            private ListFacade<? extends CompanionFacade> companions;

            public RootNode() {
                this.companions = CompanionsModel.this.support.getCompanions();
                CompanionsModel.this.maxMap.addMapListener(this);
                this.companions.addListListener(this);
                this.initChildren();
            }

            private void initChildren() {
                this.types.clear();
                this.types.addAll(CompanionsModel.this.maxMap.getKeys());
                Collections.sort(this.types, Comparators.toStringIgnoreCaseCollator());
                this.removeAllChildren();
                for (String string : this.types) {
                    CompanionTypeNode child = new CompanionTypeNode(string);
                    this.add(child);
                }
                for (CompanionFacade companionFacade : this.companions) {
                    this.addCompanion(companionFacade, true);
                }
            }

            private void addCompanion(CompanionFacade companion, boolean silently) {
                String type = companion.getCompanionType();
                int index = Collections.binarySearch(this.types, type, Comparators.toStringIgnoreCaseCollator());
                if (index < 0) {
                    Logging.errorPrint("Unable to add companion " + companion + " as the type " + type + " could not be found.");
                    return;
                }
                CompanionTypeNode child = (CompanionTypeNode)this.getChildAt(index);
                child.addCompanion(companion, silently);
            }

            @Override
            public void keyAdded(MapEvent<String, Integer> e) {
                int insertIndex = Collections.binarySearch(this.types, e.getKey(), Comparators.toStringIgnoreCaseCollator());
                if (insertIndex < 0) {
                    insertIndex = -(insertIndex + 1);
                }
                this.types.add(insertIndex, e.getKey());
                CompanionTypeNode child = new CompanionTypeNode(e.getKey());
                CompanionsModel.this.insertNodeInto(child, this, insertIndex);
            }

            @Override
            public void keyRemoved(MapEvent<String, Integer> e) {
                int index = this.types.indexOf(e.getKey());
                this.types.remove(index);
                CompanionsModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(index));
            }

            @Override
            public void keyModified(MapEvent<String, Integer> e) {
            }

            @Override
            public void valueChanged(MapEvent<String, Integer> e) {
                int index = this.types.indexOf(e.getKey());
                CompanionsModel.this.nodeChanged(this.getChildAt(index));
            }

            @Override
            public void valueModified(MapEvent<String, Integer> e) {
            }

            @Override
            public void keysChanged(MapEvent<String, Integer> e) {
                this.initChildren();
                CompanionsModel.this.nodeStructureChanged(this);
            }

            @Override
            public void elementAdded(ListEvent<CompanionFacade> e) {
                this.addCompanion(e.getElement(), false);
            }

            @Override
            public void elementRemoved(ListEvent<CompanionFacade> e) {
                String type = e.getElement().getCompanionType();
                int index = Collections.binarySearch(this.types, type, Comparators.toStringIgnoreCaseCollator());
                CompanionTypeNode child = (CompanionTypeNode)this.getChildAt(index);
                child.removeCompanion(e.getElement());
            }

            @Override
            public void elementsChanged(ListEvent<CompanionFacade> e) {
                this.initChildren();
                CompanionsModel.this.nodeStructureChanged(this);
            }

            @Override
            public void elementModified(ListEvent<CompanionFacade> e) {
            }
        }

        private class CompanionTypeNode
        extends DefaultTreeTableNode
        implements ReferenceListener<String> {
            private String type;

            public CompanionTypeNode(String type) {
                super(Arrays.asList(type, null));
                this.type = type;
            }

            @Override
            public Object getValueAt(int column) {
                if (column > 0) {
                    Integer max = (Integer)CompanionsModel.this.maxMap.getValue(this.type);
                    if (max < 0) {
                        return true;
                    }
                    return this.getChildCount() < max;
                }
                return super.getValueAt(column);
            }

            @Override
            public String toString() {
                Integer max = (Integer)CompanionsModel.this.maxMap.getValue(this.type);
                String maxString = max == -1 ? "*" : max.toString();
                return this.type + " (" + this.getChildCount() + "/" + maxString + ")";
            }

            private void addCompanion(CompanionFacade companion, boolean silently) {
                int insertIndex;
                companion.getNameRef().addReferenceListener(this);
                CompanionNode child = new CompanionNode(companion);
                if (this.children == null) {
                    this.children = new Vector();
                }
                if ((insertIndex = Collections.binarySearch(this.children, child, Comparators.toStringIgnoreCaseCollator())) < 0) {
                    if (silently) {
                        this.insert(child, -(insertIndex + 1));
                    } else {
                        CompanionsModel.this.insertNodeInto(child, this, -(insertIndex + 1));
                    }
                } else if (silently) {
                    this.insert(child, insertIndex);
                } else {
                    CompanionsModel.this.insertNodeInto(child, this, insertIndex);
                }
                if (!silently) {
                    CompanionsModel.this.nodeChanged(this);
                }
            }

            private void removeCompanion(CompanionFacade companion) {
                companion.getNameRef().removeReferenceListener(this);
                CompanionNode child = new CompanionNode(companion);
                int index = Collections.binarySearch(this.children, child, Comparators.toStringIgnoreCaseCollator());
                CompanionsModel.this.removeNodeFromParent((CompanionNode)this.getChildAt(index));
                CompanionsModel.this.nodeChanged(this);
            }

            @Override
            public void referenceChanged(ReferenceEvent<String> e) {
                Collections.sort(this.children, Comparators.toStringIgnoreCaseCollator());
                int[] indexes = new int[this.getChildCount()];
                for (int i = 0; i < indexes.length; ++i) {
                    indexes[i] = i;
                }
                CompanionsModel.this.nodesChanged(this, indexes);
            }

            @Override
            public void setParent(MutableTreeNode newParent) {
                super.setParent(newParent);
                if (newParent == null && this.children != null) {
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        CompanionNode child = (CompanionNode)this.getChildAt(i);
                        child.companion.getNameRef().removeReferenceListener(this);
                    }
                }
            }
        }

        private class CompanionNode
        extends DefaultTreeTableNode {
            private CompanionFacade companion;

            public CompanionNode(CompanionFacade companion) {
                this.companion = companion;
            }

            @Override
            public Object getValueAt(int column) {
                if (column == 0) {
                    return this.companion;
                }
                return null;
            }

            @Override
            public String toString() {
                return this.companion.getNameRef().getReference();
            }
        }
    }

    private static enum CompanionTreeView implements TreeView<CompanionStubFacade>
    {
        NAME("in_race");

        private String name;

        private CompanionTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<CompanionStubFacade>> getPaths(CompanionStubFacade pobj) {
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<CompanionStubFacade>(pobj));
                }
            }
            throw new InternalError();
        }
    }

    private class CompanionDialog
    extends JDialog
    implements TreeViewModel<CompanionStubFacade>,
    DataView<CompanionStubFacade>,
    ActionListener {
        private final FilteredCompanionList model;
        private final JButton selectButton;
        private final FilteredTreeViewTable raceTable;
        private CharacterFacade character;
        private String companionType;
        private CharacterFacade newCompanion;
        private DefaultListFacade<CompanionTreeView> treeViews;

        public CompanionDialog() {
            super(JOptionPane.getFrameForComponent(CompanionInfoTab.this), true);
            this.treeViews = new DefaultListFacade<CompanionTreeView>(Arrays.asList(CompanionTreeView.values()));
            this.model = new FilteredCompanionList();
            this.selectButton = new JButton();
            this.raceTable = new FilteredTreeViewTable();
            this.initComponents();
            this.pack();
        }

        private void initComponents() {
            this.setTitle(LanguageBundle.getString("in_companionSelectRace"));
            this.setLayout(new BorderLayout());
            Container container = this.getContentPane();
            final ListSelectionModel selectionModel = this.raceTable.getSelectionModel();
            selectionModel.setSelectionMode(0);
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        CompanionDialog.this.selectButton.setEnabled(!selectionModel.isSelectionEmpty());
                    }
                }
            });
            SearchFilterPanel searchBar = new SearchFilterPanel();
            container.add((Component)searchBar, "North");
            this.raceTable.setDisplayableFilter(searchBar);
            this.raceTable.addActionListener(this);
            this.raceTable.setTreeViewModel(this);
            container.add((Component)new JScrollPane(this.raceTable), "Center");
            JPanel buttonPane = new JPanel(new FlowLayout());
            this.selectButton.addActionListener(this);
            this.selectButton.setEnabled(false);
            this.selectButton.setActionCommand("SELECT");
            buttonPane.add(this.selectButton);
            JButton cancelButton = new JButton(LanguageBundle.getString("in_cancel"));
            cancelButton.addActionListener(this);
            cancelButton.setActionCommand("CANCEL");
            buttonPane.add(cancelButton);
            container.add((Component)buttonPane, "South");
            Utility.installEscapeCloseOperation(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!"null".equals(e.getActionCommand())) {
                if ("SELECT".equals(e.getActionCommand()) || 2042 == e.getID()) {
                    this.newCompanion = CharacterManager.createNewCharacter(this.character.getUIDelegate(), this.character.getDataSet());
                    CompanionStubFacade selected = (CompanionStubFacade)this.raceTable.getSelectedObject();
                    this.newCompanion.setRace(selected.getRaceRef().getReference());
                    this.character.getCompanionSupport().addCompanion(this.newCompanion, this.companionType);
                    this.setVisible(false);
                } else {
                    this.newCompanion = null;
                    this.setVisible(false);
                }
            }
        }

        public void setCharacter(CharacterFacade character) {
            this.character = character;
            this.model.setDelegate(character.getCompanionSupport().getAvailableCompanions());
        }

        public void setCompanionType(String type) {
            this.companionType = type;
            this.model.setCompanionType(type);
            this.selectButton.setText(LanguageBundle.getFormattedString("in_companionCreateType", type));
            this.newCompanion = null;
        }

        @Override
        public ListFacade<? extends TreeView<CompanionStubFacade>> getTreeViews() {
            return this.treeViews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<CompanionStubFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<CompanionStubFacade> getDataModel() {
            return this.model;
        }

        @Override
        public List<?> getData(CompanionStubFacade obj) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return Collections.emptyList();
        }

        @Override
        public String getPrefsKey() {
            return "CompanionAvail";
        }

        public CharacterFacade getNewCompanion() {
            return this.newCompanion;
        }
    }

    private static class FilteredCompanionList
    extends FilteredListFacade<String, CompanionStubFacade>
    implements Filter<String, CompanionStubFacade> {
        public FilteredCompanionList() {
            this.setFilter(this);
        }

        public void setCompanionType(String type) {
            this.setContext(type);
        }

        @Override
        public boolean accept(String context, CompanionStubFacade element) {
            if (context == null) {
                return true;
            }
            return context.equals(element.getCompanionType());
        }
    }

    private class ButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final String CREATE_COMMAND = "New";
        private static final String REMOVE_COMMAND = "Remove";
        private final JButton button = new JButton();
        private final JPanel container = new JPanel();
        private final DefaultTableCellRenderer background = new DefaultTableCellRenderer();
        private final CharacterFacade character;
        private Object selectedElement;

        public ButtonCellEditor(CharacterFacade character) {
            this.character = character;
            this.button.addActionListener(this);
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.container.setOpaque(true);
            this.container.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 13;
            gbc.fill = 3;
            this.container.add((Component)this.button, gbc);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.background.getTableCellRendererComponent(table, null, true, false, row, column);
            this.container.setBackground(this.background.getBackground());
            this.selectedElement = table.getValueAt(row, 0);
            if (this.selectedElement instanceof CompanionFacade) {
                this.button.setText(LanguageBundle.getString("in_companionRemove"));
                this.button.setActionCommand(REMOVE_COMMAND);
            } else {
                this.button.setText(LanguageBundle.getString("in_companionCreateNew"));
                this.button.setActionCommand(CREATE_COMMAND);
            }
            return this.container;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompanionSupportFacade support = this.character.getCompanionSupport();
            if (REMOVE_COMMAND.equals(e.getActionCommand())) {
                CompanionFacade companion = (CompanionFacade)this.selectedElement;
                int ret = JOptionPane.showConfirmDialog(this.button, LanguageBundle.getFormattedString("in_companionConfirmRemovalMsg", companion.getNameRef().getReference()), LanguageBundle.getString("in_companionConfirmRemoval"), 0);
                if (ret == 0) {
                    support.removeCompanion(companion);
                }
            }
            if (CREATE_COMMAND.equals(e.getActionCommand())) {
                CompanionInfoTab.this.initDialog();
                String type = (String)this.selectedElement;
                CompanionInfoTab.this.companionDialog.setCharacter(this.character);
                CompanionInfoTab.this.companionDialog.setCompanionType(type);
                Utility.setDialogRelativeLocation(CompanionInfoTab.this, CompanionInfoTab.this.companionDialog);
                CompanionInfoTab.this.companionDialog.setVisible(true);
                CharacterFacade comp = CompanionInfoTab.this.companionDialog.getNewCompanion();
                if (comp != null) {
                    CompanionInfoTab.this.selectCompanion(comp);
                }
            }
            this.cancelCellEditing();
        }
    }

    private static class ButtonCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JButton button = new JButton();
        private final DefaultTableCellRenderer background = new DefaultTableCellRenderer();

        public ButtonCellRenderer() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 13;
            gbc.fill = 3;
            this.add((Component)this.button, gbc);
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.background.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            this.setBackground(this.background.getBackground());
            value = table.getValueAt(row, 0);
            if (value instanceof CompanionFacade) {
                this.button.setText(LanguageBundle.getString("in_companionRemove"));
            } else {
                this.button.setText(LanguageBundle.getString("in_companionCreateNew"));
            }
            value = table.getValueAt(row, 1);
            if (value instanceof Boolean) {
                this.button.setEnabled((Boolean)value);
            } else {
                this.button.setEnabled(true);
            }
            return this;
        }
    }

    private class LoadButtonAndSheetHandler
    extends AbstractAction
    implements ListSelectionListener {
        private final HtmlSheetSupport sheetSupport;
        private int selectedRow;
        private ListSelectionModel selectionModel;
        private PCGenFrame frame;

        public LoadButtonAndSheetHandler() {
            File sheet = FileUtils.getFile((String[])new String[]{ConfigurationSettings.getPreviewDir(), "companions", "compact_companion.htm"});
            this.sheetSupport = new HtmlSheetSupport(CompanionInfoTab.this.infoPane, sheet.getAbsolutePath());
            this.selectedRow = -1;
            this.selectionModel = CompanionInfoTab.this.companionsTable.getSelectionModel();
            this.frame = (PCGenFrame)JOptionPane.getFrameForComponent(CompanionInfoTab.this);
        }

        public void install() {
            this.configureButton();
            CompanionInfoTab.this.loadButton.setAction(this);
            if (this.selectedRow == -1) {
                this.selectionModel.clearSelection();
            } else {
                this.selectionModel.setSelectionInterval(this.selectedRow, this.selectedRow);
            }
            this.selectionModel.addListSelectionListener(this);
            this.showCompanion(false);
            this.sheetSupport.install();
        }

        public void uninstall() {
            this.selectionModel.removeListSelectionListener(this);
            this.sheetSupport.uninstall();
        }

        private void configureButton() {
            CompanionFacade companion = this.getSelectedCompanion();
            this.setEnabled(companion != null);
            if (companion != null && this.isCompanionOpen(companion)) {
                this.putValue("Name", LanguageBundle.getString("in_companionSwitchTo"));
            } else {
                this.putValue("Name", LanguageBundle.getString("in_companionLoadComp"));
            }
        }

        void showCompanion(boolean switchTabs) {
            CompanionFacade companion = this.getSelectedCompanion();
            if (companion == null) {
                if (!switchTabs) {
                    CompanionInfoTab.this.infoPane.setText("");
                }
                return;
            }
            if (this.isCompanionOpen(companion)) {
                CharacterFacade character = CharacterManager.getCharacterMatching(companion);
                if (character != null) {
                    if (switchTabs) {
                        this.frame.setSelectedCharacter(character);
                        return;
                    }
                    this.sheetSupport.setCharacter(character);
                    this.sheetSupport.refresh();
                }
            } else if (switchTabs) {
                this.frame.loadCharacterFromFile(companion.getFileRef().getReference());
            } else {
                CompanionInfoTab.this.infoPane.setText(LanguageBundle.getString("in_companionLoadCompanionMessage"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showCompanion(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.selectedRow = this.selectionModel.getMinSelectionIndex();
            this.configureButton();
            this.showCompanion(false);
        }

        private CompanionFacade getSelectedCompanion() {
            if (this.selectedRow == -1) {
                return null;
            }
            Object value = CompanionInfoTab.this.companionsTable.getValueAt(this.selectedRow, 0);
            if (value instanceof CompanionFacade) {
                return (CompanionFacade)value;
            }
            return null;
        }

        private boolean isCompanionOpen(CompanionFacade companion) {
            File compFile = companion.getFileRef().getReference();
            if (compFile == null) {
                return true;
            }
            for (CharacterFacade character : CharacterManager.getCharacters()) {
                File charFile = character.getFileRef().getReference();
                if (!compFile.equals(charFile)) continue;
                return true;
            }
            return false;
        }
    }

    private class TreeExpansionHandler
    implements TreeExpansionListener {
        private final JTree tree;
        private List<TreePath> expandedPaths = Collections.emptyList();

        public TreeExpansionHandler() {
            this.tree = CompanionInfoTab.this.companionsTable.getTree();
        }

        public void install() {
            for (TreePath path : this.expandedPaths) {
                this.tree.expandPath(path);
            }
            this.tree.addTreeExpansionListener(this);
        }

        public void uninstall() {
            this.tree.removeTreeExpansionListener(this);
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.saveExpansionState();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.saveExpansionState();
        }

        private void saveExpansionState() {
            Object root = CompanionInfoTab.this.companionsTable.getTreeTableModel().getRoot();
            Enumeration<TreePath> paths = this.tree.getExpandedDescendants(new TreePath(root));
            this.expandedPaths = Collections.list(paths);
        }
    }
}

