/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.TempBonusFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilteredListFacade;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class TempBonusInfoTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private static final long serialVersionUID = 4521237435574462482L;
    private final TabTitle tabTitle = new TabTitle(Tab.TEMPBONUS);
    private final FilteredTreeViewTable<CharacterFacade, TempBonusFacade> availableTable = new FilteredTreeViewTable();
    private final FilteredTreeViewTable<CharacterFacade, TempBonusFacade> selectedTable = new FilteredTreeViewTable();
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final InfoPane infoPane = new InfoPane(LanguageBundle.getString("in_InfoTempMod"));
    private final TempBonusRenderer tempBonusRenderer = new TempBonusRenderer();

    public TempBonusInfoTab() {
        super("TempBonus");
        this.initComponents();
    }

    private void initComponents() {
        FlippingSplitPane topPane = new FlippingSplitPane("TempBonusTop");
        this.setTopComponent(topPane);
        this.setOrientation(0);
        JPanel availPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        availPanel.add(bar, "North");
        this.availableTable.setDisplayableFilter(bar);
        this.availableTable.setTreeCellRenderer(this.tempBonusRenderer);
        this.availableTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.availableTable.sortModel();
        availPanel.add((Component)new JScrollPane(this.availableTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.addButton.setHorizontalTextPosition(10);
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        topPane.setLeftComponent(availPanel);
        JPanel selPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.selectedTable.setDisplayableFilter(filterBar);
        this.selectedTable.setTreeCellRenderer(this.tempBonusRenderer);
        this.selectedTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.selectedTable.sortModel();
        selPanel.add((Component)new JScrollPane(this.selectedTable), "Center");
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box, "South");
        topPane.setRightComponent(selPanel);
        this.setBottomComponent(this.infoPane);
        this.setResizeWeight(0.75);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(TreeViewModelHandler.class, new TreeViewModelHandler(character));
        models.put(InfoHandler.class, new InfoHandler(character));
        models.put(AddAction.class, new AddAction(character));
        models.put(RemoveAction.class, new RemoveAction(character));
        models.put(CharacterTreeCellRenderer.Handler.class, this.tempBonusRenderer.createHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(CharacterTreeCellRenderer.Handler.class).install();
        models.get(TreeViewModelHandler.class).install();
        models.get(InfoHandler.class).install();
        models.get(AddAction.class).install();
        models.get(RemoveAction.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(InfoHandler.class).uninstall();
        models.get(AddAction.class).uninstall();
        models.get(RemoveAction.class).uninstall();
        models.get(CharacterTreeCellRenderer.Handler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    private static enum TempBonusTreeView implements TreeView<TempBonusFacade>
    {
        NAME("in_nameLabel"),
        ORIGIN_NAME("in_itmOriginName"),
        SOURCE_NAME("in_sourceName"),
        TARGET_NAME("in_itmTargetName");

        private final String name;
        private InfoFactory infoFactory;

        private TempBonusTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        public void setInfoFactory(InfoFactory factory) {
            this.infoFactory = factory;
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<TempBonusFacade>> getPaths(TempBonusFacade bonus) {
            switch (this) {
                case TARGET_NAME: {
                    if (this.infoFactory != null) {
                        return Collections.singletonList(new TreeViewPath<TempBonusFacade>(bonus, (Object)this.infoFactory.getTempBonusTarget(bonus)));
                    }
                }
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<TempBonusFacade>(bonus));
                }
                case ORIGIN_NAME: {
                    return Collections.singletonList(new TreeViewPath<TempBonusFacade>(bonus, (Object)bonus.getOriginType()));
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<TempBonusFacade>(bonus, (Object)bonus.getSourceForNodeDisplay()));
                }
            }
            throw new InternalError();
        }
    }

    private static class TempBonusTreeViewModel
    implements TreeViewModel<TempBonusFacade>,
    DataView<TempBonusFacade>,
    Filter<CharacterFacade, TempBonusFacade>,
    ListListener<TempBonusFacade> {
        private static final DefaultListFacade<? extends TreeView<TempBonusFacade>> treeViews = new DefaultListFacade<TempBonusTreeView>(Arrays.asList(TempBonusTreeView.values()));
        private final List<DefaultDataViewColumn> columns;
        private final CharacterFacade character;
        private final InfoFactory infoFactory;
        private final boolean isAvailModel;
        private FilteredListFacade<CharacterFacade, TempBonusFacade> tempBonuses;

        public TempBonusTreeViewModel(CharacterFacade character, boolean isAvailModel) {
            this.character = character;
            this.infoFactory = character.getInfoFactory();
            this.isAvailModel = isAvailModel;
            if (isAvailModel) {
                this.tempBonuses = new FilteredListFacade();
                this.tempBonuses.setContext(character);
                this.tempBonuses.setFilter(this);
                this.tempBonuses.setDelegate(character.getAvailableTempBonuses());
                character.getAvailableTempBonuses().addListListener(this);
                this.columns = Arrays.asList(new DefaultDataViewColumn("in_itmFrom", String.class, true), new DefaultDataViewColumn("in_itmTarget", String.class, true), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false));
            } else {
                this.tempBonuses = null;
                this.columns = Arrays.asList(new DefaultDataViewColumn("in_itmFrom", String.class, false), new DefaultDataViewColumn("in_itmTarget", String.class, true), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false));
            }
        }

        public void install() {
            for (TempBonusTreeView tbTreeView : TempBonusTreeView.values()) {
                tbTreeView.setInfoFactory(this.infoFactory);
            }
        }

        @Override
        public ListFacade<? extends TreeView<TempBonusFacade>> getTreeViews() {
            return treeViews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return this.isAvailModel ? 1 : 0;
        }

        @Override
        public DataView<TempBonusFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<TempBonusFacade> getDataModel() {
            if (this.isAvailModel) {
                return this.tempBonuses;
            }
            return this.character.getTempBonuses();
        }

        @Override
        public List<?> getData(TempBonusFacade obj) {
            return Arrays.asList(obj.getOriginType(), this.infoFactory.getTempBonusTarget(obj), this.infoFactory.getDescription(obj), obj.getSource());
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public void elementAdded(ListEvent<TempBonusFacade> e) {
            this.tempBonuses.refilter();
        }

        @Override
        public void elementRemoved(ListEvent<TempBonusFacade> e) {
            this.tempBonuses.refilter();
        }

        @Override
        public void elementsChanged(ListEvent<TempBonusFacade> e) {
            this.tempBonuses.refilter();
        }

        @Override
        public void elementModified(ListEvent<TempBonusFacade> e) {
            this.tempBonuses.refilter();
        }

        @Override
        public boolean accept(CharacterFacade context, TempBonusFacade element) {
            return !context.getTempBonuses().containsElement(element);
        }

        @Override
        public String getPrefsKey() {
            return this.isAvailModel ? "TempModsTreeAvail" : "TempModsTreeSelected";
        }
    }

    private class TreeViewModelHandler {
        private final TempBonusTreeViewModel availableModel;
        private final TempBonusTreeViewModel selectedModel;

        public TreeViewModelHandler(CharacterFacade character) {
            this.availableModel = new TempBonusTreeViewModel(character, true);
            this.selectedModel = new TempBonusTreeViewModel(character, false);
        }

        public void install() {
            this.availableModel.install();
            TempBonusInfoTab.this.availableTable.setTreeViewModel(this.availableModel);
            this.selectedModel.install();
            TempBonusInfoTab.this.selectedTable.setTreeViewModel(this.selectedModel);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 2922387838116495051L;
        private CharacterFacade character;

        public RemoveAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_itmInitCompRemoveButTitle"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = TempBonusInfoTab.this.selectedTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof TempBonusFacade)) continue;
                this.character.removeTempBonus((TempBonusFacade)object);
                return;
            }
        }

        public void install() {
            TempBonusInfoTab.this.selectedTable.addActionListener(this);
            TempBonusInfoTab.this.removeButton.setAction(this);
        }

        public void uninstall() {
            TempBonusInfoTab.this.selectedTable.removeActionListener(this);
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = -6640460398947215666L;
        private CharacterFacade character;

        public AddAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_itmInitCompAppBonTitle"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = TempBonusInfoTab.this.availableTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof TempBonusFacade)) continue;
                this.character.addTempBonus((TempBonusFacade)object);
                return;
            }
        }

        public void install() {
            TempBonusInfoTab.this.availableTable.addActionListener(this);
            TempBonusInfoTab.this.addButton.setAction(this);
        }

        public void uninstall() {
            TempBonusInfoTab.this.availableTable.removeActionListener(this);
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;

        public InfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            TempBonusInfoTab.this.availableTable.getSelectionModel().addListSelectionListener(this);
            TempBonusInfoTab.this.selectedTable.getSelectionModel().addListSelectionListener(this);
            TempBonusInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            TempBonusInfoTab.this.availableTable.getSelectionModel().removeListSelectionListener(this);
            TempBonusInfoTab.this.selectedTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object obj = null;
                if (e.getSource() == TempBonusInfoTab.this.availableTable.getSelectionModel()) {
                    int selectedRow = TempBonusInfoTab.this.availableTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = TempBonusInfoTab.this.availableTable.getModel().getValueAt(selectedRow, 0);
                    }
                } else {
                    int selectedRow = TempBonusInfoTab.this.selectedTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = TempBonusInfoTab.this.selectedTable.getModel().getValueAt(selectedRow, 0);
                    }
                }
                if (obj instanceof TempBonusFacade) {
                    this.text = this.character.getInfoFactory().getHTMLInfo((TempBonusFacade)obj);
                    TempBonusInfoTab.this.infoPane.setText(this.text);
                }
            }
        }
    }

    private static class TempBonusRenderer
    extends CharacterTreeCellRenderer {
        private static final long serialVersionUID = -9006249573217208478L;

        private TempBonusRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if ("".equals(obj)) {
                obj = LanguageBundle.getString("in_none");
            }
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, focus);
            if (value instanceof TempBonusFacade && !this.character.isQualifiedFor((TempBonusFacade)value)) {
                this.setForeground(UIPropertyContext.getNotQualifiedColor());
            }
            if (value instanceof InfoFacade && ((InfoFacade)value).isNamePI()) {
                this.setFont(FontManipulation.bold_italic(this.getFont()));
            } else {
                this.setFont(FontManipulation.plain(this.getFont()));
            }
            return this;
        }
    }
}

