/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.UIManager;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

class ImagePreviewer
extends JComponent {
    private static final int SIZE = 200;
    private static String in_notAnImage = LanguageBundle.getString("in_ImagePreview_notAnImage");
    private BufferedImage image;

    public ImagePreviewer() {
        this.setPreferredSize(new Dimension(200, 200));
    }

    public void setImage(File file) {
        if (null == file || !file.exists()) {
            this.image = null;
            return;
        }
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException ex) {
            Logging.errorPrint("Could not read image", ex);
        }
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(UIManager.getColor("Panel.background"));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int textX = ImagePreviewer.getFontHeightHint(g);
        int textY = 200 - ImagePreviewer.getFontHeightHint(g);
        if (null != this.image) {
            int width = this.image.getWidth(null);
            int height = this.image.getHeight(null);
            int side = Math.max(width, height);
            double scale = 200.0 / (double)side;
            g.drawImage(this.image, 0, 0, (int)(scale * (double)width), (int)(scale * (double)height), null);
            String dim = width + " x " + height;
            g.setColor(Color.black);
            g.drawString(dim, textX, textY);
            g.setColor(Color.white);
            g.drawString(dim, textX - 1, textX - 1);
        } else {
            g.setColor(UIManager.getColor("Panel.foreground"));
            g.drawString(in_notAnImage, textX, textY);
        }
    }

    private static int getFontHeightHint(Graphics g) {
        return g.getFontMetrics().getHeight();
    }
}

