/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private Color shadow;
    private Color darkShadow;
    private Color highlight;
    private int direction;
    private int size;

    public ArrowIcon(int direction, int size, Color background, Color shadow, Color darkShadow, Color highlight) {
        this.shadow = shadow;
        this.darkShadow = darkShadow;
        this.highlight = highlight;
        this.direction = direction;
        this.size = size;
    }

    public ArrowIcon(int direction, int size) {
        this(direction, size, UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintTriangle(g, x, y, this.size, this.direction, true);
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    public void paintTriangle(Graphics g, int x, int y, int triangleSize, int triangleDir, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        triangleSize = Math.max(triangleSize, 2);
        int mid = triangleSize / 2 - 1;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(this.darkShadow);
        } else {
            g.setColor(this.shadow);
        }
        switch (triangleDir) {
            case 1: {
                int i;
                for (i = 0; i < triangleSize; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    for (i = triangleSize - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                for (i = triangleSize - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i;
                for (i = 0; i < triangleSize; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    for (i = triangleSize - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                for (i = triangleSize - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

